/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAudienceGenerationJobRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<StartAudienceGenerationJobRequest.Builder, StartAudienceGenerationJobRequest> {
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(StartAudienceGenerationJobRequest::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(StartAudienceGenerationJobRequest::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StartAudienceGenerationJobRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> INCLUDE_SEED_IN_OUTPUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeSeedInOutput").getter(getter(StartAudienceGenerationJobRequest::includeSeedInOutput))
            .setter(setter(Builder::includeSeedInOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeSeedInOutput").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartAudienceGenerationJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<AudienceGenerationJobDataSource> SEED_AUDIENCE_FIELD = SdkField
            .<AudienceGenerationJobDataSource> builder(MarshallingType.SDK_POJO).memberName("seedAudience")
            .getter(getter(StartAudienceGenerationJobRequest::seedAudience)).setter(setter(Builder::seedAudience))
            .constructor(AudienceGenerationJobDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedAudience").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartAudienceGenerationJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_ID_FIELD,
            CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, DESCRIPTION_FIELD, INCLUDE_SEED_IN_OUTPUT_FIELD, NAME_FIELD,
            SEED_AUDIENCE_FIELD, TAGS_FIELD));

    private final String collaborationId;

    private final String configuredAudienceModelArn;

    private final String description;

    private final Boolean includeSeedInOutput;

    private final String name;

    private final AudienceGenerationJobDataSource seedAudience;

    private final Map<String, String> tags;

    private StartAudienceGenerationJobRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationId = builder.collaborationId;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.description = builder.description;
        this.includeSeedInOutput = builder.includeSeedInOutput;
        this.name = builder.name;
        this.seedAudience = builder.seedAudience;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the collaboration that contains the audience generation job.
     * </p>
     * 
     * @return The identifier of the collaboration that contains the audience generation job.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model that is used for this audience generation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model that is used for this audience generation
     *         job.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The description of the audience generation job.
     * </p>
     * 
     * @return The description of the audience generation job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the seed audience is included in the audience generation output.
     * </p>
     * 
     * @return Whether the seed audience is included in the audience generation output.
     */
    public final Boolean includeSeedInOutput() {
        return includeSeedInOutput;
    }

    /**
     * <p>
     * The name of the audience generation job.
     * </p>
     * 
     * @return The name of the audience generation job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The seed audience that is used to generate the audience.
     * </p>
     * 
     * @return The seed audience that is used to generate the audience.
     */
    public final AudienceGenerationJobDataSource seedAudience() {
        return seedAudience;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit
     * of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Forecast considers it to be a user tag
     *         and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against
     *         your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(includeSeedInOutput());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(seedAudience());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAudienceGenerationJobRequest)) {
            return false;
        }
        StartAudienceGenerationJobRequest other = (StartAudienceGenerationJobRequest) obj;
        return Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(includeSeedInOutput(), other.includeSeedInOutput()) && Objects.equals(name(), other.name())
                && Objects.equals(seedAudience(), other.seedAudience()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAudienceGenerationJobRequest").add("CollaborationId", collaborationId())
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn()).add("Description", description())
                .add("IncludeSeedInOutput", includeSeedInOutput()).add("Name", name()).add("SeedAudience", seedAudience())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "includeSeedInOutput":
            return Optional.ofNullable(clazz.cast(includeSeedInOutput()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "seedAudience":
            return Optional.ofNullable(clazz.cast(seedAudience()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAudienceGenerationJobRequest, T> g) {
        return obj -> g.apply((StartAudienceGenerationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAudienceGenerationJobRequest> {
        /**
         * <p>
         * The identifier of the collaboration that contains the audience generation job.
         * </p>
         * 
         * @param collaborationId
         *        The identifier of the collaboration that contains the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model that is used for this audience generation
         * job.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model that is used for this audience
         *        generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The description of the audience generation job.
         * </p>
         * 
         * @param description
         *        The description of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the seed audience is included in the audience generation output.
         * </p>
         * 
         * @param includeSeedInOutput
         *        Whether the seed audience is included in the audience generation output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSeedInOutput(Boolean includeSeedInOutput);

        /**
         * <p>
         * The name of the audience generation job.
         * </p>
         * 
         * @param name
         *        The name of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The seed audience that is used to generate the audience.
         * </p>
         * 
         * @param seedAudience
         *        The seed audience that is used to generate the audience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedAudience(AudienceGenerationJobDataSource seedAudience);

        /**
         * <p>
         * The seed audience that is used to generate the audience.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudienceGenerationJobDataSource.Builder}
         * avoiding the need to create one manually via {@link AudienceGenerationJobDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceGenerationJobDataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #seedAudience(AudienceGenerationJobDataSource)}.
         * 
         * @param seedAudience
         *        a consumer that will call methods on {@link AudienceGenerationJobDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #seedAudience(AudienceGenerationJobDataSource)
         */
        default Builder seedAudience(Consumer<AudienceGenerationJobDataSource.Builder> seedAudience) {
            return seedAudience(AudienceGenerationJobDataSource.builder().applyMutation(seedAudience).build());
        }

        /**
         * <p>
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Forecast considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Forecast considers it to be a
         *        user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String collaborationId;

        private String configuredAudienceModelArn;

        private String description;

        private Boolean includeSeedInOutput;

        private String name;

        private AudienceGenerationJobDataSource seedAudience;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAudienceGenerationJobRequest model) {
            super(model);
            collaborationId(model.collaborationId);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            description(model.description);
            includeSeedInOutput(model.includeSeedInOutput);
            name(model.name);
            seedAudience(model.seedAudience);
            tags(model.tags);
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIncludeSeedInOutput() {
            return includeSeedInOutput;
        }

        public final void setIncludeSeedInOutput(Boolean includeSeedInOutput) {
            this.includeSeedInOutput = includeSeedInOutput;
        }

        @Override
        public final Builder includeSeedInOutput(Boolean includeSeedInOutput) {
            this.includeSeedInOutput = includeSeedInOutput;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AudienceGenerationJobDataSource.Builder getSeedAudience() {
            return seedAudience != null ? seedAudience.toBuilder() : null;
        }

        public final void setSeedAudience(AudienceGenerationJobDataSource.BuilderImpl seedAudience) {
            this.seedAudience = seedAudience != null ? seedAudience.build() : null;
        }

        @Override
        public final Builder seedAudience(AudienceGenerationJobDataSource seedAudience) {
            this.seedAudience = seedAudience;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAudienceGenerationJobRequest build() {
            return new StartAudienceGenerationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
