/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Glue data source that contains the training data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueDataSource implements SdkPojo, Serializable, ToCopyableBuilder<GlueDataSource.Builder, GlueDataSource> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("catalogId").getter(getter(GlueDataSource::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(GlueDataSource::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(GlueDataSource::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private GlueDataSource(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
    }

    /**
     * <p>
     * The Glue catalog that contains the training data.
     * </p>
     * 
     * @return The Glue catalog that contains the training data.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The Glue database that contains the training data.
     * </p>
     * 
     * @return The Glue database that contains the training data.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The Glue table that contains the training data.
     * </p>
     * 
     * @return The Glue table that contains the training data.
     */
    public final String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueDataSource)) {
            return false;
        }
        GlueDataSource other = (GlueDataSource) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlueDataSource").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlueDataSource, T> g) {
        return obj -> g.apply((GlueDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueDataSource> {
        /**
         * <p>
         * The Glue catalog that contains the training data.
         * </p>
         * 
         * @param catalogId
         *        The Glue catalog that contains the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The Glue database that contains the training data.
         * </p>
         * 
         * @param databaseName
         *        The Glue database that contains the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The Glue table that contains the training data.
         * </p>
         * 
         * @param tableName
         *        The Glue table that contains the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    static final class BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueDataSource model) {
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public GlueDataSource build() {
            return new GlueDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
