/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.RelevanceMetric;
import software.amazon.awssdk.services.cleanroomsml.model.RelevanceMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudienceQualityMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudienceQualityMetrics> {
    private static final SdkField<Double> RECALL_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("recallMetric").getter(AudienceQualityMetrics.getter(AudienceQualityMetrics::recallMetric)).setter(AudienceQualityMetrics.setter(Builder::recallMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recallMetric").build()}).build();
    private static final SdkField<List<RelevanceMetric>> RELEVANCE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relevanceMetrics").getter(AudienceQualityMetrics.getter(AudienceQualityMetrics::relevanceMetrics)).setter(AudienceQualityMetrics.setter(Builder::relevanceMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelevanceMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECALL_METRIC_FIELD, RELEVANCE_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double recallMetric;
    private final List<RelevanceMetric> relevanceMetrics;

    private AudienceQualityMetrics(BuilderImpl builder) {
        this.recallMetric = builder.recallMetric;
        this.relevanceMetrics = builder.relevanceMetrics;
    }

    public final Double recallMetric() {
        return this.recallMetric;
    }

    public final boolean hasRelevanceMetrics() {
        return this.relevanceMetrics != null && !(this.relevanceMetrics instanceof SdkAutoConstructList);
    }

    public final List<RelevanceMetric> relevanceMetrics() {
        return this.relevanceMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recallMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelevanceMetrics() ? this.relevanceMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceQualityMetrics)) {
            return false;
        }
        AudienceQualityMetrics other = (AudienceQualityMetrics)obj;
        return Objects.equals(this.recallMetric(), other.recallMetric()) && this.hasRelevanceMetrics() == other.hasRelevanceMetrics() && Objects.equals(this.relevanceMetrics(), other.relevanceMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"AudienceQualityMetrics").add("RecallMetric", (Object)this.recallMetric()).add("RelevanceMetrics", this.hasRelevanceMetrics() ? this.relevanceMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recallMetric": {
                return Optional.ofNullable(clazz.cast(this.recallMetric()));
            }
            case "relevanceMetrics": {
                return Optional.ofNullable(clazz.cast(this.relevanceMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudienceQualityMetrics, T> g) {
        return obj -> g.apply((AudienceQualityMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double recallMetric;
        private List<RelevanceMetric> relevanceMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceQualityMetrics model) {
            this.recallMetric(model.recallMetric);
            this.relevanceMetrics(model.relevanceMetrics);
        }

        public final Double getRecallMetric() {
            return this.recallMetric;
        }

        public final void setRecallMetric(Double recallMetric) {
            this.recallMetric = recallMetric;
        }

        @Override
        public final Builder recallMetric(Double recallMetric) {
            this.recallMetric = recallMetric;
            return this;
        }

        public final List<RelevanceMetric.Builder> getRelevanceMetrics() {
            List<RelevanceMetric.Builder> result = RelevanceMetricsCopier.copyToBuilder(this.relevanceMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelevanceMetrics(Collection<RelevanceMetric.BuilderImpl> relevanceMetrics) {
            this.relevanceMetrics = RelevanceMetricsCopier.copyFromBuilder(relevanceMetrics);
        }

        @Override
        public final Builder relevanceMetrics(Collection<RelevanceMetric> relevanceMetrics) {
            this.relevanceMetrics = RelevanceMetricsCopier.copy(relevanceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relevanceMetrics(RelevanceMetric ... relevanceMetrics) {
            this.relevanceMetrics(Arrays.asList(relevanceMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relevanceMetrics(Consumer<RelevanceMetric.Builder> ... relevanceMetrics) {
            this.relevanceMetrics(Stream.of(relevanceMetrics).map(c -> (RelevanceMetric)((RelevanceMetric.Builder)RelevanceMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AudienceQualityMetrics build() {
            return new AudienceQualityMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudienceQualityMetrics> {
        public Builder recallMetric(Double var1);

        public Builder relevanceMetrics(Collection<RelevanceMetric> var1);

        public Builder relevanceMetrics(RelevanceMetric ... var1);

        public Builder relevanceMetrics(Consumer<RelevanceMetric.Builder> ... var1);
    }
}

