/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the status of a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusDetails implements SdkPojo, Serializable, ToCopyableBuilder<StatusDetails.Builder, StatusDetails> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(StatusDetails::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(StatusDetails::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            STATUS_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String statusCodeValue;

    private StatusDetails(BuilderImpl builder) {
        this.message = builder.message;
        this.statusCodeValue = builder.statusCodeValue;
    }

    /**
     * <p>
     * The error message that was returned. The message is intended for human consumption and can change at any time.
     * Use the <code>statusCode</code> for programmatic error handling.
     * </p>
     * 
     * @return The error message that was returned. The message is intended for human consumption and can change at any
     *         time. Use the <code>statusCode</code> for programmatic error handling.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The status code that was returned. The status code is intended for programmatic error handling. Clean Rooms ML
     * will not change the status code for existing error conditions.
     * </p>
     * 
     * @return The status code that was returned. The status code is intended for programmatic error handling. Clean
     *         Rooms ML will not change the status code for existing error conditions.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusDetails)) {
            return false;
        }
        StatusDetails other = (StatusDetails) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusDetails").add("Message", message()).add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatusDetails, T> g) {
        return obj -> g.apply((StatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusDetails> {
        /**
         * <p>
         * The error message that was returned. The message is intended for human consumption and can change at any
         * time. Use the <code>statusCode</code> for programmatic error handling.
         * </p>
         * 
         * @param message
         *        The error message that was returned. The message is intended for human consumption and can change at
         *        any time. Use the <code>statusCode</code> for programmatic error handling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The status code that was returned. The status code is intended for programmatic error handling. Clean Rooms
         * ML will not change the status code for existing error conditions.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code that was returned. The status code is intended for programmatic error handling. Clean
         *        Rooms ML will not change the status code for existing error conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusDetails model) {
            message(model.message);
            statusCode(model.statusCodeValue);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public StatusDetails build() {
            return new StatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
