/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cleanroomsml.model.AccessDeniedException;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlException;
import software.amazon.awssdk.services.cleanroomsml.model.ConflictException;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cleanroomsml.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ValidationException;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable;

/**
 * Service client for accessing AWS Clean Rooms ML. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Welcome to the <i>Amazon Web Services Clean Rooms ML API Reference</i>.
 * </p>
 * <p>
 * Amazon Web Services Clean Rooms ML provides a privacy-enhancing method for two parties to identify similar users in
 * their data without the need to share their data with each other. The first party brings the training data to Clean
 * Rooms so that they can create and configure an audience model (lookalike model) and associate it with a
 * collaboration. The second party then brings their seed data to Clean Rooms and generates an audience (lookalike
 * segment) that resembles the training data.
 * </p>
 * <p>
 * To learn more about Amazon Web Services Clean Rooms ML concepts, procedures, and best practices, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/machine-learning.html">Clean Rooms User Guide</a>.
 * </p>
 * <p>
 * To learn more about SQL commands, functions, and conditions supported in Clean Rooms, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/sql-reference/sql-reference.html">Clean Rooms SQL Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CleanRoomsMlClient extends AwsClient {
    String SERVICE_NAME = "cleanrooms-ml";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cleanrooms-ml";

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     *
     * @param createAudienceModelRequest
     * @return Result of the CreateAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAudienceModelResponse createAudienceModel(CreateAudienceModelRequest createAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAudienceModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAudienceModelRequest#builder()}
     * </p>
     *
     * @param createAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAudienceModelResponse createAudienceModel(
            Consumer<CreateAudienceModelRequest.Builder> createAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createAudienceModel(CreateAudienceModelRequest.builder().applyMutation(createAudienceModelRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     * @return Result of the CreateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredAudienceModelResponse createConfiguredAudienceModel(
            CreateConfiguredAudienceModelRequest createConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return Result of the CreateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredAudienceModelResponse createConfiguredAudienceModel(
            Consumer<CreateConfiguredAudienceModelRequest.Builder> createConfiguredAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createConfiguredAudienceModel(CreateConfiguredAudienceModelRequest.builder()
                .applyMutation(createConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset, or seed audience. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     *
     * @param createTrainingDatasetRequest
     * @return Result of the CreateTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrainingDatasetResponse createTrainingDataset(CreateTrainingDatasetRequest createTrainingDatasetRequest)
            throws ConflictException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset, or seed audience. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param createTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest.Builder} to create
     *        a request.
     * @return Result of the CreateTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrainingDatasetResponse createTrainingDataset(
            Consumer<CreateTrainingDatasetRequest.Builder> createTrainingDatasetRequest) throws ConflictException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createTrainingDataset(CreateTrainingDatasetRequest.builder().applyMutation(createTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     * @return Result of the DeleteAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAudienceGenerationJobResponse deleteAudienceGenerationJob(
            DeleteAudienceGenerationJobRequest deleteAudienceGenerationJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAudienceGenerationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAudienceGenerationJobResponse deleteAudienceGenerationJob(
            Consumer<DeleteAudienceGenerationJobRequest.Builder> deleteAudienceGenerationJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return deleteAudienceGenerationJob(DeleteAudienceGenerationJobRequest.builder()
                .applyMutation(deleteAudienceGenerationJobRequest).build());
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     *
     * @param deleteAudienceModelRequest
     * @return Result of the DeleteAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAudienceModelResponse deleteAudienceModel(DeleteAudienceModelRequest deleteAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAudienceModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAudienceModelRequest#builder()}
     * </p>
     *
     * @param deleteAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAudienceModelResponse deleteAudienceModel(
            Consumer<DeleteAudienceModelRequest.Builder> deleteAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return deleteAudienceModel(DeleteAudienceModelRequest.builder().applyMutation(deleteAudienceModelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     * @return Result of the DeleteConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredAudienceModelResponse deleteConfiguredAudienceModel(
            DeleteConfiguredAudienceModelRequest deleteConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredAudienceModelResponse deleteConfiguredAudienceModel(
            Consumer<DeleteConfiguredAudienceModelRequest.Builder> deleteConfiguredAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return deleteConfiguredAudienceModel(DeleteConfiguredAudienceModelRequest.builder()
                .applyMutation(deleteConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     * @return Result of the DeleteConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredAudienceModelPolicyResponse deleteConfiguredAudienceModelPolicy(
            DeleteConfiguredAudienceModelPolicyRequest deleteConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredAudienceModelPolicyResponse deleteConfiguredAudienceModelPolicy(
            Consumer<DeleteConfiguredAudienceModelPolicyRequest.Builder> deleteConfiguredAudienceModelPolicyRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return deleteConfiguredAudienceModelPolicy(DeleteConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(deleteConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     * @return Result of the DeleteTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrainingDatasetResponse deleteTrainingDataset(DeleteTrainingDatasetRequest deleteTrainingDatasetRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrainingDatasetResponse deleteTrainingDataset(
            Consumer<DeleteTrainingDatasetRequest.Builder> deleteTrainingDatasetRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return deleteTrainingDataset(DeleteTrainingDatasetRequest.builder().applyMutation(deleteTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     * @return Result of the GetAudienceGenerationJob operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAudienceGenerationJobResponse getAudienceGenerationJob(
            GetAudienceGenerationJobRequest getAudienceGenerationJobRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAudienceGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return Result of the GetAudienceGenerationJob operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAudienceGenerationJobResponse getAudienceGenerationJob(
            Consumer<GetAudienceGenerationJobRequest.Builder> getAudienceGenerationJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return getAudienceGenerationJob(GetAudienceGenerationJobRequest.builder().applyMutation(getAudienceGenerationJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     *
     * @param getAudienceModelRequest
     * @return Result of the GetAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAudienceModelResponse getAudienceModel(GetAudienceModelRequest getAudienceModelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAudienceModelRequest.Builder} avoiding the need
     * to create one manually via {@link GetAudienceModelRequest#builder()}
     * </p>
     *
     * @param getAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest.Builder} to create a
     *        request.
     * @return Result of the GetAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAudienceModelResponse getAudienceModel(Consumer<GetAudienceModelRequest.Builder> getAudienceModelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getAudienceModel(GetAudienceModelRequest.builder().applyMutation(getAudienceModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     * @return Result of the GetConfiguredAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredAudienceModelResponse getConfiguredAudienceModel(
            GetConfiguredAudienceModelRequest getConfiguredAudienceModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredAudienceModelRequest.Builder} avoiding
     * the need to create one manually via {@link GetConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return Result of the GetConfiguredAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredAudienceModelResponse getConfiguredAudienceModel(
            Consumer<GetConfiguredAudienceModelRequest.Builder> getConfiguredAudienceModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return getConfiguredAudienceModel(GetConfiguredAudienceModelRequest.builder()
                .applyMutation(getConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     * @return Result of the GetConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredAudienceModelPolicyResponse getConfiguredAudienceModelPolicy(
            GetConfiguredAudienceModelPolicyRequest getConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the GetConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredAudienceModelPolicyResponse getConfiguredAudienceModelPolicy(
            Consumer<GetConfiguredAudienceModelPolicyRequest.Builder> getConfiguredAudienceModelPolicyRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getConfiguredAudienceModelPolicy(GetConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(getConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     *
     * @param getTrainingDatasetRequest
     * @return Result of the GetTrainingDataset operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrainingDatasetResponse getTrainingDataset(GetTrainingDatasetRequest getTrainingDatasetRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link GetTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param getTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest.Builder} to create a
     *        request.
     * @return Result of the GetTrainingDataset operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrainingDatasetResponse getTrainingDataset(Consumer<GetTrainingDatasetRequest.Builder> getTrainingDatasetRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getTrainingDataset(GetTrainingDatasetRequest.builder().applyMutation(getTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return Result of the ListAudienceExportJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsResponse listAudienceExportJobs(ListAudienceExportJobsRequest listAudienceExportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceExportJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListAudienceExportJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsResponse listAudienceExportJobs(
            Consumer<ListAudienceExportJobsRequest.Builder> listAudienceExportJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceExportJobs(ListAudienceExportJobsRequest.builder().applyMutation(listAudienceExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client.listAudienceExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client
     *             .listAudienceExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client.listAudienceExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsIterable listAudienceExportJobsPaginator(
            ListAudienceExportJobsRequest listAudienceExportJobsRequest) throws ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListAudienceExportJobsIterable(this, listAudienceExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client.listAudienceExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client
     *             .listAudienceExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client.listAudienceExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceExportJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsIterable listAudienceExportJobsPaginator(
            Consumer<ListAudienceExportJobsRequest.Builder> listAudienceExportJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceExportJobsPaginator(ListAudienceExportJobsRequest.builder()
                .applyMutation(listAudienceExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return Result of the ListAudienceGenerationJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsResponse listAudienceGenerationJobs(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAudienceGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAudienceGenerationJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsResponse listAudienceGenerationJobs(
            Consumer<ListAudienceGenerationJobsRequest.Builder> listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceGenerationJobs(ListAudienceGenerationJobsRequest.builder()
                .applyMutation(listAudienceGenerationJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client.listAudienceGenerationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client
     *             .listAudienceGenerationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client.listAudienceGenerationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsIterable listAudienceGenerationJobsPaginator(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListAudienceGenerationJobsIterable(this, listAudienceGenerationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client.listAudienceGenerationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client
     *             .listAudienceGenerationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client.listAudienceGenerationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAudienceGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsIterable listAudienceGenerationJobsPaginator(
            Consumer<ListAudienceGenerationJobsRequest.Builder> listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceGenerationJobsPaginator(ListAudienceGenerationJobsRequest.builder()
                .applyMutation(listAudienceGenerationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return Result of the ListAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsResponse listAudienceModels(ListAudienceModelsRequest listAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsResponse listAudienceModels(Consumer<ListAudienceModelsRequest.Builder> listAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceModels(ListAudienceModelsRequest.builder().applyMutation(listAudienceModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client.listAudienceModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client
     *             .listAudienceModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client.listAudienceModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsIterable listAudienceModelsPaginator(ListAudienceModelsRequest listAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListAudienceModelsIterable(this, listAudienceModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client.listAudienceModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client
     *             .listAudienceModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client.listAudienceModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsIterable listAudienceModelsPaginator(
            Consumer<ListAudienceModelsRequest.Builder> listAudienceModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceModelsPaginator(ListAudienceModelsRequest.builder().applyMutation(listAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return Result of the ListConfiguredAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsResponse listConfiguredAudienceModels(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredAudienceModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest.Builder} to
     *        create a request.
     * @return Result of the ListConfiguredAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsResponse listConfiguredAudienceModels(
            Consumer<ListConfiguredAudienceModelsRequest.Builder> listConfiguredAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listConfiguredAudienceModels(ListConfiguredAudienceModelsRequest.builder()
                .applyMutation(listConfiguredAudienceModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client.listConfiguredAudienceModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client
     *             .listConfiguredAudienceModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client.listConfiguredAudienceModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsIterable listConfiguredAudienceModelsPaginator(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListConfiguredAudienceModelsIterable(this, listConfiguredAudienceModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client.listConfiguredAudienceModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client
     *             .listConfiguredAudienceModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client.listConfiguredAudienceModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredAudienceModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsIterable listConfiguredAudienceModelsPaginator(
            Consumer<ListConfiguredAudienceModelsRequest.Builder> listConfiguredAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listConfiguredAudienceModelsPaginator(ListConfiguredAudienceModelsRequest.builder()
                .applyMutation(listConfiguredAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return Result of the ListTrainingDatasets operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsResponse listTrainingDatasets(ListTrainingDatasetsRequest listTrainingDatasetsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrainingDatasetsRequest#builder()}
     * </p>
     *
     * @param listTrainingDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTrainingDatasets operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsResponse listTrainingDatasets(
            Consumer<ListTrainingDatasetsRequest.Builder> listTrainingDatasetsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTrainingDatasets(ListTrainingDatasetsRequest.builder().applyMutation(listTrainingDatasetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client.listTrainingDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client
     *             .listTrainingDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client.listTrainingDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsIterable listTrainingDatasetsPaginator(ListTrainingDatasetsRequest listTrainingDatasetsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListTrainingDatasetsIterable(this, listTrainingDatasetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client.listTrainingDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client
     *             .listTrainingDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client.listTrainingDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrainingDatasetsRequest#builder()}
     * </p>
     *
     * @param listTrainingDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsIterable listTrainingDatasetsPaginator(
            Consumer<ListTrainingDatasetsRequest.Builder> listTrainingDatasetsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTrainingDatasetsPaginator(ListTrainingDatasetsRequest.builder().applyMutation(listTrainingDatasetsRequest)
                .build());
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     * @return Result of the PutConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfiguredAudienceModelPolicyResponse putConfiguredAudienceModelPolicy(
            PutConfiguredAudienceModelPolicyRequest putConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the PutConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfiguredAudienceModelPolicyResponse putConfiguredAudienceModelPolicy(
            Consumer<PutConfiguredAudienceModelPolicyRequest.Builder> putConfiguredAudienceModelPolicyRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return putConfiguredAudienceModelPolicy(PutConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(putConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     *
     * @param startAudienceExportJobRequest
     * @return Result of the StartAudienceExportJob operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAudienceExportJobResponse startAudienceExportJob(StartAudienceExportJobRequest startAudienceExportJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAudienceExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartAudienceExportJobRequest#builder()}
     * </p>
     *
     * @param startAudienceExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest.Builder} to create
     *        a request.
     * @return Result of the StartAudienceExportJob operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAudienceExportJobResponse startAudienceExportJob(
            Consumer<StartAudienceExportJobRequest.Builder> startAudienceExportJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return startAudienceExportJob(StartAudienceExportJobRequest.builder().applyMutation(startAudienceExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     * @return Result of the StartAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAudienceGenerationJobResponse startAudienceGenerationJob(
            StartAudienceGenerationJobRequest startAudienceGenerationJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAudienceGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAudienceGenerationJobResponse startAudienceGenerationJob(
            Consumer<StartAudienceGenerationJobRequest.Builder> startAudienceGenerationJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return startAudienceGenerationJob(StartAudienceGenerationJobRequest.builder()
                .applyMutation(startAudienceGenerationJobRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     * @return Result of the UpdateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredAudienceModelResponse updateConfiguredAudienceModel(
            UpdateConfiguredAudienceModelRequest updateConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         A resource with that name already exists in this region.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredAudienceModelResponse updateConfiguredAudienceModel(
            Consumer<UpdateConfiguredAudienceModelRequest.Builder> updateConfiguredAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return updateConfiguredAudienceModel(UpdateConfiguredAudienceModelRequest.builder()
                .applyMutation(updateConfiguredAudienceModelRequest).build());
    }

    /**
     * Create a {@link CleanRoomsMlClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CleanRoomsMlClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CleanRoomsMlClient}.
     */
    static CleanRoomsMlClientBuilder builder() {
        return new DefaultCleanRoomsMlClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CleanRoomsMlServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
