/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceSize;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAudienceExportJobRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, StartAudienceExportJobRequest> {
    private static final SdkField<String> AUDIENCE_GENERATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceGenerationJobArn").getter(StartAudienceExportJobRequest.getter(StartAudienceExportJobRequest::audienceGenerationJobArn)).setter(StartAudienceExportJobRequest.setter(Builder::audienceGenerationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobArn").build()}).build();
    private static final SdkField<AudienceSize> AUDIENCE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audienceSize").getter(StartAudienceExportJobRequest.getter(StartAudienceExportJobRequest::audienceSize)).setter(StartAudienceExportJobRequest.setter(Builder::audienceSize)).constructor(AudienceSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSize").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StartAudienceExportJobRequest.getter(StartAudienceExportJobRequest::description)).setter(StartAudienceExportJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartAudienceExportJobRequest.getter(StartAudienceExportJobRequest::name)).setter(StartAudienceExportJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_GENERATION_JOB_ARN_FIELD, AUDIENCE_SIZE_FIELD, DESCRIPTION_FIELD, NAME_FIELD));
    private final String audienceGenerationJobArn;
    private final AudienceSize audienceSize;
    private final String description;
    private final String name;

    private StartAudienceExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.audienceGenerationJobArn = builder.audienceGenerationJobArn;
        this.audienceSize = builder.audienceSize;
        this.description = builder.description;
        this.name = builder.name;
    }

    public final String audienceGenerationJobArn() {
        return this.audienceGenerationJobArn;
    }

    public final AudienceSize audienceSize() {
        return this.audienceSize;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceGenerationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAudienceExportJobRequest)) {
            return false;
        }
        StartAudienceExportJobRequest other = (StartAudienceExportJobRequest)((Object)obj);
        return Objects.equals(this.audienceGenerationJobArn(), other.audienceGenerationJobArn()) && Objects.equals(this.audienceSize(), other.audienceSize()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"StartAudienceExportJobRequest").add("AudienceGenerationJobArn", (Object)this.audienceGenerationJobArn()).add("AudienceSize", (Object)this.audienceSize()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "audienceGenerationJobArn": {
                return Optional.ofNullable(clazz.cast(this.audienceGenerationJobArn()));
            }
            case "audienceSize": {
                return Optional.ofNullable(clazz.cast(this.audienceSize()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAudienceExportJobRequest, T> g) {
        return obj -> g.apply((StartAudienceExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String audienceGenerationJobArn;
        private AudienceSize audienceSize;
        private String description;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAudienceExportJobRequest model) {
            super(model);
            this.audienceGenerationJobArn(model.audienceGenerationJobArn);
            this.audienceSize(model.audienceSize);
            this.description(model.description);
            this.name(model.name);
        }

        public final String getAudienceGenerationJobArn() {
            return this.audienceGenerationJobArn;
        }

        public final void setAudienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
        }

        @Override
        public final Builder audienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
            return this;
        }

        public final AudienceSize.Builder getAudienceSize() {
            return this.audienceSize != null ? this.audienceSize.toBuilder() : null;
        }

        public final void setAudienceSize(AudienceSize.BuilderImpl audienceSize) {
            this.audienceSize = audienceSize != null ? audienceSize.build() : null;
        }

        @Override
        public final Builder audienceSize(AudienceSize audienceSize) {
            this.audienceSize = audienceSize;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAudienceExportJobRequest build() {
            return new StartAudienceExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAudienceExportJobRequest> {
        public Builder audienceGenerationJobArn(String var1);

        public Builder audienceSize(AudienceSize var1);

        default public Builder audienceSize(Consumer<AudienceSize.Builder> audienceSize) {
            return this.audienceSize((AudienceSize)((AudienceSize.Builder)AudienceSize.builder().applyMutation(audienceSize)).build());
        }

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

