/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Glue data source and schema mapping information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetInputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetInputConfig.Builder, DatasetInputConfig> {
    private static final SdkField<List<ColumnSchema>> SCHEMA_FIELD = SdkField
            .<List<ColumnSchema>> builder(MarshallingType.LIST)
            .memberName("schema")
            .getter(getter(DatasetInputConfig::schema))
            .setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("dataSource").getter(getter(DatasetInputConfig::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD,
            DATA_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ColumnSchema> schema;

    private final DataSource dataSource;

    private DatasetInputConfig(BuilderImpl builder) {
        this.schema = builder.schema;
        this.dataSource = builder.dataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Schema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchema() {
        return schema != null && !(schema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The schema information for the training data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchema} method.
     * </p>
     * 
     * @return The schema information for the training data.
     */
    public final List<ColumnSchema> schema() {
        return schema;
    }

    /**
     * <p>
     * A DataSource object that specifies the Glue data source for the training data.
     * </p>
     * 
     * @return A DataSource object that specifies the Glue data source for the training data.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSchema() ? schema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetInputConfig)) {
            return false;
        }
        DatasetInputConfig other = (DatasetInputConfig) obj;
        return hasSchema() == other.hasSchema() && Objects.equals(schema(), other.schema())
                && Objects.equals(dataSource(), other.dataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetInputConfig").add("Schema", hasSchema() ? schema() : null)
                .add("DataSource", dataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetInputConfig, T> g) {
        return obj -> g.apply((DatasetInputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetInputConfig> {
        /**
         * <p>
         * The schema information for the training data.
         * </p>
         * 
         * @param schema
         *        The schema information for the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Collection<ColumnSchema> schema);

        /**
         * <p>
         * The schema information for the training data.
         * </p>
         * 
         * @param schema
         *        The schema information for the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(ColumnSchema... schema);

        /**
         * <p>
         * The schema information for the training data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ColumnSchema.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cleanroomsml.model.ColumnSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ColumnSchema.Builder#build()} is called immediately
         * and its result is passed to {@link #schema(List<ColumnSchema>)}.
         * 
         * @param schema
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.ColumnSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(java.util.Collection<ColumnSchema>)
         */
        Builder schema(Consumer<ColumnSchema.Builder>... schema);

        /**
         * <p>
         * A DataSource object that specifies the Glue data source for the training data.
         * </p>
         * 
         * @param dataSource
         *        A DataSource object that specifies the Glue data source for the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * A DataSource object that specifies the Glue data source for the training data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<ColumnSchema> schema = DefaultSdkAutoConstructList.getInstance();

        private DataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetInputConfig model) {
            schema(model.schema);
            dataSource(model.dataSource);
        }

        public final List<ColumnSchema.Builder> getSchema() {
            List<ColumnSchema.Builder> result = DatasetInputConfigSchemaListCopier.copyToBuilder(this.schema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchema(Collection<ColumnSchema.BuilderImpl> schema) {
            this.schema = DatasetInputConfigSchemaListCopier.copyFromBuilder(schema);
        }

        @Override
        public final Builder schema(Collection<ColumnSchema> schema) {
            this.schema = DatasetInputConfigSchemaListCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(ColumnSchema... schema) {
            schema(Arrays.asList(schema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Consumer<ColumnSchema.Builder>... schema) {
            schema(Stream.of(schema).map(c -> ColumnSchema.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public DatasetInputConfig build() {
            return new DatasetInputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
