/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfiguredAudienceModelResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetConfiguredAudienceModelResponse.Builder, GetConfiguredAudienceModelResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetConfiguredAudienceModelResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetConfiguredAudienceModelResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(GetConfiguredAudienceModelResponse::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetConfiguredAudienceModelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceModelArn").getter(getter(GetConfiguredAudienceModelResponse::audienceModelArn))
            .setter(setter(Builder::audienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()).build();

    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<ConfiguredAudienceModelOutputConfig> builder(MarshallingType.SDK_POJO).memberName("outputConfig")
            .getter(getter(GetConfiguredAudienceModelResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(ConfiguredAudienceModelOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetConfiguredAudienceModelResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetConfiguredAudienceModelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> SHARED_AUDIENCE_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sharedAudienceMetrics")
            .getter(getter(GetConfiguredAudienceModelResponse::sharedAudienceMetricsAsStrings))
            .setter(setter(Builder::sharedAudienceMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAudienceMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MIN_MATCHING_SEED_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minMatchingSeedSize").getter(getter(GetConfiguredAudienceModelResponse::minMatchingSeedSize))
            .setter(setter(Builder::minMatchingSeedSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minMatchingSeedSize").build())
            .build();

    private static final SdkField<AudienceSizeConfig> AUDIENCE_SIZE_CONFIG_FIELD = SdkField
            .<AudienceSizeConfig> builder(MarshallingType.SDK_POJO).memberName("audienceSizeConfig")
            .getter(getter(GetConfiguredAudienceModelResponse::audienceSizeConfig)).setter(setter(Builder::audienceSizeConfig))
            .constructor(AudienceSizeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeConfig").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetConfiguredAudienceModelResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("childResourceTagOnCreatePolicy")
            .getter(getter(GetConfiguredAudienceModelResponse::childResourceTagOnCreatePolicyAsString))
            .setter(setter(Builder::childResourceTagOnCreatePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childResourceTagOnCreatePolicy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, NAME_FIELD, AUDIENCE_MODEL_ARN_FIELD, OUTPUT_CONFIG_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, SHARED_AUDIENCE_METRICS_FIELD, MIN_MATCHING_SEED_SIZE_FIELD,
            AUDIENCE_SIZE_CONFIG_FIELD, TAGS_FIELD, CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD));

    private final Instant createTime;

    private final Instant updateTime;

    private final String configuredAudienceModelArn;

    private final String name;

    private final String audienceModelArn;

    private final ConfiguredAudienceModelOutputConfig outputConfig;

    private final String description;

    private final String status;

    private final List<String> sharedAudienceMetrics;

    private final Integer minMatchingSeedSize;

    private final AudienceSizeConfig audienceSizeConfig;

    private final Map<String, String> tags;

    private final String childResourceTagOnCreatePolicy;

    private GetConfiguredAudienceModelResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.name = builder.name;
        this.audienceModelArn = builder.audienceModelArn;
        this.outputConfig = builder.outputConfig;
        this.description = builder.description;
        this.status = builder.status;
        this.sharedAudienceMetrics = builder.sharedAudienceMetrics;
        this.minMatchingSeedSize = builder.minMatchingSeedSize;
        this.audienceSizeConfig = builder.audienceSizeConfig;
        this.tags = builder.tags;
        this.childResourceTagOnCreatePolicy = builder.childResourceTagOnCreatePolicy;
    }

    /**
     * <p>
     * The time at which the configured audience model was created.
     * </p>
     * 
     * @return The time at which the configured audience model was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the configured audience model was updated.
     * </p>
     * 
     * @return The most recent time at which the configured audience model was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The name of the configured audience model.
     * </p>
     * 
     * @return The name of the configured audience model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the audience model used for this configured audience model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the audience model used for this configured audience model.
     */
    public final String audienceModelArn() {
        return audienceModelArn;
    }

    /**
     * <p>
     * The output configuration of the configured audience model
     * </p>
     * 
     * @return The output configuration of the configured audience model
     */
    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The description of the configured audience model.
     * </p>
     * 
     * @return The description of the configured audience model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the configured audience model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfiguredAudienceModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the configured audience model.
     * @see ConfiguredAudienceModelStatus
     */
    public final ConfiguredAudienceModelStatus status() {
        return ConfiguredAudienceModelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the configured audience model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfiguredAudienceModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the configured audience model.
     * @see ConfiguredAudienceModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Whether audience metrics are shared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedAudienceMetrics} method.
     * </p>
     * 
     * @return Whether audience metrics are shared.
     */
    public final List<SharedAudienceMetrics> sharedAudienceMetrics() {
        return MetricsListCopier.copyStringToEnum(sharedAudienceMetrics);
    }

    /**
     * For responses, this returns true if the service returned a value for the SharedAudienceMetrics property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSharedAudienceMetrics() {
        return sharedAudienceMetrics != null && !(sharedAudienceMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Whether audience metrics are shared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedAudienceMetrics} method.
     * </p>
     * 
     * @return Whether audience metrics are shared.
     */
    public final List<String> sharedAudienceMetricsAsStrings() {
        return sharedAudienceMetrics;
    }

    /**
     * <p>
     * The minimum number of users from the seed audience that must match with users in the training data of the
     * audience model.
     * </p>
     * 
     * @return The minimum number of users from the seed audience that must match with users in the training data of the
     *         audience model.
     */
    public final Integer minMatchingSeedSize() {
        return minMatchingSeedSize;
    }

    /**
     * <p>
     * The list of output sizes of audiences that can be created using this configured audience model. A request to
     * <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an <code>audienceSize</code>
     * selected from this list. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience
     * sizes using the count of identifiers in the output. You can use the <code>Percentage</code> <a>AudienceSize</a>
     * to configure sizes in the range 1-100 percent.
     * </p>
     * 
     * @return The list of output sizes of audiences that can be created using this configured audience model. A request
     *         to <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an
     *         <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code>
     *         <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You can
     *         use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
     */
    public final AudienceSizeConfig audienceSizeConfig() {
        return audienceSizeConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that are associated to this configured audience model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that are associated to this configured audience model.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #childResourceTagOnCreatePolicy} will return {@link TagOnCreatePolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #childResourceTagOnCreatePolicyAsString}.
     * </p>
     * 
     * @return Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience
     *         model.
     * @see TagOnCreatePolicy
     */
    public final TagOnCreatePolicy childResourceTagOnCreatePolicy() {
        return TagOnCreatePolicy.fromValue(childResourceTagOnCreatePolicy);
    }

    /**
     * <p>
     * Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #childResourceTagOnCreatePolicy} will return {@link TagOnCreatePolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #childResourceTagOnCreatePolicyAsString}.
     * </p>
     * 
     * @return Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience
     *         model.
     * @see TagOnCreatePolicy
     */
    public final String childResourceTagOnCreatePolicyAsString() {
        return childResourceTagOnCreatePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedAudienceMetrics() ? sharedAudienceMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minMatchingSeedSize());
        hashCode = 31 * hashCode + Objects.hashCode(audienceSizeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(childResourceTagOnCreatePolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredAudienceModelResponse)) {
            return false;
        }
        GetConfiguredAudienceModelResponse other = (GetConfiguredAudienceModelResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(name(), other.name()) && Objects.equals(audienceModelArn(), other.audienceModelArn())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasSharedAudienceMetrics() == other.hasSharedAudienceMetrics()
                && Objects.equals(sharedAudienceMetricsAsStrings(), other.sharedAudienceMetricsAsStrings())
                && Objects.equals(minMatchingSeedSize(), other.minMatchingSeedSize())
                && Objects.equals(audienceSizeConfig(), other.audienceSizeConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(childResourceTagOnCreatePolicyAsString(), other.childResourceTagOnCreatePolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfiguredAudienceModelResponse").add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).add("ConfiguredAudienceModelArn", configuredAudienceModelArn())
                .add("Name", name()).add("AudienceModelArn", audienceModelArn()).add("OutputConfig", outputConfig())
                .add("Description", description()).add("Status", statusAsString())
                .add("SharedAudienceMetrics", hasSharedAudienceMetrics() ? sharedAudienceMetricsAsStrings() : null)
                .add("MinMatchingSeedSize", minMatchingSeedSize()).add("AudienceSizeConfig", audienceSizeConfig())
                .add("Tags", hasTags() ? tags() : null)
                .add("ChildResourceTagOnCreatePolicy", childResourceTagOnCreatePolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "audienceModelArn":
            return Optional.ofNullable(clazz.cast(audienceModelArn()));
        case "outputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "sharedAudienceMetrics":
            return Optional.ofNullable(clazz.cast(sharedAudienceMetricsAsStrings()));
        case "minMatchingSeedSize":
            return Optional.ofNullable(clazz.cast(minMatchingSeedSize()));
        case "audienceSizeConfig":
            return Optional.ofNullable(clazz.cast(audienceSizeConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "childResourceTagOnCreatePolicy":
            return Optional.ofNullable(clazz.cast(childResourceTagOnCreatePolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredAudienceModelResponse, T> g) {
        return obj -> g.apply((GetConfiguredAudienceModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfiguredAudienceModelResponse> {
        /**
         * <p>
         * The time at which the configured audience model was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the configured audience model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the configured audience model was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the configured audience model was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The name of the configured audience model.
         * </p>
         * 
         * @param name
         *        The name of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the audience model used for this configured audience model.
         * </p>
         * 
         * @param audienceModelArn
         *        The Amazon Resource Name (ARN) of the audience model used for this configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceModelArn(String audienceModelArn);

        /**
         * <p>
         * The output configuration of the configured audience model
         * </p>
         * 
         * @param outputConfig
         *        The output configuration of the configured audience model
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig);

        /**
         * <p>
         * The output configuration of the configured audience model
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredAudienceModelOutputConfig.Builder} avoiding the need to create one manually via
         * {@link ConfiguredAudienceModelOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredAudienceModelOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(ConfiguredAudienceModelOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link ConfiguredAudienceModelOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(ConfiguredAudienceModelOutputConfig)
         */
        default Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return outputConfig(ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The description of the configured audience model.
         * </p>
         * 
         * @param description
         *        The description of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the configured audience model.
         * </p>
         * 
         * @param status
         *        The status of the configured audience model.
         * @see ConfiguredAudienceModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredAudienceModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the configured audience model.
         * </p>
         * 
         * @param status
         *        The status of the configured audience model.
         * @see ConfiguredAudienceModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredAudienceModelStatus
         */
        Builder status(ConfiguredAudienceModelStatus status);

        /**
         * <p>
         * Whether audience metrics are shared.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        Whether audience metrics are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics);

        /**
         * <p>
         * Whether audience metrics are shared.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        Whether audience metrics are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetricsWithStrings(String... sharedAudienceMetrics);

        /**
         * <p>
         * Whether audience metrics are shared.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        Whether audience metrics are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics);

        /**
         * <p>
         * Whether audience metrics are shared.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        Whether audience metrics are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetrics(SharedAudienceMetrics... sharedAudienceMetrics);

        /**
         * <p>
         * The minimum number of users from the seed audience that must match with users in the training data of the
         * audience model.
         * </p>
         * 
         * @param minMatchingSeedSize
         *        The minimum number of users from the seed audience that must match with users in the training data of
         *        the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minMatchingSeedSize(Integer minMatchingSeedSize);

        /**
         * <p>
         * The list of output sizes of audiences that can be created using this configured audience model. A request to
         * <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an
         * <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a>
         * to configure out audience sizes using the count of identifiers in the output. You can use the
         * <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
         * </p>
         * 
         * @param audienceSizeConfig
         *        The list of output sizes of audiences that can be created using this configured audience model. A
         *        request to <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an
         *        <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code>
         *        <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You
         *        can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig);

        /**
         * <p>
         * The list of output sizes of audiences that can be created using this configured audience model. A request to
         * <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an
         * <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a>
         * to configure out audience sizes using the count of identifiers in the output. You can use the
         * <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudienceSizeConfig.Builder} avoiding the
         * need to create one manually via {@link AudienceSizeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceSizeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #audienceSizeConfig(AudienceSizeConfig)}.
         * 
         * @param audienceSizeConfig
         *        a consumer that will call methods on {@link AudienceSizeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceSizeConfig(AudienceSizeConfig)
         */
        default Builder audienceSizeConfig(Consumer<AudienceSizeConfig.Builder> audienceSizeConfig) {
            return audienceSizeConfig(AudienceSizeConfig.builder().applyMutation(audienceSizeConfig).build());
        }

        /**
         * <p>
         * The tags that are associated to this configured audience model.
         * </p>
         * 
         * @param tags
         *        The tags that are associated to this configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience model.
         * </p>
         * 
         * @param childResourceTagOnCreatePolicy
         *        Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience
         *        model.
         * @see TagOnCreatePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagOnCreatePolicy
         */
        Builder childResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy);

        /**
         * <p>
         * Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience model.
         * </p>
         * 
         * @param childResourceTagOnCreatePolicy
         *        Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience
         *        model.
         * @see TagOnCreatePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagOnCreatePolicy
         */
        Builder childResourceTagOnCreatePolicy(TagOnCreatePolicy childResourceTagOnCreatePolicy);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String configuredAudienceModelArn;

        private String name;

        private String audienceModelArn;

        private ConfiguredAudienceModelOutputConfig outputConfig;

        private String description;

        private String status;

        private List<String> sharedAudienceMetrics = DefaultSdkAutoConstructList.getInstance();

        private Integer minMatchingSeedSize;

        private AudienceSizeConfig audienceSizeConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String childResourceTagOnCreatePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredAudienceModelResponse model) {
            super(model);
            createTime(model.createTime);
            updateTime(model.updateTime);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            name(model.name);
            audienceModelArn(model.audienceModelArn);
            outputConfig(model.outputConfig);
            description(model.description);
            status(model.status);
            sharedAudienceMetricsWithStrings(model.sharedAudienceMetrics);
            minMatchingSeedSize(model.minMatchingSeedSize);
            audienceSizeConfig(model.audienceSizeConfig);
            tags(model.tags);
            childResourceTagOnCreatePolicy(model.childResourceTagOnCreatePolicy);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAudienceModelArn() {
            return audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfiguredAudienceModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSharedAudienceMetrics() {
            if (sharedAudienceMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedAudienceMetrics;
        }

        public final void setSharedAudienceMetrics(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
        }

        @Override
        public final Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetricsWithStrings(String... sharedAudienceMetrics) {
            sharedAudienceMetricsWithStrings(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        @Override
        public final Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copyEnumToString(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetrics(SharedAudienceMetrics... sharedAudienceMetrics) {
            sharedAudienceMetrics(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        public final Integer getMinMatchingSeedSize() {
            return minMatchingSeedSize;
        }

        public final void setMinMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
        }

        @Override
        public final Builder minMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
            return this;
        }

        public final AudienceSizeConfig.Builder getAudienceSizeConfig() {
            return audienceSizeConfig != null ? audienceSizeConfig.toBuilder() : null;
        }

        public final void setAudienceSizeConfig(AudienceSizeConfig.BuilderImpl audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig != null ? audienceSizeConfig.build() : null;
        }

        @Override
        public final Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getChildResourceTagOnCreatePolicy() {
            return childResourceTagOnCreatePolicy;
        }

        public final void setChildResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy;
        }

        @Override
        public final Builder childResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy;
            return this;
        }

        @Override
        public final Builder childResourceTagOnCreatePolicy(TagOnCreatePolicy childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy(childResourceTagOnCreatePolicy == null ? null : childResourceTagOnCreatePolicy
                    .toString());
            return this;
        }

        @Override
        public GetConfiguredAudienceModelResponse build() {
            return new GetConfiguredAudienceModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
