/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfiguredAudienceModelRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<UpdateConfiguredAudienceModelRequest.Builder, UpdateConfiguredAudienceModelRequest> {
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(UpdateConfiguredAudienceModelRequest::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<ConfiguredAudienceModelOutputConfig> builder(MarshallingType.SDK_POJO).memberName("outputConfig")
            .getter(getter(UpdateConfiguredAudienceModelRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(ConfiguredAudienceModelOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()).build();

    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceModelArn").getter(getter(UpdateConfiguredAudienceModelRequest::audienceModelArn))
            .setter(setter(Builder::audienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()).build();

    private static final SdkField<List<String>> SHARED_AUDIENCE_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sharedAudienceMetrics")
            .getter(getter(UpdateConfiguredAudienceModelRequest::sharedAudienceMetricsAsStrings))
            .setter(setter(Builder::sharedAudienceMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAudienceMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MIN_MATCHING_SEED_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minMatchingSeedSize").getter(getter(UpdateConfiguredAudienceModelRequest::minMatchingSeedSize))
            .setter(setter(Builder::minMatchingSeedSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minMatchingSeedSize").build())
            .build();

    private static final SdkField<AudienceSizeConfig> AUDIENCE_SIZE_CONFIG_FIELD = SdkField
            .<AudienceSizeConfig> builder(MarshallingType.SDK_POJO).memberName("audienceSizeConfig")
            .getter(getter(UpdateConfiguredAudienceModelRequest::audienceSizeConfig)).setter(setter(Builder::audienceSizeConfig))
            .constructor(AudienceSizeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeConfig").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateConfiguredAudienceModelRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, OUTPUT_CONFIG_FIELD, AUDIENCE_MODEL_ARN_FIELD, SHARED_AUDIENCE_METRICS_FIELD,
            MIN_MATCHING_SEED_SIZE_FIELD, AUDIENCE_SIZE_CONFIG_FIELD, DESCRIPTION_FIELD));

    private final String configuredAudienceModelArn;

    private final ConfiguredAudienceModelOutputConfig outputConfig;

    private final String audienceModelArn;

    private final List<String> sharedAudienceMetrics;

    private final Integer minMatchingSeedSize;

    private final AudienceSizeConfig audienceSizeConfig;

    private final String description;

    private UpdateConfiguredAudienceModelRequest(BuilderImpl builder) {
        super(builder);
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.outputConfig = builder.outputConfig;
        this.audienceModelArn = builder.audienceModelArn;
        this.sharedAudienceMetrics = builder.sharedAudienceMetrics;
        this.minMatchingSeedSize = builder.minMatchingSeedSize;
        this.audienceSizeConfig = builder.audienceSizeConfig;
        this.description = builder.description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model that you want to update.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The new output configuration.
     * </p>
     * 
     * @return The new output configuration.
     */
    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the new audience model that you want to use.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the new audience model that you want to use.
     */
    public final String audienceModelArn() {
        return audienceModelArn;
    }

    /**
     * <p>
     * The new value for whether to share audience metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedAudienceMetrics} method.
     * </p>
     * 
     * @return The new value for whether to share audience metrics.
     */
    public final List<SharedAudienceMetrics> sharedAudienceMetrics() {
        return MetricsListCopier.copyStringToEnum(sharedAudienceMetrics);
    }

    /**
     * For responses, this returns true if the service returned a value for the SharedAudienceMetrics property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSharedAudienceMetrics() {
        return sharedAudienceMetrics != null && !(sharedAudienceMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new value for whether to share audience metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedAudienceMetrics} method.
     * </p>
     * 
     * @return The new value for whether to share audience metrics.
     */
    public final List<String> sharedAudienceMetricsAsStrings() {
        return sharedAudienceMetrics;
    }

    /**
     * <p>
     * The minimum number of users from the seed audience that must match with users in the training data of the
     * audience model.
     * </p>
     * 
     * @return The minimum number of users from the seed audience that must match with users in the training data of the
     *         audience model.
     */
    public final Integer minMatchingSeedSize() {
        return minMatchingSeedSize;
    }

    /**
     * <p>
     * The new audience size configuration.
     * </p>
     * 
     * @return The new audience size configuration.
     */
    public final AudienceSizeConfig audienceSizeConfig() {
        return audienceSizeConfig;
    }

    /**
     * <p>
     * The new description of the configured audience model.
     * </p>
     * 
     * @return The new description of the configured audience model.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedAudienceMetrics() ? sharedAudienceMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minMatchingSeedSize());
        hashCode = 31 * hashCode + Objects.hashCode(audienceSizeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfiguredAudienceModelRequest)) {
            return false;
        }
        UpdateConfiguredAudienceModelRequest other = (UpdateConfiguredAudienceModelRequest) obj;
        return Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(audienceModelArn(), other.audienceModelArn())
                && hasSharedAudienceMetrics() == other.hasSharedAudienceMetrics()
                && Objects.equals(sharedAudienceMetricsAsStrings(), other.sharedAudienceMetricsAsStrings())
                && Objects.equals(minMatchingSeedSize(), other.minMatchingSeedSize())
                && Objects.equals(audienceSizeConfig(), other.audienceSizeConfig())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfiguredAudienceModelRequest")
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn()).add("OutputConfig", outputConfig())
                .add("AudienceModelArn", audienceModelArn())
                .add("SharedAudienceMetrics", hasSharedAudienceMetrics() ? sharedAudienceMetricsAsStrings() : null)
                .add("MinMatchingSeedSize", minMatchingSeedSize()).add("AudienceSizeConfig", audienceSizeConfig())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "outputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "audienceModelArn":
            return Optional.ofNullable(clazz.cast(audienceModelArn()));
        case "sharedAudienceMetrics":
            return Optional.ofNullable(clazz.cast(sharedAudienceMetricsAsStrings()));
        case "minMatchingSeedSize":
            return Optional.ofNullable(clazz.cast(minMatchingSeedSize()));
        case "audienceSizeConfig":
            return Optional.ofNullable(clazz.cast(audienceSizeConfig()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfiguredAudienceModelRequest, T> g) {
        return obj -> g.apply((UpdateConfiguredAudienceModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfiguredAudienceModelRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model that you want to update.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The new output configuration.
         * </p>
         * 
         * @param outputConfig
         *        The new output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig);

        /**
         * <p>
         * The new output configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredAudienceModelOutputConfig.Builder} avoiding the need to create one manually via
         * {@link ConfiguredAudienceModelOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredAudienceModelOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(ConfiguredAudienceModelOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link ConfiguredAudienceModelOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(ConfiguredAudienceModelOutputConfig)
         */
        default Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return outputConfig(ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the new audience model that you want to use.
         * </p>
         * 
         * @param audienceModelArn
         *        The Amazon Resource Name (ARN) of the new audience model that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceModelArn(String audienceModelArn);

        /**
         * <p>
         * The new value for whether to share audience metrics.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        The new value for whether to share audience metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics);

        /**
         * <p>
         * The new value for whether to share audience metrics.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        The new value for whether to share audience metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetricsWithStrings(String... sharedAudienceMetrics);

        /**
         * <p>
         * The new value for whether to share audience metrics.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        The new value for whether to share audience metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics);

        /**
         * <p>
         * The new value for whether to share audience metrics.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        The new value for whether to share audience metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetrics(SharedAudienceMetrics... sharedAudienceMetrics);

        /**
         * <p>
         * The minimum number of users from the seed audience that must match with users in the training data of the
         * audience model.
         * </p>
         * 
         * @param minMatchingSeedSize
         *        The minimum number of users from the seed audience that must match with users in the training data of
         *        the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minMatchingSeedSize(Integer minMatchingSeedSize);

        /**
         * <p>
         * The new audience size configuration.
         * </p>
         * 
         * @param audienceSizeConfig
         *        The new audience size configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig);

        /**
         * <p>
         * The new audience size configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudienceSizeConfig.Builder} avoiding the
         * need to create one manually via {@link AudienceSizeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceSizeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #audienceSizeConfig(AudienceSizeConfig)}.
         * 
         * @param audienceSizeConfig
         *        a consumer that will call methods on {@link AudienceSizeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceSizeConfig(AudienceSizeConfig)
         */
        default Builder audienceSizeConfig(Consumer<AudienceSizeConfig.Builder> audienceSizeConfig) {
            return audienceSizeConfig(AudienceSizeConfig.builder().applyMutation(audienceSizeConfig).build());
        }

        /**
         * <p>
         * The new description of the configured audience model.
         * </p>
         * 
         * @param description
         *        The new description of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String configuredAudienceModelArn;

        private ConfiguredAudienceModelOutputConfig outputConfig;

        private String audienceModelArn;

        private List<String> sharedAudienceMetrics = DefaultSdkAutoConstructList.getInstance();

        private Integer minMatchingSeedSize;

        private AudienceSizeConfig audienceSizeConfig;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfiguredAudienceModelRequest model) {
            super(model);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            outputConfig(model.outputConfig);
            audienceModelArn(model.audienceModelArn);
            sharedAudienceMetricsWithStrings(model.sharedAudienceMetrics);
            minMatchingSeedSize(model.minMatchingSeedSize);
            audienceSizeConfig(model.audienceSizeConfig);
            description(model.description);
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getAudienceModelArn() {
            return audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final Collection<String> getSharedAudienceMetrics() {
            if (sharedAudienceMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedAudienceMetrics;
        }

        public final void setSharedAudienceMetrics(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
        }

        @Override
        public final Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetricsWithStrings(String... sharedAudienceMetrics) {
            sharedAudienceMetricsWithStrings(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        @Override
        public final Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copyEnumToString(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetrics(SharedAudienceMetrics... sharedAudienceMetrics) {
            sharedAudienceMetrics(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        public final Integer getMinMatchingSeedSize() {
            return minMatchingSeedSize;
        }

        public final void setMinMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
        }

        @Override
        public final Builder minMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
            return this;
        }

        public final AudienceSizeConfig.Builder getAudienceSizeConfig() {
            return audienceSizeConfig != null ? audienceSizeConfig.toBuilder() : null;
        }

        public final void setAudienceSizeConfig(AudienceSizeConfig.BuilderImpl audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig != null ? audienceSizeConfig.build() : null;
        }

        @Override
        public final Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfiguredAudienceModelRequest build() {
            return new UpdateConfiguredAudienceModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
