/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAudienceModelsResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<ListAudienceModelsResponse.Builder, ListAudienceModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAudienceModelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AudienceModelSummary>> AUDIENCE_MODELS_FIELD = SdkField
            .<List<AudienceModelSummary>> builder(MarshallingType.LIST)
            .memberName("audienceModels")
            .getter(getter(ListAudienceModelsResponse::audienceModels))
            .setter(setter(Builder::audienceModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudienceModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudienceModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            AUDIENCE_MODELS_FIELD));

    private final String nextToken;

    private final List<AudienceModelSummary> audienceModels;

    private ListAudienceModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.audienceModels = builder.audienceModels;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudienceModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudienceModels() {
        return audienceModels != null && !(audienceModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The audience models that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudienceModels} method.
     * </p>
     * 
     * @return The audience models that match the request.
     */
    public final List<AudienceModelSummary> audienceModels() {
        return audienceModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAudienceModels() ? audienceModels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAudienceModelsResponse)) {
            return false;
        }
        ListAudienceModelsResponse other = (ListAudienceModelsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasAudienceModels() == other.hasAudienceModels()
                && Objects.equals(audienceModels(), other.audienceModels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAudienceModelsResponse").add("NextToken", nextToken())
                .add("AudienceModels", hasAudienceModels() ? audienceModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "audienceModels":
            return Optional.ofNullable(clazz.cast(audienceModels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAudienceModelsResponse, T> g) {
        return obj -> g.apply((ListAudienceModelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAudienceModelsResponse> {
        /**
         * <p>
         * The token value retrieved from a previous call to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value retrieved from a previous call to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The audience models that match the request.
         * </p>
         * 
         * @param audienceModels
         *        The audience models that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceModels(Collection<AudienceModelSummary> audienceModels);

        /**
         * <p>
         * The audience models that match the request.
         * </p>
         * 
         * @param audienceModels
         *        The audience models that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceModels(AudienceModelSummary... audienceModels);

        /**
         * <p>
         * The audience models that match the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.AudienceModelSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.AudienceModelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.AudienceModelSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #audienceModels(List<AudienceModelSummary>)}.
         * 
         * @param audienceModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.AudienceModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceModels(java.util.Collection<AudienceModelSummary>)
         */
        Builder audienceModels(Consumer<AudienceModelSummary.Builder>... audienceModels);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AudienceModelSummary> audienceModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAudienceModelsResponse model) {
            super(model);
            nextToken(model.nextToken);
            audienceModels(model.audienceModels);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AudienceModelSummary.Builder> getAudienceModels() {
            List<AudienceModelSummary.Builder> result = AudienceModelListCopier.copyToBuilder(this.audienceModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceModels(Collection<AudienceModelSummary.BuilderImpl> audienceModels) {
            this.audienceModels = AudienceModelListCopier.copyFromBuilder(audienceModels);
        }

        @Override
        public final Builder audienceModels(Collection<AudienceModelSummary> audienceModels) {
            this.audienceModels = AudienceModelListCopier.copy(audienceModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceModels(AudienceModelSummary... audienceModels) {
            audienceModels(Arrays.asList(audienceModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceModels(Consumer<AudienceModelSummary.Builder>... audienceModels) {
            audienceModels(Stream.of(audienceModels).map(c -> AudienceModelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAudienceModelsResponse build() {
            return new ListAudienceModelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
