/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAudienceExportJobRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<StartAudienceExportJobRequest.Builder, StartAudienceExportJobRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartAudienceExportJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> AUDIENCE_GENERATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceGenerationJobArn").getter(getter(StartAudienceExportJobRequest::audienceGenerationJobArn))
            .setter(setter(Builder::audienceGenerationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobArn").build())
            .build();

    private static final SdkField<AudienceSize> AUDIENCE_SIZE_FIELD = SdkField.<AudienceSize> builder(MarshallingType.SDK_POJO)
            .memberName("audienceSize").getter(getter(StartAudienceExportJobRequest::audienceSize))
            .setter(setter(Builder::audienceSize)).constructor(AudienceSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSize").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StartAudienceExportJobRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            AUDIENCE_GENERATION_JOB_ARN_FIELD, AUDIENCE_SIZE_FIELD, DESCRIPTION_FIELD));

    private final String name;

    private final String audienceGenerationJobArn;

    private final AudienceSize audienceSize;

    private final String description;

    private StartAudienceExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.audienceGenerationJobArn = builder.audienceGenerationJobArn;
        this.audienceSize = builder.audienceSize;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the audience export job.
     * </p>
     * 
     * @return The name of the audience export job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the audience generation job that you want to export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the audience generation job that you want to export.
     */
    public final String audienceGenerationJobArn() {
        return audienceGenerationJobArn;
    }

    /**
     * Returns the value of the AudienceSize property for this object.
     * 
     * @return The value of the AudienceSize property for this object.
     */
    public final AudienceSize audienceSize() {
        return audienceSize;
    }

    /**
     * <p>
     * The description of the audience export job.
     * </p>
     * 
     * @return The description of the audience export job.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(audienceGenerationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(audienceSize());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAudienceExportJobRequest)) {
            return false;
        }
        StartAudienceExportJobRequest other = (StartAudienceExportJobRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(audienceGenerationJobArn(), other.audienceGenerationJobArn())
                && Objects.equals(audienceSize(), other.audienceSize()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAudienceExportJobRequest").add("Name", name())
                .add("AudienceGenerationJobArn", audienceGenerationJobArn()).add("AudienceSize", audienceSize())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "audienceGenerationJobArn":
            return Optional.ofNullable(clazz.cast(audienceGenerationJobArn()));
        case "audienceSize":
            return Optional.ofNullable(clazz.cast(audienceSize()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAudienceExportJobRequest, T> g) {
        return obj -> g.apply((StartAudienceExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAudienceExportJobRequest> {
        /**
         * <p>
         * The name of the audience export job.
         * </p>
         * 
         * @param name
         *        The name of the audience export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the audience generation job that you want to export.
         * </p>
         * 
         * @param audienceGenerationJobArn
         *        The Amazon Resource Name (ARN) of the audience generation job that you want to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceGenerationJobArn(String audienceGenerationJobArn);

        /**
         * Sets the value of the AudienceSize property for this object.
         *
         * @param audienceSize
         *        The new value for the AudienceSize property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceSize(AudienceSize audienceSize);

        /**
         * Sets the value of the AudienceSize property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AudienceSize.Builder} avoiding the need
         * to create one manually via {@link AudienceSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceSize.Builder#build()} is called immediately and its
         * result is passed to {@link #audienceSize(AudienceSize)}.
         * 
         * @param audienceSize
         *        a consumer that will call methods on {@link AudienceSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceSize(AudienceSize)
         */
        default Builder audienceSize(Consumer<AudienceSize.Builder> audienceSize) {
            return audienceSize(AudienceSize.builder().applyMutation(audienceSize).build());
        }

        /**
         * <p>
         * The description of the audience export job.
         * </p>
         * 
         * @param description
         *        The description of the audience export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String name;

        private String audienceGenerationJobArn;

        private AudienceSize audienceSize;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAudienceExportJobRequest model) {
            super(model);
            name(model.name);
            audienceGenerationJobArn(model.audienceGenerationJobArn);
            audienceSize(model.audienceSize);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAudienceGenerationJobArn() {
            return audienceGenerationJobArn;
        }

        public final void setAudienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
        }

        @Override
        public final Builder audienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
            return this;
        }

        public final AudienceSize.Builder getAudienceSize() {
            return audienceSize != null ? audienceSize.toBuilder() : null;
        }

        public final void setAudienceSize(AudienceSize.BuilderImpl audienceSize) {
            this.audienceSize = audienceSize != null ? audienceSize.build() : null;
        }

        @Override
        public final Builder audienceSize(AudienceSize audienceSize) {
            this.audienceSize = audienceSize;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAudienceExportJobRequest build() {
            return new StartAudienceExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
