/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the training dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingDatasetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingDatasetSummary.Builder, TrainingDatasetSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(TrainingDatasetSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(TrainingDatasetSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDatasetArn").getter(getter(TrainingDatasetSummary::trainingDatasetArn))
            .setter(setter(Builder::trainingDatasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasetArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TrainingDatasetSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TrainingDatasetSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TrainingDatasetSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, TRAINING_DATASET_ARN_FIELD, NAME_FIELD, STATUS_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createTime;

    private final Instant updateTime;

    private final String trainingDatasetArn;

    private final String name;

    private final String status;

    private final String description;

    private TrainingDatasetSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.trainingDatasetArn = builder.trainingDatasetArn;
        this.name = builder.name;
        this.status = builder.status;
        this.description = builder.description;
    }

    /**
     * <p>
     * The time at which the training dataset was created.
     * </p>
     * 
     * @return The time at which the training dataset was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the training dataset was updated.
     * </p>
     * 
     * @return The most recent time at which the training dataset was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training dataset.
     */
    public final String trainingDatasetArn() {
        return trainingDatasetArn;
    }

    /**
     * <p>
     * The name of the training dataset.
     * </p>
     * 
     * @return The name of the training dataset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the training dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainingDatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the training dataset.
     * @see TrainingDatasetStatus
     */
    public final TrainingDatasetStatus status() {
        return TrainingDatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the training dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainingDatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the training dataset.
     * @see TrainingDatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the training dataset.
     * </p>
     * 
     * @return The description of the training dataset.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDatasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDatasetSummary)) {
            return false;
        }
        TrainingDatasetSummary other = (TrainingDatasetSummary) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(trainingDatasetArn(), other.trainingDatasetArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingDatasetSummary").add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("TrainingDatasetArn", trainingDatasetArn()).add("Name", name()).add("Status", statusAsString())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "trainingDatasetArn":
            return Optional.ofNullable(clazz.cast(trainingDatasetArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingDatasetSummary, T> g) {
        return obj -> g.apply((TrainingDatasetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingDatasetSummary> {
        /**
         * <p>
         * The time at which the training dataset was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the training dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the training dataset was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the training dataset was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training dataset.
         * </p>
         * 
         * @param trainingDatasetArn
         *        The Amazon Resource Name (ARN) of the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDatasetArn(String trainingDatasetArn);

        /**
         * <p>
         * The name of the training dataset.
         * </p>
         * 
         * @param name
         *        The name of the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the training dataset.
         * </p>
         * 
         * @param status
         *        The status of the training dataset.
         * @see TrainingDatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the training dataset.
         * </p>
         * 
         * @param status
         *        The status of the training dataset.
         * @see TrainingDatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDatasetStatus
         */
        Builder status(TrainingDatasetStatus status);

        /**
         * <p>
         * The description of the training dataset.
         * </p>
         * 
         * @param description
         *        The description of the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String trainingDatasetArn;

        private String name;

        private String status;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDatasetSummary model) {
            createTime(model.createTime);
            updateTime(model.updateTime);
            trainingDatasetArn(model.trainingDatasetArn);
            name(model.name);
            status(model.status);
            description(model.description);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getTrainingDatasetArn() {
            return trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainingDatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public TrainingDatasetSummary build() {
            return new TrainingDatasetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
