/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceModelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;

public class ListAudienceModelsPublisher
implements SdkPublisher<ListAudienceModelsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListAudienceModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAudienceModelsPublisher(CleanRoomsMlAsyncClient client, ListAudienceModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAudienceModelsPublisher(CleanRoomsMlAsyncClient client, ListAudienceModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAudienceModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAudienceModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AudienceModelSummary> audienceModels() {
        Function<ListAudienceModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.audienceModels() != null) {
                return response.audienceModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAudienceModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAudienceModelsResponseFetcher
    implements AsyncPageFetcher<ListAudienceModelsResponse> {
        private ListAudienceModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListAudienceModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAudienceModelsResponse> nextPage(ListAudienceModelsResponse previousPage) {
            if (previousPage == null) {
                return ListAudienceModelsPublisher.this.client.listAudienceModels(ListAudienceModelsPublisher.this.firstRequest);
            }
            return ListAudienceModelsPublisher.this.client.listAudienceModels((ListAudienceModelsRequest)((Object)ListAudienceModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

