/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAudienceModelRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<CreateAudienceModelRequest.Builder, CreateAudienceModelRequest> {
    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("trainingDataStartTime")
            .getter(getter(CreateAudienceModelRequest::trainingDataStartTime))
            .setter(setter(Builder::trainingDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("trainingDataEndTime")
            .getter(getter(CreateAudienceModelRequest::trainingDataEndTime))
            .setter(setter(Builder::trainingDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataEndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAudienceModelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDatasetArn").getter(getter(CreateAudienceModelRequest::trainingDatasetArn))
            .setter(setter(Builder::trainingDatasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasetArn").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(CreateAudienceModelRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAudienceModelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAudienceModelRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAINING_DATA_START_TIME_FIELD, TRAINING_DATA_END_TIME_FIELD, NAME_FIELD, TRAINING_DATASET_ARN_FIELD,
            KMS_KEY_ARN_FIELD, TAGS_FIELD, DESCRIPTION_FIELD));

    private final Instant trainingDataStartTime;

    private final Instant trainingDataEndTime;

    private final String name;

    private final String trainingDatasetArn;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private final String description;

    private CreateAudienceModelRequest(BuilderImpl builder) {
        super(builder);
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.name = builder.name;
        this.trainingDatasetArn = builder.trainingDatasetArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
        this.description = builder.description;
    }

    /**
     * <p>
     * The start date and time of the training window.
     * </p>
     * 
     * @return The start date and time of the training window.
     */
    public final Instant trainingDataStartTime() {
        return trainingDataStartTime;
    }

    /**
     * <p>
     * The end date and time of the training window.
     * </p>
     * 
     * @return The end date and time of the training window.
     */
    public final Instant trainingDataEndTime() {
        return trainingDataEndTime;
    }

    /**
     * <p>
     * The name of the audience model resource.
     * </p>
     * 
     * @return The name of the audience model resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training dataset for this audience model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training dataset for this audience model.
     */
    public final String trainingDatasetArn() {
        return trainingDatasetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the
     * trained ML model and the associated data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
     *         data in the trained ML model and the associated data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the
     * limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user
     *         tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The description of the audience model.
     * </p>
     * 
     * @return The description of the audience model.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDatasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAudienceModelRequest)) {
            return false;
        }
        CreateAudienceModelRequest other = (CreateAudienceModelRequest) obj;
        return Objects.equals(trainingDataStartTime(), other.trainingDataStartTime())
                && Objects.equals(trainingDataEndTime(), other.trainingDataEndTime()) && Objects.equals(name(), other.name())
                && Objects.equals(trainingDatasetArn(), other.trainingDatasetArn())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAudienceModelRequest").add("TrainingDataStartTime", trainingDataStartTime())
                .add("TrainingDataEndTime", trainingDataEndTime()).add("Name", name())
                .add("TrainingDatasetArn", trainingDatasetArn()).add("KmsKeyArn", kmsKeyArn())
                .add("Tags", hasTags() ? tags() : null).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trainingDataStartTime":
            return Optional.ofNullable(clazz.cast(trainingDataStartTime()));
        case "trainingDataEndTime":
            return Optional.ofNullable(clazz.cast(trainingDataEndTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "trainingDatasetArn":
            return Optional.ofNullable(clazz.cast(trainingDatasetArn()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAudienceModelRequest, T> g) {
        return obj -> g.apply((CreateAudienceModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAudienceModelRequest> {
        /**
         * <p>
         * The start date and time of the training window.
         * </p>
         * 
         * @param trainingDataStartTime
         *        The start date and time of the training window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataStartTime(Instant trainingDataStartTime);

        /**
         * <p>
         * The end date and time of the training window.
         * </p>
         * 
         * @param trainingDataEndTime
         *        The end date and time of the training window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataEndTime(Instant trainingDataEndTime);

        /**
         * <p>
         * The name of the audience model resource.
         * </p>
         * 
         * @param name
         *        The name of the audience model resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training dataset for this audience model.
         * </p>
         * 
         * @param trainingDatasetArn
         *        The Amazon Resource Name (ARN) of the training dataset for this audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDatasetArn(String trainingDatasetArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in
         * the trained ML model and the associated data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
         *        data in the trained ML model and the associated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to
         *        be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The description of the audience model.
         * </p>
         * 
         * @param description
         *        The description of the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private Instant trainingDataStartTime;

        private Instant trainingDataEndTime;

        private String name;

        private String trainingDatasetArn;

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAudienceModelRequest model) {
            super(model);
            trainingDataStartTime(model.trainingDataStartTime);
            trainingDataEndTime(model.trainingDataEndTime);
            name(model.name);
            trainingDatasetArn(model.trainingDatasetArn);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
            description(model.description);
        }

        public final Instant getTrainingDataStartTime() {
            return trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrainingDatasetArn() {
            return trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAudienceModelRequest build() {
            return new CreateAudienceModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
