/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredAudienceModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredAudienceModelSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::createTime)).setter(ConfiguredAudienceModelSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::updateTime)).setter(ConfiguredAudienceModelSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::name)).setter(ConfiguredAudienceModelSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceModelArn").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::audienceModelArn)).setter(ConfiguredAudienceModelSummary.setter(Builder::audienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()}).build();
    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfig").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::outputConfig)).setter(ConfiguredAudienceModelSummary.setter(Builder::outputConfig)).constructor(ConfiguredAudienceModelOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::description)).setter(ConfiguredAudienceModelSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::configuredAudienceModelArn)).setter(ConfiguredAudienceModelSummary.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::statusAsString)).setter(ConfiguredAudienceModelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, NAME_FIELD, AUDIENCE_MODEL_ARN_FIELD, OUTPUT_CONFIG_FIELD, DESCRIPTION_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createTime", CREATE_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
            this.put("name", NAME_FIELD);
            this.put("audienceModelArn", AUDIENCE_MODEL_ARN_FIELD);
            this.put("outputConfig", OUTPUT_CONFIG_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("configuredAudienceModelArn", CONFIGURED_AUDIENCE_MODEL_ARN_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final Instant updateTime;
    private final String name;
    private final String audienceModelArn;
    private final ConfiguredAudienceModelOutputConfig outputConfig;
    private final String description;
    private final String configuredAudienceModelArn;
    private final String status;

    private ConfiguredAudienceModelSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.name = builder.name;
        this.audienceModelArn = builder.audienceModelArn;
        this.outputConfig = builder.outputConfig;
        this.description = builder.description;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.status = builder.status;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String name() {
        return this.name;
    }

    public final String audienceModelArn() {
        return this.audienceModelArn;
    }

    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String description() {
        return this.description;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final ConfiguredAudienceModelStatus status() {
        return ConfiguredAudienceModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredAudienceModelSummary)) {
            return false;
        }
        ConfiguredAudienceModelSummary other = (ConfiguredAudienceModelSummary)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.audienceModelArn(), other.audienceModelArn()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredAudienceModelSummary").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Name", (Object)this.name()).add("AudienceModelArn", (Object)this.audienceModelArn()).add("OutputConfig", (Object)this.outputConfig()).add("Description", (Object)this.description()).add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "audienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.audienceModelArn()));
            }
            case "outputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredAudienceModelSummary, T> g) {
        return obj -> g.apply((ConfiguredAudienceModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String name;
        private String audienceModelArn;
        private ConfiguredAudienceModelOutputConfig outputConfig;
        private String description;
        private String configuredAudienceModelArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredAudienceModelSummary model) {
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.name(model.name);
            this.audienceModelArn(model.audienceModelArn);
            this.outputConfig(model.outputConfig);
            this.description(model.description);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.status(model.status);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAudienceModelArn() {
            return this.audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfiguredAudienceModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ConfiguredAudienceModelSummary build() {
            return new ConfiguredAudienceModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredAudienceModelSummary> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder name(String var1);

        public Builder audienceModelArn(String var1);

        public Builder outputConfig(ConfiguredAudienceModelOutputConfig var1);

        default public Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return this.outputConfig((ConfiguredAudienceModelOutputConfig)((ConfiguredAudienceModelOutputConfig.Builder)ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder description(String var1);

        public Builder configuredAudienceModelArn(String var1);

        public Builder status(String var1);

        public Builder status(ConfiguredAudienceModelStatus var1);
    }
}

