/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceSizeConfig;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig;
import software.amazon.awssdk.services.cleanroomsml.model.MetricsListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.SharedAudienceMetrics;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TagOnCreatePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfiguredAudienceModelRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, CreateConfiguredAudienceModelRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::name)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceModelArn").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::audienceModelArn)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::audienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()}).build();
    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfig").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::outputConfig)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::outputConfig)).constructor(ConfiguredAudienceModelOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::description)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> SHARED_AUDIENCE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sharedAudienceMetrics").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::sharedAudienceMetricsAsStrings)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::sharedAudienceMetricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAudienceMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_MATCHING_SEED_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minMatchingSeedSize").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::minMatchingSeedSize)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::minMatchingSeedSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minMatchingSeedSize").build()}).build();
    private static final SdkField<AudienceSizeConfig> AUDIENCE_SIZE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audienceSizeConfig").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::audienceSizeConfig)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::audienceSizeConfig)).constructor(AudienceSizeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::tags)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("childResourceTagOnCreatePolicy").getter(CreateConfiguredAudienceModelRequest.getter(CreateConfiguredAudienceModelRequest::childResourceTagOnCreatePolicyAsString)).setter(CreateConfiguredAudienceModelRequest.setter(Builder::childResourceTagOnCreatePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childResourceTagOnCreatePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, AUDIENCE_MODEL_ARN_FIELD, OUTPUT_CONFIG_FIELD, DESCRIPTION_FIELD, SHARED_AUDIENCE_METRICS_FIELD, MIN_MATCHING_SEED_SIZE_FIELD, AUDIENCE_SIZE_CONFIG_FIELD, TAGS_FIELD, CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("audienceModelArn", AUDIENCE_MODEL_ARN_FIELD);
            this.put("outputConfig", OUTPUT_CONFIG_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("sharedAudienceMetrics", SHARED_AUDIENCE_METRICS_FIELD);
            this.put("minMatchingSeedSize", MIN_MATCHING_SEED_SIZE_FIELD);
            this.put("audienceSizeConfig", AUDIENCE_SIZE_CONFIG_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("childResourceTagOnCreatePolicy", CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD);
        }
    });
    private final String name;
    private final String audienceModelArn;
    private final ConfiguredAudienceModelOutputConfig outputConfig;
    private final String description;
    private final List<String> sharedAudienceMetrics;
    private final Integer minMatchingSeedSize;
    private final AudienceSizeConfig audienceSizeConfig;
    private final Map<String, String> tags;
    private final String childResourceTagOnCreatePolicy;

    private CreateConfiguredAudienceModelRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.audienceModelArn = builder.audienceModelArn;
        this.outputConfig = builder.outputConfig;
        this.description = builder.description;
        this.sharedAudienceMetrics = builder.sharedAudienceMetrics;
        this.minMatchingSeedSize = builder.minMatchingSeedSize;
        this.audienceSizeConfig = builder.audienceSizeConfig;
        this.tags = builder.tags;
        this.childResourceTagOnCreatePolicy = builder.childResourceTagOnCreatePolicy;
    }

    public final String name() {
        return this.name;
    }

    public final String audienceModelArn() {
        return this.audienceModelArn;
    }

    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String description() {
        return this.description;
    }

    public final List<SharedAudienceMetrics> sharedAudienceMetrics() {
        return MetricsListCopier.copyStringToEnum(this.sharedAudienceMetrics);
    }

    public final boolean hasSharedAudienceMetrics() {
        return this.sharedAudienceMetrics != null && !(this.sharedAudienceMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> sharedAudienceMetricsAsStrings() {
        return this.sharedAudienceMetrics;
    }

    public final Integer minMatchingSeedSize() {
        return this.minMatchingSeedSize;
    }

    public final AudienceSizeConfig audienceSizeConfig() {
        return this.audienceSizeConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TagOnCreatePolicy childResourceTagOnCreatePolicy() {
        return TagOnCreatePolicy.fromValue(this.childResourceTagOnCreatePolicy);
    }

    public final String childResourceTagOnCreatePolicyAsString() {
        return this.childResourceTagOnCreatePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedAudienceMetrics() ? this.sharedAudienceMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minMatchingSeedSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceSizeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.childResourceTagOnCreatePolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredAudienceModelRequest)) {
            return false;
        }
        CreateConfiguredAudienceModelRequest other = (CreateConfiguredAudienceModelRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.audienceModelArn(), other.audienceModelArn()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.description(), other.description()) && this.hasSharedAudienceMetrics() == other.hasSharedAudienceMetrics() && Objects.equals(this.sharedAudienceMetricsAsStrings(), other.sharedAudienceMetricsAsStrings()) && Objects.equals(this.minMatchingSeedSize(), other.minMatchingSeedSize()) && Objects.equals(this.audienceSizeConfig(), other.audienceSizeConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.childResourceTagOnCreatePolicyAsString(), other.childResourceTagOnCreatePolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfiguredAudienceModelRequest").add("Name", (Object)this.name()).add("AudienceModelArn", (Object)this.audienceModelArn()).add("OutputConfig", (Object)this.outputConfig()).add("Description", (Object)this.description()).add("SharedAudienceMetrics", this.hasSharedAudienceMetrics() ? this.sharedAudienceMetricsAsStrings() : null).add("MinMatchingSeedSize", (Object)this.minMatchingSeedSize()).add("AudienceSizeConfig", (Object)this.audienceSizeConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("ChildResourceTagOnCreatePolicy", (Object)this.childResourceTagOnCreatePolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "audienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.audienceModelArn()));
            }
            case "outputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sharedAudienceMetrics": {
                return Optional.ofNullable(clazz.cast(this.sharedAudienceMetricsAsStrings()));
            }
            case "minMatchingSeedSize": {
                return Optional.ofNullable(clazz.cast(this.minMatchingSeedSize()));
            }
            case "audienceSizeConfig": {
                return Optional.ofNullable(clazz.cast(this.audienceSizeConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "childResourceTagOnCreatePolicy": {
                return Optional.ofNullable(clazz.cast(this.childResourceTagOnCreatePolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredAudienceModelRequest, T> g) {
        return obj -> g.apply((CreateConfiguredAudienceModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String name;
        private String audienceModelArn;
        private ConfiguredAudienceModelOutputConfig outputConfig;
        private String description;
        private List<String> sharedAudienceMetrics = DefaultSdkAutoConstructList.getInstance();
        private Integer minMatchingSeedSize;
        private AudienceSizeConfig audienceSizeConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String childResourceTagOnCreatePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredAudienceModelRequest model) {
            super(model);
            this.name(model.name);
            this.audienceModelArn(model.audienceModelArn);
            this.outputConfig(model.outputConfig);
            this.description(model.description);
            this.sharedAudienceMetricsWithStrings(model.sharedAudienceMetrics);
            this.minMatchingSeedSize(model.minMatchingSeedSize);
            this.audienceSizeConfig(model.audienceSizeConfig);
            this.tags(model.tags);
            this.childResourceTagOnCreatePolicy(model.childResourceTagOnCreatePolicy);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAudienceModelArn() {
            return this.audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getSharedAudienceMetrics() {
            if (this.sharedAudienceMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedAudienceMetrics;
        }

        public final void setSharedAudienceMetrics(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
        }

        @Override
        public final Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetricsWithStrings(String ... sharedAudienceMetrics) {
            this.sharedAudienceMetricsWithStrings(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        @Override
        public final Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copyEnumToString(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetrics(SharedAudienceMetrics ... sharedAudienceMetrics) {
            this.sharedAudienceMetrics(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        public final Integer getMinMatchingSeedSize() {
            return this.minMatchingSeedSize;
        }

        public final void setMinMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
        }

        @Override
        public final Builder minMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
            return this;
        }

        public final AudienceSizeConfig.Builder getAudienceSizeConfig() {
            return this.audienceSizeConfig != null ? this.audienceSizeConfig.toBuilder() : null;
        }

        public final void setAudienceSizeConfig(AudienceSizeConfig.BuilderImpl audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig != null ? audienceSizeConfig.build() : null;
        }

        @Override
        public final Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getChildResourceTagOnCreatePolicy() {
            return this.childResourceTagOnCreatePolicy;
        }

        public final void setChildResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy;
        }

        @Override
        public final Builder childResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy;
            return this;
        }

        @Override
        public final Builder childResourceTagOnCreatePolicy(TagOnCreatePolicy childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy(childResourceTagOnCreatePolicy == null ? null : childResourceTagOnCreatePolicy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredAudienceModelRequest build() {
            return new CreateConfiguredAudienceModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfiguredAudienceModelRequest> {
        public Builder name(String var1);

        public Builder audienceModelArn(String var1);

        public Builder outputConfig(ConfiguredAudienceModelOutputConfig var1);

        default public Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return this.outputConfig((ConfiguredAudienceModelOutputConfig)((ConfiguredAudienceModelOutputConfig.Builder)ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder description(String var1);

        public Builder sharedAudienceMetricsWithStrings(Collection<String> var1);

        public Builder sharedAudienceMetricsWithStrings(String ... var1);

        public Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> var1);

        public Builder sharedAudienceMetrics(SharedAudienceMetrics ... var1);

        public Builder minMatchingSeedSize(Integer var1);

        public Builder audienceSizeConfig(AudienceSizeConfig var1);

        default public Builder audienceSizeConfig(Consumer<AudienceSizeConfig.Builder> audienceSizeConfig) {
            return this.audienceSizeConfig((AudienceSizeConfig)((AudienceSizeConfig.Builder)AudienceSizeConfig.builder().applyMutation(audienceSizeConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder childResourceTagOnCreatePolicy(String var1);

        public Builder childResourceTagOnCreatePolicy(TagOnCreatePolicy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

