/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.AccountIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogsConfigurationPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogsConfigurationPolicy> {
    private static final SdkField<List<String>> ALLOWED_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedAccountIds").getter(LogsConfigurationPolicy.getter(LogsConfigurationPolicy::allowedAccountIds)).setter(LogsConfigurationPolicy.setter(Builder::allowedAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(LogsConfigurationPolicy.getter(LogsConfigurationPolicy::filterPattern)).setter(LogsConfigurationPolicy.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ACCOUNT_IDS_FIELD, FILTER_PATTERN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("allowedAccountIds", ALLOWED_ACCOUNT_IDS_FIELD);
            this.put("filterPattern", FILTER_PATTERN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> allowedAccountIds;
    private final String filterPattern;

    private LogsConfigurationPolicy(BuilderImpl builder) {
        this.allowedAccountIds = builder.allowedAccountIds;
        this.filterPattern = builder.filterPattern;
    }

    public final boolean hasAllowedAccountIds() {
        return this.allowedAccountIds != null && !(this.allowedAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAccountIds() {
        return this.allowedAccountIds;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAccountIds() ? this.allowedAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsConfigurationPolicy)) {
            return false;
        }
        LogsConfigurationPolicy other = (LogsConfigurationPolicy)obj;
        return this.hasAllowedAccountIds() == other.hasAllowedAccountIds() && Objects.equals(this.allowedAccountIds(), other.allowedAccountIds()) && Objects.equals(this.filterPattern(), other.filterPattern());
    }

    public final String toString() {
        return ToString.builder((String)"LogsConfigurationPolicy").add("AllowedAccountIds", this.hasAllowedAccountIds() ? this.allowedAccountIds() : null).add("FilterPattern", (Object)this.filterPattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedAccountIds": {
                return Optional.ofNullable(clazz.cast(this.allowedAccountIds()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LogsConfigurationPolicy, T> g) {
        return obj -> g.apply((LogsConfigurationPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedAccountIds = DefaultSdkAutoConstructList.getInstance();
        private String filterPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsConfigurationPolicy model) {
            this.allowedAccountIds(model.allowedAccountIds);
            this.filterPattern(model.filterPattern);
        }

        public final Collection<String> getAllowedAccountIds() {
            if (this.allowedAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAccountIds;
        }

        public final void setAllowedAccountIds(Collection<String> allowedAccountIds) {
            this.allowedAccountIds = AccountIdListCopier.copy(allowedAccountIds);
        }

        @Override
        public final Builder allowedAccountIds(Collection<String> allowedAccountIds) {
            this.allowedAccountIds = AccountIdListCopier.copy(allowedAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAccountIds(String ... allowedAccountIds) {
            this.allowedAccountIds(Arrays.asList(allowedAccountIds));
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public LogsConfigurationPolicy build() {
            return new LogsConfigurationPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogsConfigurationPolicy> {
        public Builder allowedAccountIds(Collection<String> var1);

        public Builder allowedAccountIds(String ... var1);

        public Builder filterPattern(String var1);
    }
}

