/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAudienceGenerationJobsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListAudienceGenerationJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAudienceGenerationJobsResponse.getter(ListAudienceGenerationJobsResponse::nextToken)).setter(ListAudienceGenerationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AudienceGenerationJobSummary>> AUDIENCE_GENERATION_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("audienceGenerationJobs").getter(ListAudienceGenerationJobsResponse.getter(ListAudienceGenerationJobsResponse::audienceGenerationJobs)).setter(ListAudienceGenerationJobsResponse.setter(Builder::audienceGenerationJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudienceGenerationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, AUDIENCE_GENERATION_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("audienceGenerationJobs", AUDIENCE_GENERATION_JOBS_FIELD);
        }
    });
    private final String nextToken;
    private final List<AudienceGenerationJobSummary> audienceGenerationJobs;

    private ListAudienceGenerationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.audienceGenerationJobs = builder.audienceGenerationJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAudienceGenerationJobs() {
        return this.audienceGenerationJobs != null && !(this.audienceGenerationJobs instanceof SdkAutoConstructList);
    }

    public final List<AudienceGenerationJobSummary> audienceGenerationJobs() {
        return this.audienceGenerationJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudienceGenerationJobs() ? this.audienceGenerationJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAudienceGenerationJobsResponse)) {
            return false;
        }
        ListAudienceGenerationJobsResponse other = (ListAudienceGenerationJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAudienceGenerationJobs() == other.hasAudienceGenerationJobs() && Objects.equals(this.audienceGenerationJobs(), other.audienceGenerationJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListAudienceGenerationJobsResponse").add("NextToken", (Object)this.nextToken()).add("AudienceGenerationJobs", this.hasAudienceGenerationJobs() ? this.audienceGenerationJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "audienceGenerationJobs": {
                return Optional.ofNullable(clazz.cast(this.audienceGenerationJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAudienceGenerationJobsResponse, T> g) {
        return obj -> g.apply((ListAudienceGenerationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AudienceGenerationJobSummary> audienceGenerationJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAudienceGenerationJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.audienceGenerationJobs(model.audienceGenerationJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AudienceGenerationJobSummary.Builder> getAudienceGenerationJobs() {
            List<AudienceGenerationJobSummary.Builder> result = AudienceGenerationJobListCopier.copyToBuilder(this.audienceGenerationJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceGenerationJobs(Collection<AudienceGenerationJobSummary.BuilderImpl> audienceGenerationJobs) {
            this.audienceGenerationJobs = AudienceGenerationJobListCopier.copyFromBuilder(audienceGenerationJobs);
        }

        @Override
        public final Builder audienceGenerationJobs(Collection<AudienceGenerationJobSummary> audienceGenerationJobs) {
            this.audienceGenerationJobs = AudienceGenerationJobListCopier.copy(audienceGenerationJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceGenerationJobs(AudienceGenerationJobSummary ... audienceGenerationJobs) {
            this.audienceGenerationJobs(Arrays.asList(audienceGenerationJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceGenerationJobs(Consumer<AudienceGenerationJobSummary.Builder> ... audienceGenerationJobs) {
            this.audienceGenerationJobs(Stream.of(audienceGenerationJobs).map(c -> (AudienceGenerationJobSummary)((AudienceGenerationJobSummary.Builder)AudienceGenerationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAudienceGenerationJobsResponse build() {
            return new ListAudienceGenerationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAudienceGenerationJobsResponse> {
        public Builder nextToken(String var1);

        public Builder audienceGenerationJobs(Collection<AudienceGenerationJobSummary> var1);

        public Builder audienceGenerationJobs(AudienceGenerationJobSummary ... var1);

        public Builder audienceGenerationJobs(Consumer<AudienceGenerationJobSummary.Builder> ... var1);
    }
}

