/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelInferenceJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse;

public class ListCollaborationTrainedModelInferenceJobsIterable
implements SdkIterable<ListCollaborationTrainedModelInferenceJobsResponse> {
    private final CleanRoomsMlClient client;
    private final ListCollaborationTrainedModelInferenceJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationTrainedModelInferenceJobsIterable(CleanRoomsMlClient client, ListCollaborationTrainedModelInferenceJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationTrainedModelInferenceJobsResponseFetcher();
    }

    public Iterator<ListCollaborationTrainedModelInferenceJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationTrainedModelInferenceJobSummary> collaborationTrainedModelInferenceJobs() {
        Function<ListCollaborationTrainedModelInferenceJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationTrainedModelInferenceJobs() != null) {
                return response.collaborationTrainedModelInferenceJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationTrainedModelInferenceJobsResponseFetcher
    implements SyncPageFetcher<ListCollaborationTrainedModelInferenceJobsResponse> {
        private ListCollaborationTrainedModelInferenceJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationTrainedModelInferenceJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationTrainedModelInferenceJobsResponse nextPage(ListCollaborationTrainedModelInferenceJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationTrainedModelInferenceJobsIterable.this.client.listCollaborationTrainedModelInferenceJobs(ListCollaborationTrainedModelInferenceJobsIterable.this.firstRequest);
            }
            return ListCollaborationTrainedModelInferenceJobsIterable.this.client.listCollaborationTrainedModelInferenceJobs((ListCollaborationTrainedModelInferenceJobsRequest)((Object)ListCollaborationTrainedModelInferenceJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

