/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary;

public class ListTrainedModelsIterable
implements SdkIterable<ListTrainedModelsResponse> {
    private final CleanRoomsMlClient client;
    private final ListTrainedModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrainedModelsIterable(CleanRoomsMlClient client, ListTrainedModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrainedModelsResponseFetcher();
    }

    public Iterator<ListTrainedModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrainedModelSummary> trainedModels() {
        Function<ListTrainedModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainedModels() != null) {
                return response.trainedModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrainedModelsResponseFetcher
    implements SyncPageFetcher<ListTrainedModelsResponse> {
        private ListTrainedModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainedModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrainedModelsResponse nextPage(ListTrainedModelsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainedModelsIterable.this.client.listTrainedModels(ListTrainedModelsIterable.this.firstRequest);
            }
            return ListTrainedModelsIterable.this.client.listTrainedModels((ListTrainedModelsRequest)((Object)ListTrainedModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

