/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cleanroomsml.model.AccessDeniedException;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlException;
import software.amazon.awssdk.services.cleanroomsml.model.ConflictException;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cleanroomsml.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ValidationException;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsIterable;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable;

/**
 * Service client for accessing AWS Clean Rooms ML. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Welcome to the <i>Amazon Web Services Clean Rooms ML API Reference</i>.
 * </p>
 * <p>
 * Amazon Web Services Clean Rooms ML provides a privacy-enhancing method for two parties to identify similar users in
 * their data without the need to share their data with each other. The first party brings the training data to Clean
 * Rooms so that they can create and configure an audience model (lookalike model) and associate it with a
 * collaboration. The second party then brings their seed data to Clean Rooms and generates an audience (lookalike
 * segment) that resembles the training data.
 * </p>
 * <p>
 * To learn more about Amazon Web Services Clean Rooms ML concepts, procedures, and best practices, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/machine-learning.html">Clean Rooms User Guide</a>.
 * </p>
 * <p>
 * To learn more about SQL commands, functions, and conditions supported in Clean Rooms, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/sql-reference/sql-reference.html">Clean Rooms SQL Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CleanRoomsMlClient extends AwsClient {
    String SERVICE_NAME = "cleanrooms-ml";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cleanrooms-ml";

    /**
     * <p>
     * Submits a request to cancel the trained model job.
     * </p>
     *
     * @param cancelTrainedModelRequest
     * @return Result of the CancelTrainedModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CancelTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelTrainedModelResponse cancelTrainedModel(CancelTrainedModelRequest cancelTrainedModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a request to cancel the trained model job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTrainedModelRequest.Builder} avoiding the
     * need to create one manually via {@link CancelTrainedModelRequest#builder()}
     * </p>
     *
     * @param cancelTrainedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelRequest.Builder} to create a
     *        request.
     * @return Result of the CancelTrainedModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CancelTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelTrainedModelResponse cancelTrainedModel(Consumer<CancelTrainedModelRequest.Builder> cancelTrainedModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return cancelTrainedModel(CancelTrainedModelRequest.builder().applyMutation(cancelTrainedModelRequest).build());
    }

    /**
     * <p>
     * Submits a request to cancel a trained model inference job.
     * </p>
     *
     * @param cancelTrainedModelInferenceJobRequest
     * @return Result of the CancelTrainedModelInferenceJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CancelTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelTrainedModelInferenceJobResponse cancelTrainedModelInferenceJob(
            CancelTrainedModelInferenceJobRequest cancelTrainedModelInferenceJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a request to cancel a trained model inference job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTrainedModelInferenceJobRequest.Builder}
     * avoiding the need to create one manually via {@link CancelTrainedModelInferenceJobRequest#builder()}
     * </p>
     *
     * @param cancelTrainedModelInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobRequest.Builder}
     *        to create a request.
     * @return Result of the CancelTrainedModelInferenceJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CancelTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelTrainedModelInferenceJobResponse cancelTrainedModelInferenceJob(
            Consumer<CancelTrainedModelInferenceJobRequest.Builder> cancelTrainedModelInferenceJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return cancelTrainedModelInferenceJob(CancelTrainedModelInferenceJobRequest.builder()
                .applyMutation(cancelTrainedModelInferenceJobRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     *
     * @param createAudienceModelRequest
     * @return Result of the CreateAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAudienceModelResponse createAudienceModel(CreateAudienceModelRequest createAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAudienceModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAudienceModelRequest#builder()}
     * </p>
     *
     * @param createAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAudienceModelResponse createAudienceModel(
            Consumer<CreateAudienceModelRequest.Builder> createAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createAudienceModel(CreateAudienceModelRequest.builder().applyMutation(createAudienceModelRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     * @return Result of the CreateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredAudienceModelResponse createConfiguredAudienceModel(
            CreateConfiguredAudienceModelRequest createConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return Result of the CreateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredAudienceModelResponse createConfiguredAudienceModel(
            Consumer<CreateConfiguredAudienceModelRequest.Builder> createConfiguredAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createConfiguredAudienceModel(CreateConfiguredAudienceModelRequest.builder()
                .applyMutation(createConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Creates a configured model algorithm using a container image stored in an ECR repository.
     * </p>
     *
     * @param createConfiguredModelAlgorithmRequest
     * @return Result of the CreateConfiguredModelAlgorithm operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredModelAlgorithmResponse createConfiguredModelAlgorithm(
            CreateConfiguredModelAlgorithmRequest createConfiguredModelAlgorithmRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configured model algorithm using a container image stored in an ECR repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredModelAlgorithmRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfiguredModelAlgorithmRequest#builder()}
     * </p>
     *
     * @param createConfiguredModelAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest.Builder}
     *        to create a request.
     * @return Result of the CreateConfiguredModelAlgorithm operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredModelAlgorithmResponse createConfiguredModelAlgorithm(
            Consumer<CreateConfiguredModelAlgorithmRequest.Builder> createConfiguredModelAlgorithmRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createConfiguredModelAlgorithm(CreateConfiguredModelAlgorithmRequest.builder()
                .applyMutation(createConfiguredModelAlgorithmRequest).build());
    }

    /**
     * <p>
     * Associates a configured model algorithm to a collaboration for use by any member of the collaboration.
     * </p>
     *
     * @param createConfiguredModelAlgorithmAssociationRequest
     * @return Result of the CreateConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredModelAlgorithmAssociationResponse createConfiguredModelAlgorithmAssociation(
            CreateConfiguredModelAlgorithmAssociationRequest createConfiguredModelAlgorithmAssociationRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a configured model algorithm to a collaboration for use by any member of the collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfiguredModelAlgorithmAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfiguredModelAlgorithmAssociationRequest#builder()}
     * </p>
     *
     * @param createConfiguredModelAlgorithmAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredModelAlgorithmAssociationResponse createConfiguredModelAlgorithmAssociation(
            Consumer<CreateConfiguredModelAlgorithmAssociationRequest.Builder> createConfiguredModelAlgorithmAssociationRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createConfiguredModelAlgorithmAssociation(CreateConfiguredModelAlgorithmAssociationRequest.builder()
                .applyMutation(createConfiguredModelAlgorithmAssociationRequest).build());
    }

    /**
     * <p>
     * Provides the information to create an ML input channel. An ML input channel is the result of a query that can be
     * used for ML modeling.
     * </p>
     *
     * @param createMlInputChannelRequest
     * @return Result of the CreateMLInputChannel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMlInputChannelResponse createMLInputChannel(CreateMlInputChannelRequest createMlInputChannelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information to create an ML input channel. An ML input channel is the result of a query that can be
     * used for ML modeling.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlInputChannelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMlInputChannelRequest#builder()}
     * </p>
     *
     * @param createMlInputChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMLInputChannel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMlInputChannelResponse createMLInputChannel(
            Consumer<CreateMlInputChannelRequest.Builder> createMlInputChannelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createMLInputChannel(CreateMlInputChannelRequest.builder().applyMutation(createMlInputChannelRequest).build());
    }

    /**
     * <p>
     * Creates a trained model from an associated configured model algorithm using data from any member of the
     * collaboration.
     * </p>
     *
     * @param createTrainedModelRequest
     * @return Result of the CreateTrainedModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrainedModelResponse createTrainedModel(CreateTrainedModelRequest createTrainedModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a trained model from an associated configured model algorithm using data from any member of the
     * collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainedModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrainedModelRequest#builder()}
     * </p>
     *
     * @param createTrainedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrainedModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrainedModelResponse createTrainedModel(Consumer<CreateTrainedModelRequest.Builder> createTrainedModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createTrainedModel(CreateTrainedModelRequest.builder().applyMutation(createTrainedModelRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     *
     * @param createTrainingDatasetRequest
     * @return Result of the CreateTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrainingDatasetResponse createTrainingDataset(CreateTrainingDatasetRequest createTrainingDatasetRequest)
            throws ConflictException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param createTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest.Builder} to create
     *        a request.
     * @return Result of the CreateTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrainingDatasetResponse createTrainingDataset(
            Consumer<CreateTrainingDatasetRequest.Builder> createTrainingDatasetRequest) throws ConflictException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return createTrainingDataset(CreateTrainingDatasetRequest.builder().applyMutation(createTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     * @return Result of the DeleteAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAudienceGenerationJobResponse deleteAudienceGenerationJob(
            DeleteAudienceGenerationJobRequest deleteAudienceGenerationJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAudienceGenerationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAudienceGenerationJobResponse deleteAudienceGenerationJob(
            Consumer<DeleteAudienceGenerationJobRequest.Builder> deleteAudienceGenerationJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return deleteAudienceGenerationJob(DeleteAudienceGenerationJobRequest.builder()
                .applyMutation(deleteAudienceGenerationJobRequest).build());
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     *
     * @param deleteAudienceModelRequest
     * @return Result of the DeleteAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAudienceModelResponse deleteAudienceModel(DeleteAudienceModelRequest deleteAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAudienceModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAudienceModelRequest#builder()}
     * </p>
     *
     * @param deleteAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAudienceModelResponse deleteAudienceModel(
            Consumer<DeleteAudienceModelRequest.Builder> deleteAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return deleteAudienceModel(DeleteAudienceModelRequest.builder().applyMutation(deleteAudienceModelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     * @return Result of the DeleteConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredAudienceModelResponse deleteConfiguredAudienceModel(
            DeleteConfiguredAudienceModelRequest deleteConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredAudienceModelResponse deleteConfiguredAudienceModel(
            Consumer<DeleteConfiguredAudienceModelRequest.Builder> deleteConfiguredAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return deleteConfiguredAudienceModel(DeleteConfiguredAudienceModelRequest.builder()
                .applyMutation(deleteConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     * @return Result of the DeleteConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredAudienceModelPolicyResponse deleteConfiguredAudienceModelPolicy(
            DeleteConfiguredAudienceModelPolicyRequest deleteConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredAudienceModelPolicyResponse deleteConfiguredAudienceModelPolicy(
            Consumer<DeleteConfiguredAudienceModelPolicyRequest.Builder> deleteConfiguredAudienceModelPolicyRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return deleteConfiguredAudienceModelPolicy(DeleteConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(deleteConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a configured model algorithm.
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmRequest
     * @return Result of the DeleteConfiguredModelAlgorithm operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredModelAlgorithmResponse deleteConfiguredModelAlgorithm(
            DeleteConfiguredModelAlgorithmRequest deleteConfiguredModelAlgorithmRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configured model algorithm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredModelAlgorithmRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredModelAlgorithmRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteConfiguredModelAlgorithm operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredModelAlgorithmResponse deleteConfiguredModelAlgorithm(
            Consumer<DeleteConfiguredModelAlgorithmRequest.Builder> deleteConfiguredModelAlgorithmRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return deleteConfiguredModelAlgorithm(DeleteConfiguredModelAlgorithmRequest.builder()
                .applyMutation(deleteConfiguredModelAlgorithmRequest).build());
    }

    /**
     * <p>
     * Deletes a configured model algorithm association.
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmAssociationRequest
     * @return Result of the DeleteConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredModelAlgorithmAssociationResponse deleteConfiguredModelAlgorithmAssociation(
            DeleteConfiguredModelAlgorithmAssociationRequest deleteConfiguredModelAlgorithmAssociationRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configured model algorithm association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfiguredModelAlgorithmAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfiguredModelAlgorithmAssociationRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredModelAlgorithmAssociationResponse deleteConfiguredModelAlgorithmAssociation(
            Consumer<DeleteConfiguredModelAlgorithmAssociationRequest.Builder> deleteConfiguredModelAlgorithmAssociationRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return deleteConfiguredModelAlgorithmAssociation(DeleteConfiguredModelAlgorithmAssociationRequest.builder()
                .applyMutation(deleteConfiguredModelAlgorithmAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a ML modeling configuration.
     * </p>
     *
     * @param deleteMlConfigurationRequest
     * @return Result of the DeleteMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMlConfigurationResponse deleteMLConfiguration(DeleteMlConfigurationRequest deleteMlConfigurationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a ML modeling configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMlConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteMlConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMlConfigurationResponse deleteMLConfiguration(
            Consumer<DeleteMlConfigurationRequest.Builder> deleteMlConfigurationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return deleteMLConfiguration(DeleteMlConfigurationRequest.builder().applyMutation(deleteMlConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides the information necessary to delete an ML input channel.
     * </p>
     *
     * @param deleteMlInputChannelDataRequest
     * @return Result of the DeleteMLInputChannelData operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteMLInputChannelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLInputChannelData"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMlInputChannelDataResponse deleteMLInputChannelData(
            DeleteMlInputChannelDataRequest deleteMlInputChannelDataRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information necessary to delete an ML input channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlInputChannelDataRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMlInputChannelDataRequest#builder()}
     * </p>
     *
     * @param deleteMlInputChannelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMLInputChannelData operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteMLInputChannelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLInputChannelData"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMlInputChannelDataResponse deleteMLInputChannelData(
            Consumer<DeleteMlInputChannelDataRequest.Builder> deleteMlInputChannelDataRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return deleteMLInputChannelData(DeleteMlInputChannelDataRequest.builder().applyMutation(deleteMlInputChannelDataRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the output of a trained model.
     * </p>
     *
     * @param deleteTrainedModelOutputRequest
     * @return Result of the DeleteTrainedModelOutput operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteTrainedModelOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainedModelOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrainedModelOutputResponse deleteTrainedModelOutput(
            DeleteTrainedModelOutputRequest deleteTrainedModelOutputRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the output of a trained model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrainedModelOutputRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrainedModelOutputRequest#builder()}
     * </p>
     *
     * @param deleteTrainedModelOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTrainedModelOutput operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteTrainedModelOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainedModelOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrainedModelOutputResponse deleteTrainedModelOutput(
            Consumer<DeleteTrainedModelOutputRequest.Builder> deleteTrainedModelOutputRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return deleteTrainedModelOutput(DeleteTrainedModelOutputRequest.builder().applyMutation(deleteTrainedModelOutputRequest)
                .build());
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     * @return Result of the DeleteTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrainingDatasetResponse deleteTrainingDataset(DeleteTrainingDatasetRequest deleteTrainingDatasetRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrainingDatasetResponse deleteTrainingDataset(
            Consumer<DeleteTrainingDatasetRequest.Builder> deleteTrainingDatasetRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return deleteTrainingDataset(DeleteTrainingDatasetRequest.builder().applyMutation(deleteTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     * @return Result of the GetAudienceGenerationJob operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAudienceGenerationJobResponse getAudienceGenerationJob(
            GetAudienceGenerationJobRequest getAudienceGenerationJobRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAudienceGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return Result of the GetAudienceGenerationJob operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAudienceGenerationJobResponse getAudienceGenerationJob(
            Consumer<GetAudienceGenerationJobRequest.Builder> getAudienceGenerationJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return getAudienceGenerationJob(GetAudienceGenerationJobRequest.builder().applyMutation(getAudienceGenerationJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     *
     * @param getAudienceModelRequest
     * @return Result of the GetAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAudienceModelResponse getAudienceModel(GetAudienceModelRequest getAudienceModelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAudienceModelRequest.Builder} avoiding the need
     * to create one manually via {@link GetAudienceModelRequest#builder()}
     * </p>
     *
     * @param getAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest.Builder} to create a
     *        request.
     * @return Result of the GetAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAudienceModelResponse getAudienceModel(Consumer<GetAudienceModelRequest.Builder> getAudienceModelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getAudienceModel(GetAudienceModelRequest.builder().applyMutation(getAudienceModelRequest).build());
    }

    /**
     * <p>
     * Returns information about the configured model algorithm association in a collaboration.
     * </p>
     *
     * @param getCollaborationConfiguredModelAlgorithmAssociationRequest
     * @return Result of the GetCollaborationConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCollaborationConfiguredModelAlgorithmAssociationResponse getCollaborationConfiguredModelAlgorithmAssociation(
            GetCollaborationConfiguredModelAlgorithmAssociationRequest getCollaborationConfiguredModelAlgorithmAssociationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the configured model algorithm association in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetCollaborationConfiguredModelAlgorithmAssociationRequest.Builder} avoiding the need to create one
     * manually via {@link GetCollaborationConfiguredModelAlgorithmAssociationRequest#builder()}
     * </p>
     *
     * @param getCollaborationConfiguredModelAlgorithmAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetCollaborationConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCollaborationConfiguredModelAlgorithmAssociationResponse getCollaborationConfiguredModelAlgorithmAssociation(
            Consumer<GetCollaborationConfiguredModelAlgorithmAssociationRequest.Builder> getCollaborationConfiguredModelAlgorithmAssociationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getCollaborationConfiguredModelAlgorithmAssociation(GetCollaborationConfiguredModelAlgorithmAssociationRequest
                .builder().applyMutation(getCollaborationConfiguredModelAlgorithmAssociationRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific ML input channel in a collaboration.
     * </p>
     *
     * @param getCollaborationMlInputChannelRequest
     * @return Result of the GetCollaborationMLInputChannel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCollaborationMlInputChannelResponse getCollaborationMLInputChannel(
            GetCollaborationMlInputChannelRequest getCollaborationMlInputChannelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific ML input channel in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCollaborationMlInputChannelRequest.Builder}
     * avoiding the need to create one manually via {@link GetCollaborationMlInputChannelRequest#builder()}
     * </p>
     *
     * @param getCollaborationMlInputChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelRequest.Builder}
     *        to create a request.
     * @return Result of the GetCollaborationMLInputChannel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCollaborationMlInputChannelResponse getCollaborationMLInputChannel(
            Consumer<GetCollaborationMlInputChannelRequest.Builder> getCollaborationMlInputChannelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getCollaborationMLInputChannel(GetCollaborationMlInputChannelRequest.builder()
                .applyMutation(getCollaborationMlInputChannelRequest).build());
    }

    /**
     * <p>
     * Returns information about a trained model in a collaboration.
     * </p>
     *
     * @param getCollaborationTrainedModelRequest
     * @return Result of the GetCollaborationTrainedModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCollaborationTrainedModelResponse getCollaborationTrainedModel(
            GetCollaborationTrainedModelRequest getCollaborationTrainedModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a trained model in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCollaborationTrainedModelRequest.Builder}
     * avoiding the need to create one manually via {@link GetCollaborationTrainedModelRequest#builder()}
     * </p>
     *
     * @param getCollaborationTrainedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelRequest.Builder} to
     *        create a request.
     * @return Result of the GetCollaborationTrainedModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCollaborationTrainedModelResponse getCollaborationTrainedModel(
            Consumer<GetCollaborationTrainedModelRequest.Builder> getCollaborationTrainedModelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getCollaborationTrainedModel(GetCollaborationTrainedModelRequest.builder()
                .applyMutation(getCollaborationTrainedModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     * @return Result of the GetConfiguredAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredAudienceModelResponse getConfiguredAudienceModel(
            GetConfiguredAudienceModelRequest getConfiguredAudienceModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredAudienceModelRequest.Builder} avoiding
     * the need to create one manually via {@link GetConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return Result of the GetConfiguredAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredAudienceModelResponse getConfiguredAudienceModel(
            Consumer<GetConfiguredAudienceModelRequest.Builder> getConfiguredAudienceModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return getConfiguredAudienceModel(GetConfiguredAudienceModelRequest.builder()
                .applyMutation(getConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     * @return Result of the GetConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredAudienceModelPolicyResponse getConfiguredAudienceModelPolicy(
            GetConfiguredAudienceModelPolicyRequest getConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the GetConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredAudienceModelPolicyResponse getConfiguredAudienceModelPolicy(
            Consumer<GetConfiguredAudienceModelPolicyRequest.Builder> getConfiguredAudienceModelPolicyRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getConfiguredAudienceModelPolicy(GetConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(getConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured model algorithm.
     * </p>
     *
     * @param getConfiguredModelAlgorithmRequest
     * @return Result of the GetConfiguredModelAlgorithm operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredModelAlgorithmResponse getConfiguredModelAlgorithm(
            GetConfiguredModelAlgorithmRequest getConfiguredModelAlgorithmRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured model algorithm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredModelAlgorithmRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfiguredModelAlgorithmRequest#builder()}
     * </p>
     *
     * @param getConfiguredModelAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmRequest.Builder} to
     *        create a request.
     * @return Result of the GetConfiguredModelAlgorithm operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredModelAlgorithmResponse getConfiguredModelAlgorithm(
            Consumer<GetConfiguredModelAlgorithmRequest.Builder> getConfiguredModelAlgorithmRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return getConfiguredModelAlgorithm(GetConfiguredModelAlgorithmRequest.builder()
                .applyMutation(getConfiguredModelAlgorithmRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured model algorithm association.
     * </p>
     *
     * @param getConfiguredModelAlgorithmAssociationRequest
     * @return Result of the GetConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredModelAlgorithmAssociationResponse getConfiguredModelAlgorithmAssociation(
            GetConfiguredModelAlgorithmAssociationRequest getConfiguredModelAlgorithmAssociationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured model algorithm association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetConfiguredModelAlgorithmAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link GetConfiguredModelAlgorithmAssociationRequest#builder()}
     * </p>
     *
     * @param getConfiguredModelAlgorithmAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredModelAlgorithmAssociationResponse getConfiguredModelAlgorithmAssociation(
            Consumer<GetConfiguredModelAlgorithmAssociationRequest.Builder> getConfiguredModelAlgorithmAssociationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getConfiguredModelAlgorithmAssociation(GetConfiguredModelAlgorithmAssociationRequest.builder()
                .applyMutation(getConfiguredModelAlgorithmAssociationRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific ML configuration.
     * </p>
     *
     * @param getMlConfigurationRequest
     * @return Result of the GetMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlConfigurationResponse getMLConfiguration(GetMlConfigurationRequest getMlConfigurationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific ML configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetMlConfigurationRequest#builder()}
     * </p>
     *
     * @param getMlConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlConfigurationResponse getMLConfiguration(Consumer<GetMlConfigurationRequest.Builder> getMlConfigurationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getMLConfiguration(GetMlConfigurationRequest.builder().applyMutation(getMlConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about an ML input channel.
     * </p>
     *
     * @param getMlInputChannelRequest
     * @return Result of the GetMLInputChannel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlInputChannelResponse getMLInputChannel(GetMlInputChannelRequest getMlInputChannelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an ML input channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlInputChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetMlInputChannelRequest#builder()}
     * </p>
     *
     * @param getMlInputChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelRequest.Builder} to create a
     *        request.
     * @return Result of the GetMLInputChannel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlInputChannelResponse getMLInputChannel(Consumer<GetMlInputChannelRequest.Builder> getMlInputChannelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getMLInputChannel(GetMlInputChannelRequest.builder().applyMutation(getMlInputChannelRequest).build());
    }

    /**
     * <p>
     * Returns information about a trained model.
     * </p>
     *
     * @param getTrainedModelRequest
     * @return Result of the GetTrainedModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTrainedModelResponse getTrainedModel(GetTrainedModelRequest getTrainedModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a trained model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrainedModelRequest.Builder} avoiding the need
     * to create one manually via {@link GetTrainedModelRequest#builder()}
     * </p>
     *
     * @param getTrainedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelRequest.Builder} to create a
     *        request.
     * @return Result of the GetTrainedModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModel" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTrainedModelResponse getTrainedModel(Consumer<GetTrainedModelRequest.Builder> getTrainedModelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getTrainedModel(GetTrainedModelRequest.builder().applyMutation(getTrainedModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a trained model inference job.
     * </p>
     *
     * @param getTrainedModelInferenceJobRequest
     * @return Result of the GetTrainedModelInferenceJob operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrainedModelInferenceJobResponse getTrainedModelInferenceJob(
            GetTrainedModelInferenceJobRequest getTrainedModelInferenceJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a trained model inference job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrainedModelInferenceJobRequest.Builder}
     * avoiding the need to create one manually via {@link GetTrainedModelInferenceJobRequest#builder()}
     * </p>
     *
     * @param getTrainedModelInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobRequest.Builder} to
     *        create a request.
     * @return Result of the GetTrainedModelInferenceJob operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrainedModelInferenceJobResponse getTrainedModelInferenceJob(
            Consumer<GetTrainedModelInferenceJobRequest.Builder> getTrainedModelInferenceJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return getTrainedModelInferenceJob(GetTrainedModelInferenceJobRequest.builder()
                .applyMutation(getTrainedModelInferenceJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     *
     * @param getTrainingDatasetRequest
     * @return Result of the GetTrainingDataset operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrainingDatasetResponse getTrainingDataset(GetTrainingDatasetRequest getTrainingDatasetRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link GetTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param getTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest.Builder} to create a
     *        request.
     * @return Result of the GetTrainingDataset operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrainingDatasetResponse getTrainingDataset(Consumer<GetTrainingDatasetRequest.Builder> getTrainingDatasetRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return getTrainingDataset(GetTrainingDatasetRequest.builder().applyMutation(getTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return Result of the ListAudienceExportJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsResponse listAudienceExportJobs(ListAudienceExportJobsRequest listAudienceExportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceExportJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListAudienceExportJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsResponse listAudienceExportJobs(
            Consumer<ListAudienceExportJobsRequest.Builder> listAudienceExportJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceExportJobs(ListAudienceExportJobsRequest.builder().applyMutation(listAudienceExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client.listAudienceExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client
     *             .listAudienceExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client.listAudienceExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsIterable listAudienceExportJobsPaginator(
            ListAudienceExportJobsRequest listAudienceExportJobsRequest) throws ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListAudienceExportJobsIterable(this, listAudienceExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client.listAudienceExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client
     *             .listAudienceExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsIterable responses = client.listAudienceExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceExportJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsIterable listAudienceExportJobsPaginator(
            Consumer<ListAudienceExportJobsRequest.Builder> listAudienceExportJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceExportJobsPaginator(ListAudienceExportJobsRequest.builder()
                .applyMutation(listAudienceExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return Result of the ListAudienceGenerationJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsResponse listAudienceGenerationJobs(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAudienceGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAudienceGenerationJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsResponse listAudienceGenerationJobs(
            Consumer<ListAudienceGenerationJobsRequest.Builder> listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceGenerationJobs(ListAudienceGenerationJobsRequest.builder()
                .applyMutation(listAudienceGenerationJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client.listAudienceGenerationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client
     *             .listAudienceGenerationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client.listAudienceGenerationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsIterable listAudienceGenerationJobsPaginator(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListAudienceGenerationJobsIterable(this, listAudienceGenerationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client.listAudienceGenerationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client
     *             .listAudienceGenerationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsIterable responses = client.listAudienceGenerationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAudienceGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsIterable listAudienceGenerationJobsPaginator(
            Consumer<ListAudienceGenerationJobsRequest.Builder> listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceGenerationJobsPaginator(ListAudienceGenerationJobsRequest.builder()
                .applyMutation(listAudienceGenerationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return Result of the ListAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsResponse listAudienceModels(ListAudienceModelsRequest listAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsResponse listAudienceModels(Consumer<ListAudienceModelsRequest.Builder> listAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceModels(ListAudienceModelsRequest.builder().applyMutation(listAudienceModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client.listAudienceModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client
     *             .listAudienceModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client.listAudienceModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsIterable listAudienceModelsPaginator(ListAudienceModelsRequest listAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListAudienceModelsIterable(this, listAudienceModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client.listAudienceModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client
     *             .listAudienceModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsIterable responses = client.listAudienceModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsIterable listAudienceModelsPaginator(
            Consumer<ListAudienceModelsRequest.Builder> listAudienceModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listAudienceModelsPaginator(ListAudienceModelsRequest.builder().applyMutation(listAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the configured model algorithm associations in a collaboration.
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     * @return Result of the ListCollaborationConfiguredModelAlgorithmAssociations operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationConfiguredModelAlgorithmAssociationsResponse listCollaborationConfiguredModelAlgorithmAssociations(
            ListCollaborationConfiguredModelAlgorithmAssociationsRequest listCollaborationConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the configured model algorithm associations in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder} avoiding the need to create one
     * manually via {@link ListCollaborationConfiguredModelAlgorithmAssociationsRequest#builder()}
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCollaborationConfiguredModelAlgorithmAssociations operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationConfiguredModelAlgorithmAssociationsResponse listCollaborationConfiguredModelAlgorithmAssociations(
            Consumer<ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder> listCollaborationConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationConfiguredModelAlgorithmAssociations(ListCollaborationConfiguredModelAlgorithmAssociationsRequest
                .builder().applyMutation(listCollaborationConfiguredModelAlgorithmAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsIterable responses = client.listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsIterable responses = client
     *             .listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsIterable responses = client.listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationConfiguredModelAlgorithmAssociationsIterable listCollaborationConfiguredModelAlgorithmAssociationsPaginator(
            ListCollaborationConfiguredModelAlgorithmAssociationsRequest listCollaborationConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListCollaborationConfiguredModelAlgorithmAssociationsIterable(this,
                listCollaborationConfiguredModelAlgorithmAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsIterable responses = client.listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsIterable responses = client
     *             .listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsIterable responses = client.listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder} avoiding the need to create one
     * manually via {@link ListCollaborationConfiguredModelAlgorithmAssociationsRequest#builder()}
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationConfiguredModelAlgorithmAssociationsIterable listCollaborationConfiguredModelAlgorithmAssociationsPaginator(
            Consumer<ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder> listCollaborationConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationConfiguredModelAlgorithmAssociationsPaginator(ListCollaborationConfiguredModelAlgorithmAssociationsRequest
                .builder().applyMutation(listCollaborationConfiguredModelAlgorithmAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the ML input channels in a collaboration.
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     * @return Result of the ListCollaborationMLInputChannels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationMlInputChannelsResponse listCollaborationMLInputChannels(
            ListCollaborationMlInputChannelsRequest listCollaborationMlInputChannelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the ML input channels in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationMlInputChannelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationMlInputChannelsRequest#builder()}
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCollaborationMLInputChannels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationMlInputChannelsResponse listCollaborationMLInputChannels(
            Consumer<ListCollaborationMlInputChannelsRequest.Builder> listCollaborationMlInputChannelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationMLInputChannels(ListCollaborationMlInputChannelsRequest.builder()
                .applyMutation(listCollaborationMlInputChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsIterable responses = client.listCollaborationMLInputChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsIterable responses = client
     *             .listCollaborationMLInputChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsIterable responses = client.listCollaborationMLInputChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationMLInputChannelsIterable listCollaborationMLInputChannelsPaginator(
            ListCollaborationMlInputChannelsRequest listCollaborationMlInputChannelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListCollaborationMLInputChannelsIterable(this, listCollaborationMlInputChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsIterable responses = client.listCollaborationMLInputChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsIterable responses = client
     *             .listCollaborationMLInputChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsIterable responses = client.listCollaborationMLInputChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationMlInputChannelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationMlInputChannelsRequest#builder()}
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationMLInputChannelsIterable listCollaborationMLInputChannelsPaginator(
            Consumer<ListCollaborationMlInputChannelsRequest.Builder> listCollaborationMlInputChannelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationMLInputChannelsPaginator(ListCollaborationMlInputChannelsRequest.builder()
                .applyMutation(listCollaborationMlInputChannelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the export jobs for a trained model in a collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     * @return Result of the ListCollaborationTrainedModelExportJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelExportJobsResponse listCollaborationTrainedModelExportJobs(
            ListCollaborationTrainedModelExportJobsRequest listCollaborationTrainedModelExportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the export jobs for a trained model in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationTrainedModelExportJobsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCollaborationTrainedModelExportJobsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCollaborationTrainedModelExportJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelExportJobsResponse listCollaborationTrainedModelExportJobs(
            Consumer<ListCollaborationTrainedModelExportJobsRequest.Builder> listCollaborationTrainedModelExportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationTrainedModelExportJobs(ListCollaborationTrainedModelExportJobsRequest.builder()
                .applyMutation(listCollaborationTrainedModelExportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModelExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsIterable responses = client.listCollaborationTrainedModelExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsIterable responses = client
     *             .listCollaborationTrainedModelExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsIterable responses = client.listCollaborationTrainedModelExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModelExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelExportJobsIterable listCollaborationTrainedModelExportJobsPaginator(
            ListCollaborationTrainedModelExportJobsRequest listCollaborationTrainedModelExportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListCollaborationTrainedModelExportJobsIterable(this, listCollaborationTrainedModelExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModelExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsIterable responses = client.listCollaborationTrainedModelExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsIterable responses = client
     *             .listCollaborationTrainedModelExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsIterable responses = client.listCollaborationTrainedModelExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModelExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationTrainedModelExportJobsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCollaborationTrainedModelExportJobsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelExportJobsIterable listCollaborationTrainedModelExportJobsPaginator(
            Consumer<ListCollaborationTrainedModelExportJobsRequest.Builder> listCollaborationTrainedModelExportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationTrainedModelExportJobsPaginator(ListCollaborationTrainedModelExportJobsRequest.builder()
                .applyMutation(listCollaborationTrainedModelExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs in a specified collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     * @return Result of the ListCollaborationTrainedModelInferenceJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelInferenceJobsResponse listCollaborationTrainedModelInferenceJobs(
            ListCollaborationTrainedModelInferenceJobsRequest listCollaborationTrainedModelInferenceJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs in a specified collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationTrainedModelInferenceJobsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCollaborationTrainedModelInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCollaborationTrainedModelInferenceJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelInferenceJobsResponse listCollaborationTrainedModelInferenceJobs(
            Consumer<ListCollaborationTrainedModelInferenceJobsRequest.Builder> listCollaborationTrainedModelInferenceJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationTrainedModelInferenceJobs(ListCollaborationTrainedModelInferenceJobsRequest.builder()
                .applyMutation(listCollaborationTrainedModelInferenceJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsIterable responses = client.listCollaborationTrainedModelInferenceJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsIterable responses = client
     *             .listCollaborationTrainedModelInferenceJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsIterable responses = client.listCollaborationTrainedModelInferenceJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelInferenceJobsIterable listCollaborationTrainedModelInferenceJobsPaginator(
            ListCollaborationTrainedModelInferenceJobsRequest listCollaborationTrainedModelInferenceJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListCollaborationTrainedModelInferenceJobsIterable(this, listCollaborationTrainedModelInferenceJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsIterable responses = client.listCollaborationTrainedModelInferenceJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsIterable responses = client
     *             .listCollaborationTrainedModelInferenceJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsIterable responses = client.listCollaborationTrainedModelInferenceJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationTrainedModelInferenceJobsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCollaborationTrainedModelInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelInferenceJobsIterable listCollaborationTrainedModelInferenceJobsPaginator(
            Consumer<ListCollaborationTrainedModelInferenceJobsRequest.Builder> listCollaborationTrainedModelInferenceJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationTrainedModelInferenceJobsPaginator(ListCollaborationTrainedModelInferenceJobsRequest.builder()
                .applyMutation(listCollaborationTrainedModelInferenceJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the trained models in a collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     * @return Result of the ListCollaborationTrainedModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelsResponse listCollaborationTrainedModels(
            ListCollaborationTrainedModelsRequest listCollaborationTrainedModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the trained models in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationTrainedModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationTrainedModelsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCollaborationTrainedModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelsResponse listCollaborationTrainedModels(
            Consumer<ListCollaborationTrainedModelsRequest.Builder> listCollaborationTrainedModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationTrainedModels(ListCollaborationTrainedModelsRequest.builder()
                .applyMutation(listCollaborationTrainedModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsIterable responses = client.listCollaborationTrainedModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsIterable responses = client
     *             .listCollaborationTrainedModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsIterable responses = client.listCollaborationTrainedModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelsIterable listCollaborationTrainedModelsPaginator(
            ListCollaborationTrainedModelsRequest listCollaborationTrainedModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListCollaborationTrainedModelsIterable(this, listCollaborationTrainedModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsIterable responses = client.listCollaborationTrainedModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsIterable responses = client
     *             .listCollaborationTrainedModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsIterable responses = client.listCollaborationTrainedModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationTrainedModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationTrainedModelsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelsIterable listCollaborationTrainedModelsPaginator(
            Consumer<ListCollaborationTrainedModelsRequest.Builder> listCollaborationTrainedModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listCollaborationTrainedModelsPaginator(ListCollaborationTrainedModelsRequest.builder()
                .applyMutation(listCollaborationTrainedModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return Result of the ListConfiguredAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsResponse listConfiguredAudienceModels(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredAudienceModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest.Builder} to
     *        create a request.
     * @return Result of the ListConfiguredAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsResponse listConfiguredAudienceModels(
            Consumer<ListConfiguredAudienceModelsRequest.Builder> listConfiguredAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listConfiguredAudienceModels(ListConfiguredAudienceModelsRequest.builder()
                .applyMutation(listConfiguredAudienceModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client.listConfiguredAudienceModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client
     *             .listConfiguredAudienceModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client.listConfiguredAudienceModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsIterable listConfiguredAudienceModelsPaginator(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListConfiguredAudienceModelsIterable(this, listConfiguredAudienceModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client.listConfiguredAudienceModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client
     *             .listConfiguredAudienceModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsIterable responses = client.listConfiguredAudienceModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredAudienceModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsIterable listConfiguredAudienceModelsPaginator(
            Consumer<ListConfiguredAudienceModelsRequest.Builder> listConfiguredAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listConfiguredAudienceModelsPaginator(ListConfiguredAudienceModelsRequest.builder()
                .applyMutation(listConfiguredAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of configured model algorithm associations.
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     * @return Result of the ListConfiguredModelAlgorithmAssociations operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmAssociationsResponse listConfiguredModelAlgorithmAssociations(
            ListConfiguredModelAlgorithmAssociationsRequest listConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of configured model algorithm associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListConfiguredModelAlgorithmAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListConfiguredModelAlgorithmAssociationsRequest#builder()}
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListConfiguredModelAlgorithmAssociations operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmAssociationsResponse listConfiguredModelAlgorithmAssociations(
            Consumer<ListConfiguredModelAlgorithmAssociationsRequest.Builder> listConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listConfiguredModelAlgorithmAssociations(ListConfiguredModelAlgorithmAssociationsRequest.builder()
                .applyMutation(listConfiguredModelAlgorithmAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsIterable responses = client.listConfiguredModelAlgorithmAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsIterable responses = client
     *             .listConfiguredModelAlgorithmAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsIterable responses = client.listConfiguredModelAlgorithmAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmAssociationsIterable listConfiguredModelAlgorithmAssociationsPaginator(
            ListConfiguredModelAlgorithmAssociationsRequest listConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListConfiguredModelAlgorithmAssociationsIterable(this, listConfiguredModelAlgorithmAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsIterable responses = client.listConfiguredModelAlgorithmAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsIterable responses = client
     *             .listConfiguredModelAlgorithmAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsIterable responses = client.listConfiguredModelAlgorithmAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListConfiguredModelAlgorithmAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListConfiguredModelAlgorithmAssociationsRequest#builder()}
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmAssociationsIterable listConfiguredModelAlgorithmAssociationsPaginator(
            Consumer<ListConfiguredModelAlgorithmAssociationsRequest.Builder> listConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listConfiguredModelAlgorithmAssociationsPaginator(ListConfiguredModelAlgorithmAssociationsRequest.builder()
                .applyMutation(listConfiguredModelAlgorithmAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of configured model algorithms.
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     * @return Result of the ListConfiguredModelAlgorithms operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmsResponse listConfiguredModelAlgorithms(
            ListConfiguredModelAlgorithmsRequest listConfiguredModelAlgorithmsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of configured model algorithms.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredModelAlgorithmsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredModelAlgorithmsRequest#builder()}
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest.Builder} to
     *        create a request.
     * @return Result of the ListConfiguredModelAlgorithms operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmsResponse listConfiguredModelAlgorithms(
            Consumer<ListConfiguredModelAlgorithmsRequest.Builder> listConfiguredModelAlgorithmsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listConfiguredModelAlgorithms(ListConfiguredModelAlgorithmsRequest.builder()
                .applyMutation(listConfiguredModelAlgorithmsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredModelAlgorithms(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsIterable responses = client.listConfiguredModelAlgorithmsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsIterable responses = client
     *             .listConfiguredModelAlgorithmsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsIterable responses = client.listConfiguredModelAlgorithmsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredModelAlgorithms(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmsIterable listConfiguredModelAlgorithmsPaginator(
            ListConfiguredModelAlgorithmsRequest listConfiguredModelAlgorithmsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListConfiguredModelAlgorithmsIterable(this, listConfiguredModelAlgorithmsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredModelAlgorithms(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsIterable responses = client.listConfiguredModelAlgorithmsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsIterable responses = client
     *             .listConfiguredModelAlgorithmsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsIterable responses = client.listConfiguredModelAlgorithmsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredModelAlgorithms(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredModelAlgorithmsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredModelAlgorithmsRequest#builder()}
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmsIterable listConfiguredModelAlgorithmsPaginator(
            Consumer<ListConfiguredModelAlgorithmsRequest.Builder> listConfiguredModelAlgorithmsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listConfiguredModelAlgorithmsPaginator(ListConfiguredModelAlgorithmsRequest.builder()
                .applyMutation(listConfiguredModelAlgorithmsRequest).build());
    }

    /**
     * <p>
     * Returns a list of ML input channels.
     * </p>
     *
     * @param listMlInputChannelsRequest
     * @return Result of the ListMLInputChannels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMlInputChannelsResponse listMLInputChannels(ListMlInputChannelsRequest listMlInputChannelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ML input channels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlInputChannelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMlInputChannelsRequest#builder()}
     * </p>
     *
     * @param listMlInputChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMLInputChannels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMlInputChannelsResponse listMLInputChannels(
            Consumer<ListMlInputChannelsRequest.Builder> listMlInputChannelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listMLInputChannels(ListMlInputChannelsRequest.builder().applyMutation(listMlInputChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsIterable responses = client.listMLInputChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsIterable responses = client
     *             .listMLInputChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsIterable responses = client.listMLInputChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMlInputChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMLInputChannelsIterable listMLInputChannelsPaginator(ListMlInputChannelsRequest listMlInputChannelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListMLInputChannelsIterable(this, listMlInputChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsIterable responses = client.listMLInputChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsIterable responses = client
     *             .listMLInputChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsIterable responses = client.listMLInputChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlInputChannelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMlInputChannelsRequest#builder()}
     * </p>
     *
     * @param listMlInputChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMLInputChannelsIterable listMLInputChannelsPaginator(
            Consumer<ListMlInputChannelsRequest.Builder> listMlInputChannelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listMLInputChannelsPaginator(ListMlInputChannelsRequest.builder().applyMutation(listMlInputChannelsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs that match the request parameters.
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     * @return Result of the ListTrainedModelInferenceJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelInferenceJobsResponse listTrainedModelInferenceJobs(
            ListTrainedModelInferenceJobsRequest listTrainedModelInferenceJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs that match the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelInferenceJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTrainedModelInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListTrainedModelInferenceJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelInferenceJobsResponse listTrainedModelInferenceJobs(
            Consumer<ListTrainedModelInferenceJobsRequest.Builder> listTrainedModelInferenceJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTrainedModelInferenceJobs(ListTrainedModelInferenceJobsRequest.builder()
                .applyMutation(listTrainedModelInferenceJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsIterable responses = client.listTrainedModelInferenceJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsIterable responses = client
     *             .listTrainedModelInferenceJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsIterable responses = client.listTrainedModelInferenceJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelInferenceJobsIterable listTrainedModelInferenceJobsPaginator(
            ListTrainedModelInferenceJobsRequest listTrainedModelInferenceJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListTrainedModelInferenceJobsIterable(this, listTrainedModelInferenceJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsIterable responses = client.listTrainedModelInferenceJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsIterable responses = client
     *             .listTrainedModelInferenceJobsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsIterable responses = client.listTrainedModelInferenceJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelInferenceJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTrainedModelInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelInferenceJobsIterable listTrainedModelInferenceJobsPaginator(
            Consumer<ListTrainedModelInferenceJobsRequest.Builder> listTrainedModelInferenceJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTrainedModelInferenceJobsPaginator(ListTrainedModelInferenceJobsRequest.builder()
                .applyMutation(listTrainedModelInferenceJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of trained models.
     * </p>
     *
     * @param listTrainedModelsRequest
     * @return Result of the ListTrainedModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelsResponse listTrainedModels(ListTrainedModelsRequest listTrainedModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of trained models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrainedModelsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTrainedModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelsResponse listTrainedModels(Consumer<ListTrainedModelsRequest.Builder> listTrainedModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTrainedModels(ListTrainedModelsRequest.builder().applyMutation(listTrainedModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsIterable responses = client.listTrainedModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsIterable responses = client
     *             .listTrainedModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsIterable responses = client.listTrainedModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainedModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelsIterable listTrainedModelsPaginator(ListTrainedModelsRequest listTrainedModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListTrainedModelsIterable(this, listTrainedModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsIterable responses = client.listTrainedModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsIterable responses = client
     *             .listTrainedModelsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsIterable responses = client.listTrainedModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrainedModelsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelsIterable listTrainedModelsPaginator(
            Consumer<ListTrainedModelsRequest.Builder> listTrainedModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTrainedModelsPaginator(ListTrainedModelsRequest.builder().applyMutation(listTrainedModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return Result of the ListTrainingDatasets operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsResponse listTrainingDatasets(ListTrainingDatasetsRequest listTrainingDatasetsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrainingDatasetsRequest#builder()}
     * </p>
     *
     * @param listTrainingDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTrainingDatasets operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsResponse listTrainingDatasets(
            Consumer<ListTrainingDatasetsRequest.Builder> listTrainingDatasetsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTrainingDatasets(ListTrainingDatasetsRequest.builder().applyMutation(listTrainingDatasetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client.listTrainingDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client
     *             .listTrainingDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client.listTrainingDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsIterable listTrainingDatasetsPaginator(ListTrainingDatasetsRequest listTrainingDatasetsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return new ListTrainingDatasetsIterable(this, listTrainingDatasetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client.listTrainingDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client
     *             .listTrainingDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsIterable responses = client.listTrainingDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrainingDatasetsRequest#builder()}
     * </p>
     *
     * @param listTrainingDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsIterable listTrainingDatasetsPaginator(
            Consumer<ListTrainingDatasetsRequest.Builder> listTrainingDatasetsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return listTrainingDatasetsPaginator(ListTrainingDatasetsRequest.builder().applyMutation(listTrainingDatasetsRequest)
                .build());
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     * @return Result of the PutConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfiguredAudienceModelPolicyResponse putConfiguredAudienceModelPolicy(
            PutConfiguredAudienceModelPolicyRequest putConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return Result of the PutConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfiguredAudienceModelPolicyResponse putConfiguredAudienceModelPolicy(
            Consumer<PutConfiguredAudienceModelPolicyRequest.Builder> putConfiguredAudienceModelPolicyRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return putConfiguredAudienceModelPolicy(PutConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(putConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Assigns information about an ML configuration.
     * </p>
     *
     * @param putMlConfigurationRequest
     * @return Result of the PutMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.PutMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMlConfigurationResponse putMLConfiguration(PutMlConfigurationRequest putMlConfigurationRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns information about an ML configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMlConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link PutMlConfigurationRequest#builder()}
     * </p>
     *
     * @param putMlConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the PutMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.PutMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMlConfigurationResponse putMLConfiguration(Consumer<PutMlConfigurationRequest.Builder> putMlConfigurationRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return putMLConfiguration(PutMlConfigurationRequest.builder().applyMutation(putMlConfigurationRequest).build());
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     *
     * @param startAudienceExportJobRequest
     * @return Result of the StartAudienceExportJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAudienceExportJobResponse startAudienceExportJob(StartAudienceExportJobRequest startAudienceExportJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAudienceExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartAudienceExportJobRequest#builder()}
     * </p>
     *
     * @param startAudienceExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest.Builder} to create
     *        a request.
     * @return Result of the StartAudienceExportJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAudienceExportJobResponse startAudienceExportJob(
            Consumer<StartAudienceExportJobRequest.Builder> startAudienceExportJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return startAudienceExportJob(StartAudienceExportJobRequest.builder().applyMutation(startAudienceExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     * @return Result of the StartAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAudienceGenerationJobResponse startAudienceGenerationJob(
            StartAudienceGenerationJobRequest startAudienceGenerationJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAudienceGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAudienceGenerationJobResponse startAudienceGenerationJob(
            Consumer<StartAudienceGenerationJobRequest.Builder> startAudienceGenerationJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        return startAudienceGenerationJob(StartAudienceGenerationJobRequest.builder()
                .applyMutation(startAudienceGenerationJobRequest).build());
    }

    /**
     * <p>
     * Provides the information necessary to start a trained model export job.
     * </p>
     *
     * @param startTrainedModelExportJobRequest
     * @return Result of the StartTrainedModelExportJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartTrainedModelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTrainedModelExportJobResponse startTrainedModelExportJob(
            StartTrainedModelExportJobRequest startTrainedModelExportJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information necessary to start a trained model export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTrainedModelExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTrainedModelExportJobRequest#builder()}
     * </p>
     *
     * @param startTrainedModelExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartTrainedModelExportJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartTrainedModelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTrainedModelExportJobResponse startTrainedModelExportJob(
            Consumer<StartTrainedModelExportJobRequest.Builder> startTrainedModelExportJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        return startTrainedModelExportJob(StartTrainedModelExportJobRequest.builder()
                .applyMutation(startTrainedModelExportJobRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to begin a trained model inference job.
     * </p>
     *
     * @param startTrainedModelInferenceJobRequest
     * @return Result of the StartTrainedModelInferenceJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTrainedModelInferenceJobResponse startTrainedModelInferenceJob(
            StartTrainedModelInferenceJobRequest startTrainedModelInferenceJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to begin a trained model inference job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTrainedModelInferenceJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartTrainedModelInferenceJobRequest#builder()}
     * </p>
     *
     * @param startTrainedModelInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartTrainedModelInferenceJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTrainedModelInferenceJobResponse startTrainedModelInferenceJob(
            Consumer<StartTrainedModelInferenceJobRequest.Builder> startTrainedModelInferenceJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return startTrainedModelInferenceJob(StartTrainedModelInferenceJobRequest.builder()
                .applyMutation(startTrainedModelInferenceJobRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     * @return Result of the UpdateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredAudienceModelResponse updateConfiguredAudienceModel(
            UpdateConfiguredAudienceModelRequest updateConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredAudienceModelResponse updateConfiguredAudienceModel(
            Consumer<UpdateConfiguredAudienceModelRequest.Builder> updateConfiguredAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        return updateConfiguredAudienceModel(UpdateConfiguredAudienceModelRequest.builder()
                .applyMutation(updateConfiguredAudienceModelRequest).build());
    }

    /**
     * Create a {@link CleanRoomsMlClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CleanRoomsMlClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CleanRoomsMlClient}.
     */
    static CleanRoomsMlClientBuilder builder() {
        return new DefaultCleanRoomsMlClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CleanRoomsMlServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
