/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cleanroomsml.internal.CleanRoomsMlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cleanroomsml.model.AccessDeniedException;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlException;
import software.amazon.awssdk.services.cleanroomsml.model.ConflictException;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cleanroomsml.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ValidationException;
import software.amazon.awssdk.services.cleanroomsml.transform.CancelTrainedModelInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CancelTrainedModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateConfiguredModelAlgorithmAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateConfiguredModelAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateMlInputChannelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateTrainedModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredModelAlgorithmAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredModelAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteMlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteMlInputChannelDataRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteTrainedModelOutputRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetCollaborationConfiguredModelAlgorithmAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetCollaborationMlInputChannelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetCollaborationTrainedModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredModelAlgorithmAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredModelAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetMlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetMlInputChannelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetTrainedModelInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetTrainedModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceExportJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceGenerationJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationConfiguredModelAlgorithmAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationMlInputChannelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationTrainedModelExportJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationTrainedModelInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationTrainedModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListConfiguredAudienceModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListConfiguredModelAlgorithmAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListConfiguredModelAlgorithmsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListMlInputChannelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTrainedModelInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTrainedModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTrainingDatasetsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.PutConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.PutMlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartAudienceExportJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartTrainedModelExportJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartTrainedModelInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.UpdateConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CleanRoomsMlAsyncClient}.
 *
 * @see CleanRoomsMlAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCleanRoomsMlAsyncClient implements CleanRoomsMlAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCleanRoomsMlAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCleanRoomsMlAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Submits a request to cancel the trained model job.
     * </p>
     *
     * @param cancelTrainedModelRequest
     * @return A Java Future containing the result of the CancelTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CancelTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelTrainedModelResponse> cancelTrainedModel(CancelTrainedModelRequest cancelTrainedModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelTrainedModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelTrainedModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelTrainedModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelTrainedModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelTrainedModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelTrainedModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelTrainedModelRequest, CancelTrainedModelResponse>()
                            .withOperationName("CancelTrainedModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelTrainedModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelTrainedModelRequest));
            CompletableFuture<CancelTrainedModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Submits a request to cancel a trained model inference job.
     * </p>
     *
     * @param cancelTrainedModelInferenceJobRequest
     * @return A Java Future containing the result of the CancelTrainedModelInferenceJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CancelTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelTrainedModelInferenceJobResponse> cancelTrainedModelInferenceJob(
            CancelTrainedModelInferenceJobRequest cancelTrainedModelInferenceJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelTrainedModelInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelTrainedModelInferenceJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelTrainedModelInferenceJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelTrainedModelInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelTrainedModelInferenceJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelTrainedModelInferenceJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelTrainedModelInferenceJobRequest, CancelTrainedModelInferenceJobResponse>()
                            .withOperationName("CancelTrainedModelInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelTrainedModelInferenceJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelTrainedModelInferenceJobRequest));
            CompletableFuture<CancelTrainedModelInferenceJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     *
     * @param createAudienceModelRequest
     * @return A Java Future containing the result of the CreateAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAudienceModelResponse> createAudienceModel(
            CreateAudienceModelRequest createAudienceModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAudienceModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAudienceModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAudienceModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAudienceModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAudienceModelRequest, CreateAudienceModelResponse>()
                            .withOperationName("CreateAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAudienceModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAudienceModelRequest));
            CompletableFuture<CreateAudienceModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the CreateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfiguredAudienceModelResponse> createConfiguredAudienceModel(
            CreateConfiguredAudienceModelRequest createConfiguredAudienceModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfiguredAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredAudienceModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfiguredAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConfiguredAudienceModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfiguredAudienceModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredAudienceModelRequest, CreateConfiguredAudienceModelResponse>()
                            .withOperationName("CreateConfiguredAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfiguredAudienceModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfiguredAudienceModelRequest));
            CompletableFuture<CreateConfiguredAudienceModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a configured model algorithm using a container image stored in an ECR repository.
     * </p>
     *
     * @param createConfiguredModelAlgorithmRequest
     * @return A Java Future containing the result of the CreateConfiguredModelAlgorithm operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfiguredModelAlgorithmResponse> createConfiguredModelAlgorithm(
            CreateConfiguredModelAlgorithmRequest createConfiguredModelAlgorithmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfiguredModelAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredModelAlgorithmRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredModelAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfiguredModelAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConfiguredModelAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfiguredModelAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredModelAlgorithmRequest, CreateConfiguredModelAlgorithmResponse>()
                            .withOperationName("CreateConfiguredModelAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfiguredModelAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfiguredModelAlgorithmRequest));
            CompletableFuture<CreateConfiguredModelAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a configured model algorithm to a collaboration for use by any member of the collaboration.
     * </p>
     *
     * @param createConfiguredModelAlgorithmAssociationRequest
     * @return A Java Future containing the result of the CreateConfiguredModelAlgorithmAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfiguredModelAlgorithmAssociationResponse> createConfiguredModelAlgorithmAssociation(
            CreateConfiguredModelAlgorithmAssociationRequest createConfiguredModelAlgorithmAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createConfiguredModelAlgorithmAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredModelAlgorithmAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredModelAlgorithmAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfiguredModelAlgorithmAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateConfiguredModelAlgorithmAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfiguredModelAlgorithmAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredModelAlgorithmAssociationRequest, CreateConfiguredModelAlgorithmAssociationResponse>()
                            .withOperationName("CreateConfiguredModelAlgorithmAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfiguredModelAlgorithmAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfiguredModelAlgorithmAssociationRequest));
            CompletableFuture<CreateConfiguredModelAlgorithmAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the information to create an ML input channel. An ML input channel is the result of a query that can be
     * used for ML modeling.
     * </p>
     *
     * @param createMlInputChannelRequest
     * @return A Java Future containing the result of the CreateMLInputChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMlInputChannelResponse> createMLInputChannel(
            CreateMlInputChannelRequest createMlInputChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMlInputChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMlInputChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMLInputChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMlInputChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMlInputChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMlInputChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMlInputChannelRequest, CreateMlInputChannelResponse>()
                            .withOperationName("CreateMLInputChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMlInputChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMlInputChannelRequest));
            CompletableFuture<CreateMlInputChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a trained model from an associated configured model algorithm using data from any member of the
     * collaboration.
     * </p>
     *
     * @param createTrainedModelRequest
     * @return A Java Future containing the result of the CreateTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrainedModelResponse> createTrainedModel(CreateTrainedModelRequest createTrainedModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrainedModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrainedModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrainedModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrainedModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTrainedModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrainedModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrainedModelRequest, CreateTrainedModelResponse>()
                            .withOperationName("CreateTrainedModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrainedModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrainedModelRequest));
            CompletableFuture<CreateTrainedModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     *
     * @param createTrainingDatasetRequest
     * @return A Java Future containing the result of the CreateTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrainingDatasetResponse> createTrainingDataset(
            CreateTrainingDatasetRequest createTrainingDatasetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrainingDatasetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrainingDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrainingDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrainingDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTrainingDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrainingDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrainingDatasetRequest, CreateTrainingDatasetResponse>()
                            .withOperationName("CreateTrainingDataset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrainingDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrainingDatasetRequest));
            CompletableFuture<CreateTrainingDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     * @return A Java Future containing the result of the DeleteAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAudienceGenerationJobResponse> deleteAudienceGenerationJob(
            DeleteAudienceGenerationJobRequest deleteAudienceGenerationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAudienceGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAudienceGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAudienceGenerationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAudienceGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAudienceGenerationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAudienceGenerationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAudienceGenerationJobRequest, DeleteAudienceGenerationJobResponse>()
                            .withOperationName("DeleteAudienceGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAudienceGenerationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAudienceGenerationJobRequest));
            CompletableFuture<DeleteAudienceGenerationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     *
     * @param deleteAudienceModelRequest
     * @return A Java Future containing the result of the DeleteAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAudienceModelResponse> deleteAudienceModel(
            DeleteAudienceModelRequest deleteAudienceModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAudienceModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAudienceModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAudienceModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAudienceModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAudienceModelRequest, DeleteAudienceModelResponse>()
                            .withOperationName("DeleteAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAudienceModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAudienceModelRequest));
            CompletableFuture<DeleteAudienceModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredAudienceModelResponse> deleteConfiguredAudienceModel(
            DeleteConfiguredAudienceModelRequest deleteConfiguredAudienceModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredAudienceModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfiguredAudienceModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredAudienceModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredAudienceModelRequest, DeleteConfiguredAudienceModelResponse>()
                            .withOperationName("DeleteConfiguredAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredAudienceModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredAudienceModelRequest));
            CompletableFuture<DeleteConfiguredAudienceModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredAudienceModelPolicyResponse> deleteConfiguredAudienceModelPolicy(
            DeleteConfiguredAudienceModelPolicyRequest deleteConfiguredAudienceModelPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredAudienceModelPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredAudienceModelPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredAudienceModelPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteConfiguredAudienceModelPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredAudienceModelPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredAudienceModelPolicyRequest, DeleteConfiguredAudienceModelPolicyResponse>()
                            .withOperationName("DeleteConfiguredAudienceModelPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredAudienceModelPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredAudienceModelPolicyRequest));
            CompletableFuture<DeleteConfiguredAudienceModelPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a configured model algorithm.
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmRequest
     * @return A Java Future containing the result of the DeleteConfiguredModelAlgorithm operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredModelAlgorithmResponse> deleteConfiguredModelAlgorithm(
            DeleteConfiguredModelAlgorithmRequest deleteConfiguredModelAlgorithmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredModelAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredModelAlgorithmRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredModelAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredModelAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfiguredModelAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredModelAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredModelAlgorithmRequest, DeleteConfiguredModelAlgorithmResponse>()
                            .withOperationName("DeleteConfiguredModelAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredModelAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredModelAlgorithmRequest));
            CompletableFuture<DeleteConfiguredModelAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a configured model algorithm association.
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmAssociationRequest
     * @return A Java Future containing the result of the DeleteConfiguredModelAlgorithmAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredModelAlgorithmAssociationResponse> deleteConfiguredModelAlgorithmAssociation(
            DeleteConfiguredModelAlgorithmAssociationRequest deleteConfiguredModelAlgorithmAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteConfiguredModelAlgorithmAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredModelAlgorithmAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredModelAlgorithmAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredModelAlgorithmAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteConfiguredModelAlgorithmAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredModelAlgorithmAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredModelAlgorithmAssociationRequest, DeleteConfiguredModelAlgorithmAssociationResponse>()
                            .withOperationName("DeleteConfiguredModelAlgorithmAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredModelAlgorithmAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredModelAlgorithmAssociationRequest));
            CompletableFuture<DeleteConfiguredModelAlgorithmAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a ML modeling configuration.
     * </p>
     *
     * @param deleteMlConfigurationRequest
     * @return A Java Future containing the result of the DeleteMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMlConfigurationResponse> deleteMLConfiguration(
            DeleteMlConfigurationRequest deleteMlConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMlConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMLConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMlConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMlConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMlConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMlConfigurationRequest, DeleteMlConfigurationResponse>()
                            .withOperationName("DeleteMLConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMlConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMlConfigurationRequest));
            CompletableFuture<DeleteMlConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the information necessary to delete an ML input channel.
     * </p>
     *
     * @param deleteMlInputChannelDataRequest
     * @return A Java Future containing the result of the DeleteMLInputChannelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteMLInputChannelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLInputChannelData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMlInputChannelDataResponse> deleteMLInputChannelData(
            DeleteMlInputChannelDataRequest deleteMlInputChannelDataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMlInputChannelDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMlInputChannelDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMLInputChannelData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMlInputChannelDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMlInputChannelDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMlInputChannelDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMlInputChannelDataRequest, DeleteMlInputChannelDataResponse>()
                            .withOperationName("DeleteMLInputChannelData").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMlInputChannelDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMlInputChannelDataRequest));
            CompletableFuture<DeleteMlInputChannelDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the output of a trained model.
     * </p>
     *
     * @param deleteTrainedModelOutputRequest
     * @return A Java Future containing the result of the DeleteTrainedModelOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteTrainedModelOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainedModelOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrainedModelOutputResponse> deleteTrainedModelOutput(
            DeleteTrainedModelOutputRequest deleteTrainedModelOutputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrainedModelOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrainedModelOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrainedModelOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrainedModelOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTrainedModelOutputResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrainedModelOutputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrainedModelOutputRequest, DeleteTrainedModelOutputResponse>()
                            .withOperationName("DeleteTrainedModelOutput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrainedModelOutputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrainedModelOutputRequest));
            CompletableFuture<DeleteTrainedModelOutputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     * @return A Java Future containing the result of the DeleteTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrainingDatasetResponse> deleteTrainingDataset(
            DeleteTrainingDatasetRequest deleteTrainingDatasetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrainingDatasetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrainingDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrainingDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrainingDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTrainingDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrainingDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrainingDatasetRequest, DeleteTrainingDatasetResponse>()
                            .withOperationName("DeleteTrainingDataset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrainingDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrainingDatasetRequest));
            CompletableFuture<DeleteTrainingDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     * @return A Java Future containing the result of the GetAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAudienceGenerationJobResponse> getAudienceGenerationJob(
            GetAudienceGenerationJobRequest getAudienceGenerationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAudienceGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAudienceGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAudienceGenerationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAudienceGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAudienceGenerationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAudienceGenerationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAudienceGenerationJobRequest, GetAudienceGenerationJobResponse>()
                            .withOperationName("GetAudienceGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAudienceGenerationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAudienceGenerationJobRequest));
            CompletableFuture<GetAudienceGenerationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     *
     * @param getAudienceModelRequest
     * @return A Java Future containing the result of the GetAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAudienceModelResponse> getAudienceModel(GetAudienceModelRequest getAudienceModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAudienceModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAudienceModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAudienceModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAudienceModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAudienceModelRequest, GetAudienceModelResponse>()
                            .withOperationName("GetAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAudienceModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAudienceModelRequest));
            CompletableFuture<GetAudienceModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the configured model algorithm association in a collaboration.
     * </p>
     *
     * @param getCollaborationConfiguredModelAlgorithmAssociationRequest
     * @return A Java Future containing the result of the GetCollaborationConfiguredModelAlgorithmAssociation operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCollaborationConfiguredModelAlgorithmAssociationResponse> getCollaborationConfiguredModelAlgorithmAssociation(
            GetCollaborationConfiguredModelAlgorithmAssociationRequest getCollaborationConfiguredModelAlgorithmAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getCollaborationConfiguredModelAlgorithmAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCollaborationConfiguredModelAlgorithmAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationConfiguredModelAlgorithmAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCollaborationConfiguredModelAlgorithmAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata,
                            GetCollaborationConfiguredModelAlgorithmAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCollaborationConfiguredModelAlgorithmAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationConfiguredModelAlgorithmAssociationRequest, GetCollaborationConfiguredModelAlgorithmAssociationResponse>()
                            .withOperationName("GetCollaborationConfiguredModelAlgorithmAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    new GetCollaborationConfiguredModelAlgorithmAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCollaborationConfiguredModelAlgorithmAssociationRequest));
            CompletableFuture<GetCollaborationConfiguredModelAlgorithmAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific ML input channel in a collaboration.
     * </p>
     *
     * @param getCollaborationMlInputChannelRequest
     * @return A Java Future containing the result of the GetCollaborationMLInputChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCollaborationMlInputChannelResponse> getCollaborationMLInputChannel(
            GetCollaborationMlInputChannelRequest getCollaborationMlInputChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCollaborationMlInputChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCollaborationMlInputChannelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationMLInputChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCollaborationMlInputChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCollaborationMlInputChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCollaborationMlInputChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationMlInputChannelRequest, GetCollaborationMlInputChannelResponse>()
                            .withOperationName("GetCollaborationMLInputChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCollaborationMlInputChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCollaborationMlInputChannelRequest));
            CompletableFuture<GetCollaborationMlInputChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a trained model in a collaboration.
     * </p>
     *
     * @param getCollaborationTrainedModelRequest
     * @return A Java Future containing the result of the GetCollaborationTrainedModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCollaborationTrainedModelResponse> getCollaborationTrainedModel(
            GetCollaborationTrainedModelRequest getCollaborationTrainedModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCollaborationTrainedModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCollaborationTrainedModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationTrainedModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCollaborationTrainedModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCollaborationTrainedModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCollaborationTrainedModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationTrainedModelRequest, GetCollaborationTrainedModelResponse>()
                            .withOperationName("GetCollaborationTrainedModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCollaborationTrainedModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCollaborationTrainedModelRequest));
            CompletableFuture<GetCollaborationTrainedModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the GetConfiguredAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredAudienceModelResponse> getConfiguredAudienceModel(
            GetConfiguredAudienceModelRequest getConfiguredAudienceModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConfiguredAudienceModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredAudienceModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConfiguredAudienceModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredAudienceModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredAudienceModelRequest, GetConfiguredAudienceModelResponse>()
                            .withOperationName("GetConfiguredAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredAudienceModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredAudienceModelRequest));
            CompletableFuture<GetConfiguredAudienceModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the GetConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredAudienceModelPolicyResponse> getConfiguredAudienceModelPolicy(
            GetConfiguredAudienceModelPolicyRequest getConfiguredAudienceModelPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredAudienceModelPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredAudienceModelPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredAudienceModelPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetConfiguredAudienceModelPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredAudienceModelPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredAudienceModelPolicyRequest, GetConfiguredAudienceModelPolicyResponse>()
                            .withOperationName("GetConfiguredAudienceModelPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredAudienceModelPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredAudienceModelPolicyRequest));
            CompletableFuture<GetConfiguredAudienceModelPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a configured model algorithm.
     * </p>
     *
     * @param getConfiguredModelAlgorithmRequest
     * @return A Java Future containing the result of the GetConfiguredModelAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredModelAlgorithmResponse> getConfiguredModelAlgorithm(
            GetConfiguredModelAlgorithmRequest getConfiguredModelAlgorithmRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredModelAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConfiguredModelAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredModelAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredModelAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConfiguredModelAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredModelAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredModelAlgorithmRequest, GetConfiguredModelAlgorithmResponse>()
                            .withOperationName("GetConfiguredModelAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredModelAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredModelAlgorithmRequest));
            CompletableFuture<GetConfiguredModelAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a configured model algorithm association.
     * </p>
     *
     * @param getConfiguredModelAlgorithmAssociationRequest
     * @return A Java Future containing the result of the GetConfiguredModelAlgorithmAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredModelAlgorithmAssociationResponse> getConfiguredModelAlgorithmAssociation(
            GetConfiguredModelAlgorithmAssociationRequest getConfiguredModelAlgorithmAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredModelAlgorithmAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfiguredModelAlgorithmAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredModelAlgorithmAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredModelAlgorithmAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetConfiguredModelAlgorithmAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredModelAlgorithmAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredModelAlgorithmAssociationRequest, GetConfiguredModelAlgorithmAssociationResponse>()
                            .withOperationName("GetConfiguredModelAlgorithmAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredModelAlgorithmAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredModelAlgorithmAssociationRequest));
            CompletableFuture<GetConfiguredModelAlgorithmAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific ML configuration.
     * </p>
     *
     * @param getMlConfigurationRequest
     * @return A Java Future containing the result of the GetMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMlConfigurationResponse> getMLConfiguration(GetMlConfigurationRequest getMlConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMlConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMlConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMlConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMlConfigurationRequest, GetMlConfigurationResponse>()
                            .withOperationName("GetMLConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMlConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMlConfigurationRequest));
            CompletableFuture<GetMlConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an ML input channel.
     * </p>
     *
     * @param getMlInputChannelRequest
     * @return A Java Future containing the result of the GetMLInputChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMlInputChannelResponse> getMLInputChannel(GetMlInputChannelRequest getMlInputChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMlInputChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlInputChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLInputChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMlInputChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMlInputChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMlInputChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMlInputChannelRequest, GetMlInputChannelResponse>()
                            .withOperationName("GetMLInputChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMlInputChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMlInputChannelRequest));
            CompletableFuture<GetMlInputChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a trained model.
     * </p>
     *
     * @param getTrainedModelRequest
     * @return A Java Future containing the result of the GetTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrainedModelResponse> getTrainedModel(GetTrainedModelRequest getTrainedModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrainedModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrainedModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrainedModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTrainedModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTrainedModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTrainedModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrainedModelRequest, GetTrainedModelResponse>()
                            .withOperationName("GetTrainedModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTrainedModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTrainedModelRequest));
            CompletableFuture<GetTrainedModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a trained model inference job.
     * </p>
     *
     * @param getTrainedModelInferenceJobRequest
     * @return A Java Future containing the result of the GetTrainedModelInferenceJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrainedModelInferenceJobResponse> getTrainedModelInferenceJob(
            GetTrainedModelInferenceJobRequest getTrainedModelInferenceJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrainedModelInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrainedModelInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrainedModelInferenceJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTrainedModelInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTrainedModelInferenceJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTrainedModelInferenceJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrainedModelInferenceJobRequest, GetTrainedModelInferenceJobResponse>()
                            .withOperationName("GetTrainedModelInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTrainedModelInferenceJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTrainedModelInferenceJobRequest));
            CompletableFuture<GetTrainedModelInferenceJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     *
     * @param getTrainingDatasetRequest
     * @return A Java Future containing the result of the GetTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrainingDatasetResponse> getTrainingDataset(GetTrainingDatasetRequest getTrainingDatasetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrainingDatasetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrainingDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrainingDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTrainingDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTrainingDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTrainingDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrainingDatasetRequest, GetTrainingDatasetResponse>()
                            .withOperationName("GetTrainingDataset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTrainingDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTrainingDatasetRequest));
            CompletableFuture<GetTrainingDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return A Java Future containing the result of the ListAudienceExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAudienceExportJobsResponse> listAudienceExportJobs(
            ListAudienceExportJobsRequest listAudienceExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAudienceExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAudienceExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAudienceExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAudienceExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAudienceExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAudienceExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAudienceExportJobsRequest, ListAudienceExportJobsResponse>()
                            .withOperationName("ListAudienceExportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAudienceExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAudienceExportJobsRequest));
            CompletableFuture<ListAudienceExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return A Java Future containing the result of the ListAudienceGenerationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAudienceGenerationJobsResponse> listAudienceGenerationJobs(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAudienceGenerationJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAudienceGenerationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAudienceGenerationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAudienceGenerationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAudienceGenerationJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAudienceGenerationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAudienceGenerationJobsRequest, ListAudienceGenerationJobsResponse>()
                            .withOperationName("ListAudienceGenerationJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAudienceGenerationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAudienceGenerationJobsRequest));
            CompletableFuture<ListAudienceGenerationJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return A Java Future containing the result of the ListAudienceModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAudienceModelsResponse> listAudienceModels(ListAudienceModelsRequest listAudienceModelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAudienceModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAudienceModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAudienceModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAudienceModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAudienceModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAudienceModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAudienceModelsRequest, ListAudienceModelsResponse>()
                            .withOperationName("ListAudienceModels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAudienceModelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAudienceModelsRequest));
            CompletableFuture<ListAudienceModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the configured model algorithm associations in a collaboration.
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     * @return A Java Future containing the result of the ListCollaborationConfiguredModelAlgorithmAssociations
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> listCollaborationConfiguredModelAlgorithmAssociations(
            ListCollaborationConfiguredModelAlgorithmAssociationsRequest listCollaborationConfiguredModelAlgorithmAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listCollaborationConfiguredModelAlgorithmAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationConfiguredModelAlgorithmAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "ListCollaborationConfiguredModelAlgorithmAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata,
                            ListCollaborationConfiguredModelAlgorithmAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationConfiguredModelAlgorithmAssociationsRequest, ListCollaborationConfiguredModelAlgorithmAssociationsResponse>()
                            .withOperationName("ListCollaborationConfiguredModelAlgorithmAssociations")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    new ListCollaborationConfiguredModelAlgorithmAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationConfiguredModelAlgorithmAssociationsRequest));
            CompletableFuture<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the ML input channels in a collaboration.
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     * @return A Java Future containing the result of the ListCollaborationMLInputChannels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationMlInputChannelsResponse> listCollaborationMLInputChannels(
            ListCollaborationMlInputChannelsRequest listCollaborationMlInputChannelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationMlInputChannelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationMlInputChannelsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationMLInputChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationMlInputChannelsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCollaborationMlInputChannelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationMlInputChannelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationMlInputChannelsRequest, ListCollaborationMlInputChannelsResponse>()
                            .withOperationName("ListCollaborationMLInputChannels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationMlInputChannelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationMlInputChannelsRequest));
            CompletableFuture<ListCollaborationMlInputChannelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the export jobs for a trained model in a collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     * @return A Java Future containing the result of the ListCollaborationTrainedModelExportJobs operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationTrainedModelExportJobsResponse> listCollaborationTrainedModelExportJobs(
            ListCollaborationTrainedModelExportJobsRequest listCollaborationTrainedModelExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationTrainedModelExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationTrainedModelExportJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationTrainedModelExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationTrainedModelExportJobsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCollaborationTrainedModelExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationTrainedModelExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationTrainedModelExportJobsRequest, ListCollaborationTrainedModelExportJobsResponse>()
                            .withOperationName("ListCollaborationTrainedModelExportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationTrainedModelExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationTrainedModelExportJobsRequest));
            CompletableFuture<ListCollaborationTrainedModelExportJobsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs in a specified collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     * @return A Java Future containing the result of the ListCollaborationTrainedModelInferenceJobs operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationTrainedModelInferenceJobsResponse> listCollaborationTrainedModelInferenceJobs(
            ListCollaborationTrainedModelInferenceJobsRequest listCollaborationTrainedModelInferenceJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listCollaborationTrainedModelInferenceJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationTrainedModelInferenceJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationTrainedModelInferenceJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationTrainedModelInferenceJobsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCollaborationTrainedModelInferenceJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationTrainedModelInferenceJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationTrainedModelInferenceJobsRequest, ListCollaborationTrainedModelInferenceJobsResponse>()
                            .withOperationName("ListCollaborationTrainedModelInferenceJobs")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationTrainedModelInferenceJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationTrainedModelInferenceJobsRequest));
            CompletableFuture<ListCollaborationTrainedModelInferenceJobsResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the trained models in a collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     * @return A Java Future containing the result of the ListCollaborationTrainedModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationTrainedModelsResponse> listCollaborationTrainedModels(
            ListCollaborationTrainedModelsRequest listCollaborationTrainedModelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationTrainedModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationTrainedModelsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationTrainedModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationTrainedModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCollaborationTrainedModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationTrainedModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationTrainedModelsRequest, ListCollaborationTrainedModelsResponse>()
                            .withOperationName("ListCollaborationTrainedModels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationTrainedModelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationTrainedModelsRequest));
            CompletableFuture<ListCollaborationTrainedModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return A Java Future containing the result of the ListConfiguredAudienceModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConfiguredAudienceModelsResponse> listConfiguredAudienceModels(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConfiguredAudienceModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConfiguredAudienceModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredAudienceModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConfiguredAudienceModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConfiguredAudienceModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConfiguredAudienceModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredAudienceModelsRequest, ListConfiguredAudienceModelsResponse>()
                            .withOperationName("ListConfiguredAudienceModels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListConfiguredAudienceModelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConfiguredAudienceModelsRequest));
            CompletableFuture<ListConfiguredAudienceModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of configured model algorithm associations.
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     * @return A Java Future containing the result of the ListConfiguredModelAlgorithmAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConfiguredModelAlgorithmAssociationsResponse> listConfiguredModelAlgorithmAssociations(
            ListConfiguredModelAlgorithmAssociationsRequest listConfiguredModelAlgorithmAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listConfiguredModelAlgorithmAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConfiguredModelAlgorithmAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredModelAlgorithmAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConfiguredModelAlgorithmAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListConfiguredModelAlgorithmAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConfiguredModelAlgorithmAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredModelAlgorithmAssociationsRequest, ListConfiguredModelAlgorithmAssociationsResponse>()
                            .withOperationName("ListConfiguredModelAlgorithmAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListConfiguredModelAlgorithmAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConfiguredModelAlgorithmAssociationsRequest));
            CompletableFuture<ListConfiguredModelAlgorithmAssociationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of configured model algorithms.
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     * @return A Java Future containing the result of the ListConfiguredModelAlgorithms operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConfiguredModelAlgorithmsResponse> listConfiguredModelAlgorithms(
            ListConfiguredModelAlgorithmsRequest listConfiguredModelAlgorithmsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConfiguredModelAlgorithmsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConfiguredModelAlgorithmsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredModelAlgorithms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConfiguredModelAlgorithmsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConfiguredModelAlgorithmsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConfiguredModelAlgorithmsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredModelAlgorithmsRequest, ListConfiguredModelAlgorithmsResponse>()
                            .withOperationName("ListConfiguredModelAlgorithms").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListConfiguredModelAlgorithmsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConfiguredModelAlgorithmsRequest));
            CompletableFuture<ListConfiguredModelAlgorithmsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of ML input channels.
     * </p>
     *
     * @param listMlInputChannelsRequest
     * @return A Java Future containing the result of the ListMLInputChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMlInputChannelsResponse> listMLInputChannels(
            ListMlInputChannelsRequest listMlInputChannelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMlInputChannelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlInputChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLInputChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMlInputChannelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMlInputChannelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMlInputChannelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMlInputChannelsRequest, ListMlInputChannelsResponse>()
                            .withOperationName("ListMLInputChannels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMlInputChannelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMlInputChannelsRequest));
            CompletableFuture<ListMlInputChannelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs that match the request parameters.
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     * @return A Java Future containing the result of the ListTrainedModelInferenceJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrainedModelInferenceJobsResponse> listTrainedModelInferenceJobs(
            ListTrainedModelInferenceJobsRequest listTrainedModelInferenceJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrainedModelInferenceJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTrainedModelInferenceJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrainedModelInferenceJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTrainedModelInferenceJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTrainedModelInferenceJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTrainedModelInferenceJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTrainedModelInferenceJobsRequest, ListTrainedModelInferenceJobsResponse>()
                            .withOperationName("ListTrainedModelInferenceJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTrainedModelInferenceJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTrainedModelInferenceJobsRequest));
            CompletableFuture<ListTrainedModelInferenceJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of trained models.
     * </p>
     *
     * @param listTrainedModelsRequest
     * @return A Java Future containing the result of the ListTrainedModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrainedModelsResponse> listTrainedModels(ListTrainedModelsRequest listTrainedModelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrainedModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrainedModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrainedModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTrainedModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTrainedModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTrainedModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTrainedModelsRequest, ListTrainedModelsResponse>()
                            .withOperationName("ListTrainedModels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTrainedModelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTrainedModelsRequest));
            CompletableFuture<ListTrainedModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return A Java Future containing the result of the ListTrainingDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrainingDatasetsResponse> listTrainingDatasets(
            ListTrainingDatasetsRequest listTrainingDatasetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrainingDatasetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrainingDatasetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrainingDatasets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTrainingDatasetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTrainingDatasetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTrainingDatasetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTrainingDatasetsRequest, ListTrainingDatasetsResponse>()
                            .withOperationName("ListTrainingDatasets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTrainingDatasetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTrainingDatasetsRequest));
            CompletableFuture<ListTrainingDatasetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the PutConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfiguredAudienceModelPolicyResponse> putConfiguredAudienceModelPolicy(
            PutConfiguredAudienceModelPolicyRequest putConfiguredAudienceModelPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConfiguredAudienceModelPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfiguredAudienceModelPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfiguredAudienceModelPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutConfiguredAudienceModelPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfiguredAudienceModelPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfiguredAudienceModelPolicyRequest, PutConfiguredAudienceModelPolicyResponse>()
                            .withOperationName("PutConfiguredAudienceModelPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutConfiguredAudienceModelPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putConfiguredAudienceModelPolicyRequest));
            CompletableFuture<PutConfiguredAudienceModelPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns information about an ML configuration.
     * </p>
     *
     * @param putMlConfigurationRequest
     * @return A Java Future containing the result of the PutMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.PutMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutMlConfigurationResponse> putMLConfiguration(PutMlConfigurationRequest putMlConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMlConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMLConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMlConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMlConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutMlConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMlConfigurationRequest, PutMlConfigurationResponse>()
                            .withOperationName("PutMLConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutMlConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putMlConfigurationRequest));
            CompletableFuture<PutMlConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     *
     * @param startAudienceExportJobRequest
     * @return A Java Future containing the result of the StartAudienceExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartAudienceExportJobResponse> startAudienceExportJob(
            StartAudienceExportJobRequest startAudienceExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAudienceExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAudienceExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAudienceExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAudienceExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAudienceExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartAudienceExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAudienceExportJobRequest, StartAudienceExportJobResponse>()
                            .withOperationName("StartAudienceExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartAudienceExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startAudienceExportJobRequest));
            CompletableFuture<StartAudienceExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     * @return A Java Future containing the result of the StartAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartAudienceGenerationJobResponse> startAudienceGenerationJob(
            StartAudienceGenerationJobRequest startAudienceGenerationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAudienceGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAudienceGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAudienceGenerationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAudienceGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAudienceGenerationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartAudienceGenerationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAudienceGenerationJobRequest, StartAudienceGenerationJobResponse>()
                            .withOperationName("StartAudienceGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartAudienceGenerationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startAudienceGenerationJobRequest));
            CompletableFuture<StartAudienceGenerationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the information necessary to start a trained model export job.
     * </p>
     *
     * @param startTrainedModelExportJobRequest
     * @return A Java Future containing the result of the StartTrainedModelExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartTrainedModelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTrainedModelExportJobResponse> startTrainedModelExportJob(
            StartTrainedModelExportJobRequest startTrainedModelExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTrainedModelExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTrainedModelExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTrainedModelExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTrainedModelExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTrainedModelExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartTrainedModelExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTrainedModelExportJobRequest, StartTrainedModelExportJobResponse>()
                            .withOperationName("StartTrainedModelExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartTrainedModelExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startTrainedModelExportJobRequest));
            CompletableFuture<StartTrainedModelExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the information necessary to begin a trained model inference job.
     * </p>
     *
     * @param startTrainedModelInferenceJobRequest
     * @return A Java Future containing the result of the StartTrainedModelInferenceJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTrainedModelInferenceJobResponse> startTrainedModelInferenceJob(
            StartTrainedModelInferenceJobRequest startTrainedModelInferenceJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTrainedModelInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startTrainedModelInferenceJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTrainedModelInferenceJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTrainedModelInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTrainedModelInferenceJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartTrainedModelInferenceJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTrainedModelInferenceJobRequest, StartTrainedModelInferenceJobResponse>()
                            .withOperationName("StartTrainedModelInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartTrainedModelInferenceJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startTrainedModelInferenceJobRequest));
            CompletableFuture<StartTrainedModelInferenceJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the UpdateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConfiguredAudienceModelResponse> updateConfiguredAudienceModel(
            UpdateConfiguredAudienceModelRequest updateConfiguredAudienceModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConfiguredAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfiguredAudienceModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConfiguredAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConfiguredAudienceModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConfiguredAudienceModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConfiguredAudienceModelRequest, UpdateConfiguredAudienceModelResponse>()
                            .withOperationName("UpdateConfiguredAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConfiguredAudienceModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConfiguredAudienceModelRequest));
            CompletableFuture<UpdateConfiguredAudienceModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final CleanRoomsMlServiceClientConfiguration serviceClientConfiguration() {
        return new CleanRoomsMlServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CleanRoomsMlException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CleanRoomsMlServiceClientConfigurationBuilder serviceConfigBuilder = new CleanRoomsMlServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
