/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cleanroomsml.internal.CleanRoomsMlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cleanroomsml.model.AccessDeniedException;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlException;
import software.amazon.awssdk.services.cleanroomsml.model.ConflictException;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cleanroomsml.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ValidationException;
import software.amazon.awssdk.services.cleanroomsml.transform.CancelTrainedModelInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CancelTrainedModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateConfiguredModelAlgorithmAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateConfiguredModelAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateMlInputChannelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateTrainedModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredModelAlgorithmAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredModelAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteMlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteMlInputChannelDataRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteTrainedModelOutputRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetCollaborationConfiguredModelAlgorithmAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetCollaborationMlInputChannelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetCollaborationTrainedModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredModelAlgorithmAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredModelAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetMlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetMlInputChannelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetTrainedModelInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetTrainedModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceExportJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceGenerationJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationConfiguredModelAlgorithmAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationMlInputChannelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationTrainedModelExportJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationTrainedModelInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListCollaborationTrainedModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListConfiguredAudienceModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListConfiguredModelAlgorithmAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListConfiguredModelAlgorithmsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListMlInputChannelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTrainedModelInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTrainedModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTrainingDatasetsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.PutConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.PutMlConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartAudienceExportJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartTrainedModelExportJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartTrainedModelInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.UpdateConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link CleanRoomsMlClient}.
 *
 * @see CleanRoomsMlClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCleanRoomsMlClient implements CleanRoomsMlClient {
    private static final Logger log = Logger.loggerFor(DefaultCleanRoomsMlClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCleanRoomsMlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Submits a request to cancel the trained model job.
     * </p>
     *
     * @param cancelTrainedModelRequest
     * @return Result of the CancelTrainedModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CancelTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelTrainedModelResponse cancelTrainedModel(CancelTrainedModelRequest cancelTrainedModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelTrainedModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelTrainedModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelTrainedModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelTrainedModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelTrainedModel");

            return clientHandler.execute(new ClientExecutionParams<CancelTrainedModelRequest, CancelTrainedModelResponse>()
                    .withOperationName("CancelTrainedModel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelTrainedModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelTrainedModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Submits a request to cancel a trained model inference job.
     * </p>
     *
     * @param cancelTrainedModelInferenceJobRequest
     * @return Result of the CancelTrainedModelInferenceJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CancelTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelTrainedModelInferenceJobResponse cancelTrainedModelInferenceJob(
            CancelTrainedModelInferenceJobRequest cancelTrainedModelInferenceJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelTrainedModelInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelTrainedModelInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelTrainedModelInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelTrainedModelInferenceJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelTrainedModelInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelTrainedModelInferenceJobRequest, CancelTrainedModelInferenceJobResponse>()
                            .withOperationName("CancelTrainedModelInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelTrainedModelInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelTrainedModelInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     *
     * @param createAudienceModelRequest
     * @return Result of the CreateAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAudienceModelResponse createAudienceModel(CreateAudienceModelRequest createAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAudienceModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAudienceModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAudienceModel");

            return clientHandler.execute(new ClientExecutionParams<CreateAudienceModelRequest, CreateAudienceModelResponse>()
                    .withOperationName("CreateAudienceModel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAudienceModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAudienceModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     * @return Result of the CreateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConfiguredAudienceModelResponse createConfiguredAudienceModel(
            CreateConfiguredAudienceModelRequest createConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConfiguredAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConfiguredAudienceModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfiguredAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredAudienceModel");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredAudienceModelRequest, CreateConfiguredAudienceModelResponse>()
                            .withOperationName("CreateConfiguredAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createConfiguredAudienceModelRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateConfiguredAudienceModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a configured model algorithm using a container image stored in an ECR repository.
     * </p>
     *
     * @param createConfiguredModelAlgorithmRequest
     * @return Result of the CreateConfiguredModelAlgorithm operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConfiguredModelAlgorithmResponse createConfiguredModelAlgorithm(
            CreateConfiguredModelAlgorithmRequest createConfiguredModelAlgorithmRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConfiguredModelAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConfiguredModelAlgorithmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfiguredModelAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredModelAlgorithmRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredModelAlgorithm");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredModelAlgorithmRequest, CreateConfiguredModelAlgorithmResponse>()
                            .withOperationName("CreateConfiguredModelAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createConfiguredModelAlgorithmRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateConfiguredModelAlgorithmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a configured model algorithm to a collaboration for use by any member of the collaboration.
     * </p>
     *
     * @param createConfiguredModelAlgorithmAssociationRequest
     * @return Result of the CreateConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConfiguredModelAlgorithmAssociationResponse createConfiguredModelAlgorithmAssociation(
            CreateConfiguredModelAlgorithmAssociationRequest createConfiguredModelAlgorithmAssociationRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConfiguredModelAlgorithmAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateConfiguredModelAlgorithmAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createConfiguredModelAlgorithmAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredModelAlgorithmAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredModelAlgorithmAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredModelAlgorithmAssociationRequest, CreateConfiguredModelAlgorithmAssociationResponse>()
                            .withOperationName("CreateConfiguredModelAlgorithmAssociation")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(createConfiguredModelAlgorithmAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateConfiguredModelAlgorithmAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the information to create an ML input channel. An ML input channel is the result of a query that can be
     * used for ML modeling.
     * </p>
     *
     * @param createMlInputChannelRequest
     * @return Result of the CreateMLInputChannel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMlInputChannelResponse createMLInputChannel(CreateMlInputChannelRequest createMlInputChannelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMlInputChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMlInputChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMlInputChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMlInputChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMLInputChannel");

            return clientHandler.execute(new ClientExecutionParams<CreateMlInputChannelRequest, CreateMlInputChannelResponse>()
                    .withOperationName("CreateMLInputChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createMlInputChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMlInputChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a trained model from an associated configured model algorithm using data from any member of the
     * collaboration.
     * </p>
     *
     * @param createTrainedModelRequest
     * @return Result of the CreateTrainedModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrainedModelResponse createTrainedModel(CreateTrainedModelRequest createTrainedModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrainedModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTrainedModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrainedModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrainedModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrainedModel");

            return clientHandler.execute(new ClientExecutionParams<CreateTrainedModelRequest, CreateTrainedModelResponse>()
                    .withOperationName("CreateTrainedModel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTrainedModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrainedModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     *
     * @param createTrainingDatasetRequest
     * @return Result of the CreateTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrainingDatasetResponse createTrainingDataset(CreateTrainingDatasetRequest createTrainingDatasetRequest)
            throws ConflictException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrainingDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTrainingDatasetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrainingDatasetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrainingDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrainingDataset");

            return clientHandler.execute(new ClientExecutionParams<CreateTrainingDatasetRequest, CreateTrainingDatasetResponse>()
                    .withOperationName("CreateTrainingDataset").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTrainingDatasetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrainingDatasetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     * @return Result of the DeleteAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAudienceGenerationJobResponse deleteAudienceGenerationJob(
            DeleteAudienceGenerationJobRequest deleteAudienceGenerationJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAudienceGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAudienceGenerationJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAudienceGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAudienceGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAudienceGenerationJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAudienceGenerationJobRequest, DeleteAudienceGenerationJobResponse>()
                            .withOperationName("DeleteAudienceGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAudienceGenerationJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAudienceGenerationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     *
     * @param deleteAudienceModelRequest
     * @return Result of the DeleteAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAudienceModelResponse deleteAudienceModel(DeleteAudienceModelRequest deleteAudienceModelRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAudienceModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAudienceModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAudienceModel");

            return clientHandler.execute(new ClientExecutionParams<DeleteAudienceModelRequest, DeleteAudienceModelResponse>()
                    .withOperationName("DeleteAudienceModel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAudienceModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAudienceModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     * @return Result of the DeleteConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfiguredAudienceModelResponse deleteConfiguredAudienceModel(
            DeleteConfiguredAudienceModelRequest deleteConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConfiguredAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConfiguredAudienceModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredAudienceModel");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredAudienceModelRequest, DeleteConfiguredAudienceModelResponse>()
                            .withOperationName("DeleteConfiguredAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteConfiguredAudienceModelRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConfiguredAudienceModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     * @return Result of the DeleteConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfiguredAudienceModelPolicyResponse deleteConfiguredAudienceModelPolicy(
            DeleteConfiguredAudienceModelPolicyRequest deleteConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConfiguredAudienceModelPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConfiguredAudienceModelPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredAudienceModelPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredAudienceModelPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredAudienceModelPolicyRequest, DeleteConfiguredAudienceModelPolicyResponse>()
                            .withOperationName("DeleteConfiguredAudienceModelPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteConfiguredAudienceModelPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConfiguredAudienceModelPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a configured model algorithm.
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmRequest
     * @return Result of the DeleteConfiguredModelAlgorithm operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfiguredModelAlgorithmResponse deleteConfiguredModelAlgorithm(
            DeleteConfiguredModelAlgorithmRequest deleteConfiguredModelAlgorithmRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConfiguredModelAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConfiguredModelAlgorithmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredModelAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredModelAlgorithmRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredModelAlgorithm");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredModelAlgorithmRequest, DeleteConfiguredModelAlgorithmResponse>()
                            .withOperationName("DeleteConfiguredModelAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteConfiguredModelAlgorithmRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConfiguredModelAlgorithmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a configured model algorithm association.
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmAssociationRequest
     * @return Result of the DeleteConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfiguredModelAlgorithmAssociationResponse deleteConfiguredModelAlgorithmAssociation(
            DeleteConfiguredModelAlgorithmAssociationRequest deleteConfiguredModelAlgorithmAssociationRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConfiguredModelAlgorithmAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteConfiguredModelAlgorithmAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteConfiguredModelAlgorithmAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredModelAlgorithmAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredModelAlgorithmAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredModelAlgorithmAssociationRequest, DeleteConfiguredModelAlgorithmAssociationResponse>()
                            .withOperationName("DeleteConfiguredModelAlgorithmAssociation")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteConfiguredModelAlgorithmAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConfiguredModelAlgorithmAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a ML modeling configuration.
     * </p>
     *
     * @param deleteMlConfigurationRequest
     * @return Result of the DeleteMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMlConfigurationResponse deleteMLConfiguration(DeleteMlConfigurationRequest deleteMlConfigurationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMlConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMlConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMlConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMLConfiguration");

            return clientHandler.execute(new ClientExecutionParams<DeleteMlConfigurationRequest, DeleteMlConfigurationResponse>()
                    .withOperationName("DeleteMLConfiguration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteMlConfigurationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMlConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the information necessary to delete an ML input channel.
     * </p>
     *
     * @param deleteMlInputChannelDataRequest
     * @return Result of the DeleteMLInputChannelData operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteMLInputChannelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLInputChannelData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMlInputChannelDataResponse deleteMLInputChannelData(
            DeleteMlInputChannelDataRequest deleteMlInputChannelDataRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMlInputChannelDataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMlInputChannelDataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMlInputChannelDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMlInputChannelDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMLInputChannelData");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMlInputChannelDataRequest, DeleteMlInputChannelDataResponse>()
                            .withOperationName("DeleteMLInputChannelData").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMlInputChannelDataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMlInputChannelDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the output of a trained model.
     * </p>
     *
     * @param deleteTrainedModelOutputRequest
     * @return Result of the DeleteTrainedModelOutput operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteTrainedModelOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainedModelOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrainedModelOutputResponse deleteTrainedModelOutput(
            DeleteTrainedModelOutputRequest deleteTrainedModelOutputRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTrainedModelOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTrainedModelOutputResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrainedModelOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrainedModelOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrainedModelOutput");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTrainedModelOutputRequest, DeleteTrainedModelOutputResponse>()
                            .withOperationName("DeleteTrainedModelOutput").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTrainedModelOutputRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTrainedModelOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     * @return Result of the DeleteTrainingDataset operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrainingDatasetResponse deleteTrainingDataset(DeleteTrainingDatasetRequest deleteTrainingDatasetRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTrainingDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTrainingDatasetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrainingDatasetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrainingDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrainingDataset");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrainingDatasetRequest, DeleteTrainingDatasetResponse>()
                    .withOperationName("DeleteTrainingDataset").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTrainingDatasetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTrainingDatasetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     * @return Result of the GetAudienceGenerationJob operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAudienceGenerationJobResponse getAudienceGenerationJob(
            GetAudienceGenerationJobRequest getAudienceGenerationJobRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAudienceGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAudienceGenerationJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAudienceGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAudienceGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAudienceGenerationJob");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAudienceGenerationJobRequest, GetAudienceGenerationJobResponse>()
                            .withOperationName("GetAudienceGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getAudienceGenerationJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAudienceGenerationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     *
     * @param getAudienceModelRequest
     * @return Result of the GetAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetAudienceModelResponse getAudienceModel(GetAudienceModelRequest getAudienceModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAudienceModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAudienceModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAudienceModel");

            return clientHandler.execute(new ClientExecutionParams<GetAudienceModelRequest, GetAudienceModelResponse>()
                    .withOperationName("GetAudienceModel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAudienceModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAudienceModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the configured model algorithm association in a collaboration.
     * </p>
     *
     * @param getCollaborationConfiguredModelAlgorithmAssociationRequest
     * @return Result of the GetCollaborationConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCollaborationConfiguredModelAlgorithmAssociationResponse getCollaborationConfiguredModelAlgorithmAssociation(
            GetCollaborationConfiguredModelAlgorithmAssociationRequest getCollaborationConfiguredModelAlgorithmAssociationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCollaborationConfiguredModelAlgorithmAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetCollaborationConfiguredModelAlgorithmAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getCollaborationConfiguredModelAlgorithmAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCollaborationConfiguredModelAlgorithmAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationConfiguredModelAlgorithmAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationConfiguredModelAlgorithmAssociationRequest, GetCollaborationConfiguredModelAlgorithmAssociationResponse>()
                            .withOperationName("GetCollaborationConfiguredModelAlgorithmAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(getCollaborationConfiguredModelAlgorithmAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new GetCollaborationConfiguredModelAlgorithmAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific ML input channel in a collaboration.
     * </p>
     *
     * @param getCollaborationMlInputChannelRequest
     * @return Result of the GetCollaborationMLInputChannel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCollaborationMlInputChannelResponse getCollaborationMLInputChannel(
            GetCollaborationMlInputChannelRequest getCollaborationMlInputChannelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCollaborationMlInputChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCollaborationMlInputChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCollaborationMlInputChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCollaborationMlInputChannelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationMLInputChannel");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationMlInputChannelRequest, GetCollaborationMlInputChannelResponse>()
                            .withOperationName("GetCollaborationMLInputChannel").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCollaborationMlInputChannelRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCollaborationMlInputChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a trained model in a collaboration.
     * </p>
     *
     * @param getCollaborationTrainedModelRequest
     * @return Result of the GetCollaborationTrainedModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetCollaborationTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCollaborationTrainedModelResponse getCollaborationTrainedModel(
            GetCollaborationTrainedModelRequest getCollaborationTrainedModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCollaborationTrainedModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCollaborationTrainedModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCollaborationTrainedModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCollaborationTrainedModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationTrainedModel");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationTrainedModelRequest, GetCollaborationTrainedModelResponse>()
                            .withOperationName("GetCollaborationTrainedModel").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCollaborationTrainedModelRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCollaborationTrainedModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     * @return Result of the GetConfiguredAudienceModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConfiguredAudienceModelResponse getConfiguredAudienceModel(
            GetConfiguredAudienceModelRequest getConfiguredAudienceModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConfiguredAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConfiguredAudienceModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConfiguredAudienceModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredAudienceModel");

            return clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredAudienceModelRequest, GetConfiguredAudienceModelResponse>()
                            .withOperationName("GetConfiguredAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getConfiguredAudienceModelRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetConfiguredAudienceModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     * @return Result of the GetConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConfiguredAudienceModelPolicyResponse getConfiguredAudienceModelPolicy(
            GetConfiguredAudienceModelPolicyRequest getConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConfiguredAudienceModelPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConfiguredAudienceModelPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredAudienceModelPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredAudienceModelPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredAudienceModelPolicyRequest, GetConfiguredAudienceModelPolicyResponse>()
                            .withOperationName("GetConfiguredAudienceModelPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getConfiguredAudienceModelPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetConfiguredAudienceModelPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a configured model algorithm.
     * </p>
     *
     * @param getConfiguredModelAlgorithmRequest
     * @return Result of the GetConfiguredModelAlgorithm operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConfiguredModelAlgorithmResponse getConfiguredModelAlgorithm(
            GetConfiguredModelAlgorithmRequest getConfiguredModelAlgorithmRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConfiguredModelAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConfiguredModelAlgorithmResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredModelAlgorithmRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConfiguredModelAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredModelAlgorithm");

            return clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredModelAlgorithmRequest, GetConfiguredModelAlgorithmResponse>()
                            .withOperationName("GetConfiguredModelAlgorithm").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getConfiguredModelAlgorithmRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetConfiguredModelAlgorithmRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a configured model algorithm association.
     * </p>
     *
     * @param getConfiguredModelAlgorithmAssociationRequest
     * @return Result of the GetConfiguredModelAlgorithmAssociation operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConfiguredModelAlgorithmAssociationResponse getConfiguredModelAlgorithmAssociation(
            GetConfiguredModelAlgorithmAssociationRequest getConfiguredModelAlgorithmAssociationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConfiguredModelAlgorithmAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetConfiguredModelAlgorithmAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredModelAlgorithmAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfiguredModelAlgorithmAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredModelAlgorithmAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredModelAlgorithmAssociationRequest, GetConfiguredModelAlgorithmAssociationResponse>()
                            .withOperationName("GetConfiguredModelAlgorithmAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(getConfiguredModelAlgorithmAssociationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetConfiguredModelAlgorithmAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific ML configuration.
     * </p>
     *
     * @param getMlConfigurationRequest
     * @return Result of the GetMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMlConfigurationResponse getMLConfiguration(GetMlConfigurationRequest getMlConfigurationRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMlConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLConfiguration");

            return clientHandler.execute(new ClientExecutionParams<GetMlConfigurationRequest, GetMlConfigurationResponse>()
                    .withOperationName("GetMLConfiguration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getMlConfigurationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMlConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about an ML input channel.
     * </p>
     *
     * @param getMlInputChannelRequest
     * @return Result of the GetMLInputChannel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMlInputChannelResponse getMLInputChannel(GetMlInputChannelRequest getMlInputChannelRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlInputChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMlInputChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMlInputChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlInputChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLInputChannel");

            return clientHandler.execute(new ClientExecutionParams<GetMlInputChannelRequest, GetMlInputChannelResponse>()
                    .withOperationName("GetMLInputChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getMlInputChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMlInputChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a trained model.
     * </p>
     *
     * @param getTrainedModelRequest
     * @return Result of the GetTrainedModel operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetTrainedModelResponse getTrainedModel(GetTrainedModelRequest getTrainedModelRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrainedModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTrainedModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrainedModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrainedModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrainedModel");

            return clientHandler.execute(new ClientExecutionParams<GetTrainedModelRequest, GetTrainedModelResponse>()
                    .withOperationName("GetTrainedModel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTrainedModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTrainedModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a trained model inference job.
     * </p>
     *
     * @param getTrainedModelInferenceJobRequest
     * @return Result of the GetTrainedModelInferenceJob operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTrainedModelInferenceJobResponse getTrainedModelInferenceJob(
            GetTrainedModelInferenceJobRequest getTrainedModelInferenceJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrainedModelInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTrainedModelInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrainedModelInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrainedModelInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrainedModelInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrainedModelInferenceJobRequest, GetTrainedModelInferenceJobResponse>()
                            .withOperationName("GetTrainedModelInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getTrainedModelInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetTrainedModelInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     *
     * @param getTrainingDatasetRequest
     * @return Result of the GetTrainingDataset operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTrainingDatasetResponse getTrainingDataset(GetTrainingDatasetRequest getTrainingDatasetRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrainingDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTrainingDatasetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrainingDatasetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrainingDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrainingDataset");

            return clientHandler.execute(new ClientExecutionParams<GetTrainingDatasetRequest, GetTrainingDatasetResponse>()
                    .withOperationName("GetTrainingDataset").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTrainingDatasetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTrainingDatasetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return Result of the ListAudienceExportJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAudienceExportJobsResponse listAudienceExportJobs(ListAudienceExportJobsRequest listAudienceExportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAudienceExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAudienceExportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAudienceExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAudienceExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAudienceExportJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAudienceExportJobsRequest, ListAudienceExportJobsResponse>()
                            .withOperationName("ListAudienceExportJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAudienceExportJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAudienceExportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return Result of the ListAudienceGenerationJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAudienceGenerationJobsResponse listAudienceGenerationJobs(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAudienceGenerationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAudienceGenerationJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAudienceGenerationJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAudienceGenerationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAudienceGenerationJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAudienceGenerationJobsRequest, ListAudienceGenerationJobsResponse>()
                            .withOperationName("ListAudienceGenerationJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAudienceGenerationJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAudienceGenerationJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return Result of the ListAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAudienceModelsResponse listAudienceModels(ListAudienceModelsRequest listAudienceModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAudienceModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAudienceModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAudienceModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAudienceModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAudienceModels");

            return clientHandler.execute(new ClientExecutionParams<ListAudienceModelsRequest, ListAudienceModelsResponse>()
                    .withOperationName("ListAudienceModels").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAudienceModelsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAudienceModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the configured model algorithm associations in a collaboration.
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     * @return Result of the ListCollaborationConfiguredModelAlgorithmAssociations operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCollaborationConfiguredModelAlgorithmAssociationsResponse listCollaborationConfiguredModelAlgorithmAssociations(
            ListCollaborationConfiguredModelAlgorithmAssociationsRequest listCollaborationConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListCollaborationConfiguredModelAlgorithmAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listCollaborationConfiguredModelAlgorithmAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationConfiguredModelAlgorithmAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "ListCollaborationConfiguredModelAlgorithmAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationConfiguredModelAlgorithmAssociationsRequest, ListCollaborationConfiguredModelAlgorithmAssociationsResponse>()
                            .withOperationName("ListCollaborationConfiguredModelAlgorithmAssociations")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listCollaborationConfiguredModelAlgorithmAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new ListCollaborationConfiguredModelAlgorithmAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the ML input channels in a collaboration.
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     * @return Result of the ListCollaborationMLInputChannels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCollaborationMlInputChannelsResponse listCollaborationMLInputChannels(
            ListCollaborationMlInputChannelsRequest listCollaborationMlInputChannelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCollaborationMlInputChannelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCollaborationMlInputChannelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationMlInputChannelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationMlInputChannelsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationMLInputChannels");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationMlInputChannelsRequest, ListCollaborationMlInputChannelsResponse>()
                            .withOperationName("ListCollaborationMLInputChannels").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCollaborationMlInputChannelsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCollaborationMlInputChannelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the export jobs for a trained model in a collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     * @return Result of the ListCollaborationTrainedModelExportJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCollaborationTrainedModelExportJobsResponse listCollaborationTrainedModelExportJobs(
            ListCollaborationTrainedModelExportJobsRequest listCollaborationTrainedModelExportJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCollaborationTrainedModelExportJobsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListCollaborationTrainedModelExportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationTrainedModelExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationTrainedModelExportJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationTrainedModelExportJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationTrainedModelExportJobsRequest, ListCollaborationTrainedModelExportJobsResponse>()
                            .withOperationName("ListCollaborationTrainedModelExportJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listCollaborationTrainedModelExportJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCollaborationTrainedModelExportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs in a specified collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     * @return Result of the ListCollaborationTrainedModelInferenceJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCollaborationTrainedModelInferenceJobsResponse listCollaborationTrainedModelInferenceJobs(
            ListCollaborationTrainedModelInferenceJobsRequest listCollaborationTrainedModelInferenceJobsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCollaborationTrainedModelInferenceJobsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListCollaborationTrainedModelInferenceJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listCollaborationTrainedModelInferenceJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationTrainedModelInferenceJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationTrainedModelInferenceJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationTrainedModelInferenceJobsRequest, ListCollaborationTrainedModelInferenceJobsResponse>()
                            .withOperationName("ListCollaborationTrainedModelInferenceJobs")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(listCollaborationTrainedModelInferenceJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCollaborationTrainedModelInferenceJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the trained models in a collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     * @return Result of the ListCollaborationTrainedModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCollaborationTrainedModelsResponse listCollaborationTrainedModels(
            ListCollaborationTrainedModelsRequest listCollaborationTrainedModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCollaborationTrainedModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCollaborationTrainedModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationTrainedModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationTrainedModelsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationTrainedModels");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationTrainedModelsRequest, ListCollaborationTrainedModelsResponse>()
                            .withOperationName("ListCollaborationTrainedModels").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCollaborationTrainedModelsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCollaborationTrainedModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return Result of the ListConfiguredAudienceModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConfiguredAudienceModelsResponse listConfiguredAudienceModels(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConfiguredAudienceModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListConfiguredAudienceModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConfiguredAudienceModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConfiguredAudienceModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredAudienceModels");

            return clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredAudienceModelsRequest, ListConfiguredAudienceModelsResponse>()
                            .withOperationName("ListConfiguredAudienceModels").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listConfiguredAudienceModelsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListConfiguredAudienceModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of configured model algorithm associations.
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     * @return Result of the ListConfiguredModelAlgorithmAssociations operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConfiguredModelAlgorithmAssociationsResponse listConfiguredModelAlgorithmAssociations(
            ListConfiguredModelAlgorithmAssociationsRequest listConfiguredModelAlgorithmAssociationsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConfiguredModelAlgorithmAssociationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListConfiguredModelAlgorithmAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listConfiguredModelAlgorithmAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConfiguredModelAlgorithmAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredModelAlgorithmAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredModelAlgorithmAssociationsRequest, ListConfiguredModelAlgorithmAssociationsResponse>()
                            .withOperationName("ListConfiguredModelAlgorithmAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listConfiguredModelAlgorithmAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListConfiguredModelAlgorithmAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of configured model algorithms.
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     * @return Result of the ListConfiguredModelAlgorithms operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConfiguredModelAlgorithmsResponse listConfiguredModelAlgorithms(
            ListConfiguredModelAlgorithmsRequest listConfiguredModelAlgorithmsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConfiguredModelAlgorithmsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListConfiguredModelAlgorithmsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConfiguredModelAlgorithmsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConfiguredModelAlgorithmsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredModelAlgorithms");

            return clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredModelAlgorithmsRequest, ListConfiguredModelAlgorithmsResponse>()
                            .withOperationName("ListConfiguredModelAlgorithms").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listConfiguredModelAlgorithmsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListConfiguredModelAlgorithmsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of ML input channels.
     * </p>
     *
     * @param listMlInputChannelsRequest
     * @return Result of the ListMLInputChannels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMlInputChannelsResponse listMLInputChannels(ListMlInputChannelsRequest listMlInputChannelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMlInputChannelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMlInputChannelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMlInputChannelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlInputChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLInputChannels");

            return clientHandler.execute(new ClientExecutionParams<ListMlInputChannelsRequest, ListMlInputChannelsResponse>()
                    .withOperationName("ListMLInputChannels").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMlInputChannelsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMlInputChannelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs that match the request parameters.
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     * @return Result of the ListTrainedModelInferenceJobs operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrainedModelInferenceJobsResponse listTrainedModelInferenceJobs(
            ListTrainedModelInferenceJobsRequest listTrainedModelInferenceJobsRequest) throws ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrainedModelInferenceJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTrainedModelInferenceJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrainedModelInferenceJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTrainedModelInferenceJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrainedModelInferenceJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrainedModelInferenceJobsRequest, ListTrainedModelInferenceJobsResponse>()
                            .withOperationName("ListTrainedModelInferenceJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTrainedModelInferenceJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTrainedModelInferenceJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of trained models.
     * </p>
     *
     * @param listTrainedModelsRequest
     * @return Result of the ListTrainedModels operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrainedModelsResponse listTrainedModels(ListTrainedModelsRequest listTrainedModelsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrainedModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTrainedModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrainedModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrainedModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrainedModels");

            return clientHandler.execute(new ClientExecutionParams<ListTrainedModelsRequest, ListTrainedModelsResponse>()
                    .withOperationName("ListTrainedModels").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTrainedModelsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTrainedModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return Result of the ListTrainingDatasets operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrainingDatasetsResponse listTrainingDatasets(ListTrainingDatasetsRequest listTrainingDatasetsRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrainingDatasetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTrainingDatasetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrainingDatasetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrainingDatasetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrainingDatasets");

            return clientHandler.execute(new ClientExecutionParams<ListTrainingDatasetsRequest, ListTrainingDatasetsResponse>()
                    .withOperationName("ListTrainingDatasets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTrainingDatasetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTrainingDatasetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     * @return Result of the PutConfiguredAudienceModelPolicy operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutConfiguredAudienceModelPolicyResponse putConfiguredAudienceModelPolicy(
            PutConfiguredAudienceModelPolicyRequest putConfiguredAudienceModelPolicyRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutConfiguredAudienceModelPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutConfiguredAudienceModelPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putConfiguredAudienceModelPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfiguredAudienceModelPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<PutConfiguredAudienceModelPolicyRequest, PutConfiguredAudienceModelPolicyResponse>()
                            .withOperationName("PutConfiguredAudienceModelPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putConfiguredAudienceModelPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutConfiguredAudienceModelPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns information about an ML configuration.
     * </p>
     *
     * @param putMlConfigurationRequest
     * @return Result of the PutMLConfiguration operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.PutMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutMlConfigurationResponse putMLConfiguration(PutMlConfigurationRequest putMlConfigurationRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutMlConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutMlConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMlConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMlConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMLConfiguration");

            return clientHandler.execute(new ClientExecutionParams<PutMlConfigurationRequest, PutMlConfigurationResponse>()
                    .withOperationName("PutMLConfiguration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putMlConfigurationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutMlConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     *
     * @param startAudienceExportJobRequest
     * @return Result of the StartAudienceExportJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartAudienceExportJobResponse startAudienceExportJob(StartAudienceExportJobRequest startAudienceExportJobRequest)
            throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAudienceExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAudienceExportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAudienceExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAudienceExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAudienceExportJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartAudienceExportJobRequest, StartAudienceExportJobResponse>()
                            .withOperationName("StartAudienceExportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startAudienceExportJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartAudienceExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     * @return Result of the StartAudienceGenerationJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartAudienceGenerationJobResponse startAudienceGenerationJob(
            StartAudienceGenerationJobRequest startAudienceGenerationJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAudienceGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAudienceGenerationJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAudienceGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAudienceGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAudienceGenerationJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartAudienceGenerationJobRequest, StartAudienceGenerationJobResponse>()
                            .withOperationName("StartAudienceGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startAudienceGenerationJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartAudienceGenerationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the information necessary to start a trained model export job.
     * </p>
     *
     * @param startTrainedModelExportJobRequest
     * @return Result of the StartTrainedModelExportJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartTrainedModelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartTrainedModelExportJobResponse startTrainedModelExportJob(
            StartTrainedModelExportJobRequest startTrainedModelExportJobRequest) throws ConflictException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartTrainedModelExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartTrainedModelExportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTrainedModelExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTrainedModelExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTrainedModelExportJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartTrainedModelExportJobRequest, StartTrainedModelExportJobResponse>()
                            .withOperationName("StartTrainedModelExportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startTrainedModelExportJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartTrainedModelExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines the information necessary to begin a trained model inference job.
     * </p>
     *
     * @param startTrainedModelInferenceJobRequest
     * @return Result of the StartTrainedModelInferenceJob operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.StartTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartTrainedModelInferenceJobResponse startTrainedModelInferenceJob(
            StartTrainedModelInferenceJobRequest startTrainedModelInferenceJobRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartTrainedModelInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartTrainedModelInferenceJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTrainedModelInferenceJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startTrainedModelInferenceJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTrainedModelInferenceJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartTrainedModelInferenceJobRequest, StartTrainedModelInferenceJobResponse>()
                            .withOperationName("StartTrainedModelInferenceJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startTrainedModelInferenceJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartTrainedModelInferenceJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     * @return Result of the UpdateConfiguredAudienceModel operation returned by the service.
     * @throws ConflictException
     *         You can't complete this action because another resource depends on this resource.
     * @throws ValidationException
     *         The request parameters for this request are incorrect.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The resource you are requesting does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsMlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsMlClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConfiguredAudienceModelResponse updateConfiguredAudienceModel(
            UpdateConfiguredAudienceModelRequest updateConfiguredAudienceModelRequest) throws ConflictException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConfiguredAudienceModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConfiguredAudienceModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConfiguredAudienceModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfiguredAudienceModel");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateConfiguredAudienceModelRequest, UpdateConfiguredAudienceModelResponse>()
                            .withOperationName("UpdateConfiguredAudienceModel").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateConfiguredAudienceModelRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateConfiguredAudienceModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CleanRoomsMlServiceClientConfigurationBuilder serviceConfigBuilder = new CleanRoomsMlServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CleanRoomsMlException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    @Override
    public final CleanRoomsMlServiceClientConfiguration serviceClientConfiguration() {
        return new CleanRoomsMlServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
