/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the audience export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudienceExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AudienceExportJobSummary.Builder, AudienceExportJobSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(AudienceExportJobSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(AudienceExportJobSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AudienceExportJobSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> AUDIENCE_GENERATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceGenerationJobArn").getter(getter(AudienceExportJobSummary::audienceGenerationJobArn))
            .setter(setter(Builder::audienceGenerationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobArn").build())
            .build();

    private static final SdkField<AudienceSize> AUDIENCE_SIZE_FIELD = SdkField.<AudienceSize> builder(MarshallingType.SDK_POJO)
            .memberName("audienceSize").getter(getter(AudienceExportJobSummary::audienceSize))
            .setter(setter(Builder::audienceSize)).constructor(AudienceSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSize").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AudienceExportJobSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AudienceExportJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField
            .<StatusDetails> builder(MarshallingType.SDK_POJO).memberName("statusDetails")
            .getter(getter(AudienceExportJobSummary::statusDetails)).setter(setter(Builder::statusDetails))
            .constructor(StatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputLocation").getter(getter(AudienceExportJobSummary::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, NAME_FIELD, AUDIENCE_GENERATION_JOB_ARN_FIELD, AUDIENCE_SIZE_FIELD, DESCRIPTION_FIELD,
            STATUS_FIELD, STATUS_DETAILS_FIELD, OUTPUT_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createTime;

    private final Instant updateTime;

    private final String name;

    private final String audienceGenerationJobArn;

    private final AudienceSize audienceSize;

    private final String description;

    private final String status;

    private final StatusDetails statusDetails;

    private final String outputLocation;

    private AudienceExportJobSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.name = builder.name;
        this.audienceGenerationJobArn = builder.audienceGenerationJobArn;
        this.audienceSize = builder.audienceSize;
        this.description = builder.description;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.outputLocation = builder.outputLocation;
    }

    /**
     * <p>
     * The time at which the audience export job was created.
     * </p>
     * 
     * @return The time at which the audience export job was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the audience export job was updated.
     * </p>
     * 
     * @return The most recent time at which the audience export job was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The name of the audience export job.
     * </p>
     * 
     * @return The name of the audience export job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the audience generation job that was exported.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the audience generation job that was exported.
     */
    public final String audienceGenerationJobArn() {
        return audienceGenerationJobArn;
    }

    /**
     * Returns the value of the AudienceSize property for this object.
     * 
     * @return The value of the AudienceSize property for this object.
     */
    public final AudienceSize audienceSize() {
        return audienceSize;
    }

    /**
     * <p>
     * The description of the audience export job.
     * </p>
     * 
     * @return The description of the audience export job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the audience export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AudienceExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the audience export job.
     * @see AudienceExportJobStatus
     */
    public final AudienceExportJobStatus status() {
        return AudienceExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the audience export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AudienceExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the audience export job.
     * @see AudienceExportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the StatusDetails property for this object.
     * 
     * @return The value of the StatusDetails property for this object.
     */
    public final StatusDetails statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the audience export is stored.
     * </p>
     * 
     * @return The Amazon S3 bucket where the audience export is stored.
     */
    public final String outputLocation() {
        return outputLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(audienceGenerationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(audienceSize());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceExportJobSummary)) {
            return false;
        }
        AudienceExportJobSummary other = (AudienceExportJobSummary) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(name(), other.name())
                && Objects.equals(audienceGenerationJobArn(), other.audienceGenerationJobArn())
                && Objects.equals(audienceSize(), other.audienceSize()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(outputLocation(), other.outputLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudienceExportJobSummary").add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("Name", name()).add("AudienceGenerationJobArn", audienceGenerationJobArn())
                .add("AudienceSize", audienceSize()).add("Description", description()).add("Status", statusAsString())
                .add("StatusDetails", statusDetails()).add("OutputLocation", outputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "audienceGenerationJobArn":
            return Optional.ofNullable(clazz.cast(audienceGenerationJobArn()));
        case "audienceSize":
            return Optional.ofNullable(clazz.cast(audienceSize()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("audienceGenerationJobArn", AUDIENCE_GENERATION_JOB_ARN_FIELD);
        map.put("audienceSize", AUDIENCE_SIZE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("outputLocation", OUTPUT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudienceExportJobSummary, T> g) {
        return obj -> g.apply((AudienceExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudienceExportJobSummary> {
        /**
         * <p>
         * The time at which the audience export job was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the audience export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the audience export job was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the audience export job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The name of the audience export job.
         * </p>
         * 
         * @param name
         *        The name of the audience export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the audience generation job that was exported.
         * </p>
         * 
         * @param audienceGenerationJobArn
         *        The Amazon Resource Name (ARN) of the audience generation job that was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceGenerationJobArn(String audienceGenerationJobArn);

        /**
         * Sets the value of the AudienceSize property for this object.
         *
         * @param audienceSize
         *        The new value for the AudienceSize property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceSize(AudienceSize audienceSize);

        /**
         * Sets the value of the AudienceSize property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AudienceSize.Builder} avoiding the need
         * to create one manually via {@link AudienceSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceSize.Builder#build()} is called immediately and its
         * result is passed to {@link #audienceSize(AudienceSize)}.
         * 
         * @param audienceSize
         *        a consumer that will call methods on {@link AudienceSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceSize(AudienceSize)
         */
        default Builder audienceSize(Consumer<AudienceSize.Builder> audienceSize) {
            return audienceSize(AudienceSize.builder().applyMutation(audienceSize).build());
        }

        /**
         * <p>
         * The description of the audience export job.
         * </p>
         * 
         * @param description
         *        The description of the audience export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the audience export job.
         * </p>
         * 
         * @param status
         *        The status of the audience export job.
         * @see AudienceExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the audience export job.
         * </p>
         * 
         * @param status
         *        The status of the audience export job.
         * @see AudienceExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceExportJobStatus
         */
        Builder status(AudienceExportJobStatus status);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * @param statusDetails
         *        The new value for the StatusDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(StatusDetails statusDetails);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StatusDetails.Builder} avoiding the need
         * to create one manually via {@link StatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #statusDetails(StatusDetails)}.
         * 
         * @param statusDetails
         *        a consumer that will call methods on {@link StatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusDetails(StatusDetails)
         */
        default Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return statusDetails(StatusDetails.builder().applyMutation(statusDetails).build());
        }

        /**
         * <p>
         * The Amazon S3 bucket where the audience export is stored.
         * </p>
         * 
         * @param outputLocation
         *        The Amazon S3 bucket where the audience export is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String name;

        private String audienceGenerationJobArn;

        private AudienceSize audienceSize;

        private String description;

        private String status;

        private StatusDetails statusDetails;

        private String outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceExportJobSummary model) {
            createTime(model.createTime);
            updateTime(model.updateTime);
            name(model.name);
            audienceGenerationJobArn(model.audienceGenerationJobArn);
            audienceSize(model.audienceSize);
            description(model.description);
            status(model.status);
            statusDetails(model.statusDetails);
            outputLocation(model.outputLocation);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAudienceGenerationJobArn() {
            return audienceGenerationJobArn;
        }

        public final void setAudienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
        }

        @Override
        public final Builder audienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
            return this;
        }

        public final AudienceSize.Builder getAudienceSize() {
            return audienceSize != null ? audienceSize.toBuilder() : null;
        }

        public final void setAudienceSize(AudienceSize.BuilderImpl audienceSize) {
            this.audienceSize = audienceSize != null ? audienceSize.build() : null;
        }

        @Override
        public final Builder audienceSize(AudienceSize audienceSize) {
            this.audienceSize = audienceSize;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AudienceExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return statusDetails != null ? statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        @Override
        public AudienceExportJobSummary build() {
            return new AudienceExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
