/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for the instances that will perform the compute work.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeConfiguration.Builder, ComputeConfiguration> {
    private static final SdkField<WorkerComputeConfiguration> WORKER_FIELD = SdkField
            .<WorkerComputeConfiguration> builder(MarshallingType.SDK_POJO).memberName("worker")
            .getter(getter(ComputeConfiguration::worker)).setter(setter(Builder::worker))
            .constructor(WorkerComputeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WorkerComputeConfiguration worker;

    private final Type type;

    private ComputeConfiguration(BuilderImpl builder) {
        this.worker = builder.worker;
        this.type = builder.type;
    }

    /**
     * <p>
     * The worker instances that will perform the compute work.
     * </p>
     * 
     * @return The worker instances that will perform the compute work.
     */
    public final WorkerComputeConfiguration worker() {
        return worker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(worker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeConfiguration)) {
            return false;
        }
        ComputeConfiguration other = (ComputeConfiguration) obj;
        return Objects.equals(worker(), other.worker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeConfiguration").add("Worker", worker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "worker":
            return Optional.ofNullable(clazz.cast(worker()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #worker()} initialized to the given value.
     *
     * <p>
     * The worker instances that will perform the compute work.
     * </p>
     * 
     * @param worker
     *        The worker instances that will perform the compute work.
     */
    public static ComputeConfiguration fromWorker(WorkerComputeConfiguration worker) {
        return builder().worker(worker).build();
    }

    /**
     * Create an instance of this class with {@link #worker()} initialized to the given value.
     *
     * <p>
     * The worker instances that will perform the compute work.
     * </p>
     * 
     * @param worker
     *        The worker instances that will perform the compute work.
     */
    public static ComputeConfiguration fromWorker(Consumer<WorkerComputeConfiguration.Builder> worker) {
        WorkerComputeConfiguration.Builder builder = WorkerComputeConfiguration.builder();
        worker.accept(builder);
        return fromWorker(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("worker", WORKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeConfiguration, T> g) {
        return obj -> g.apply((ComputeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeConfiguration> {
        /**
         * <p>
         * The worker instances that will perform the compute work.
         * </p>
         * 
         * @param worker
         *        The worker instances that will perform the compute work.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worker(WorkerComputeConfiguration worker);

        /**
         * <p>
         * The worker instances that will perform the compute work.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkerComputeConfiguration.Builder}
         * avoiding the need to create one manually via {@link WorkerComputeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkerComputeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #worker(WorkerComputeConfiguration)}.
         * 
         * @param worker
         *        a consumer that will call methods on {@link WorkerComputeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #worker(WorkerComputeConfiguration)
         */
        default Builder worker(Consumer<WorkerComputeConfiguration.Builder> worker) {
            return worker(WorkerComputeConfiguration.builder().applyMutation(worker).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WorkerComputeConfiguration worker;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeConfiguration model) {
            worker(model.worker);
        }

        public final WorkerComputeConfiguration.Builder getWorker() {
            return worker != null ? worker.toBuilder() : null;
        }

        public final void setWorker(WorkerComputeConfiguration.BuilderImpl worker) {
            Object oldValue = this.worker;
            this.worker = worker != null ? worker.build() : null;
            handleUnionValueChange(Type.WORKER, oldValue, this.worker);
        }

        @Override
        public final Builder worker(WorkerComputeConfiguration worker) {
            Object oldValue = this.worker;
            this.worker = worker;
            handleUnionValueChange(Type.WORKER, oldValue, this.worker);
            return this;
        }

        @Override
        public ComputeConfiguration build() {
            return new ComputeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ComputeConfiguration#type()
     */
    public enum Type {
        WORKER,

        UNKNOWN_TO_SDK_VERSION
    }
}
