/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrainedModelResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<CreateTrainedModelResponse.Builder, CreateTrainedModelResponse> {
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(CreateTrainedModelResponse::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODEL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trainedModelArn;

    private CreateTrainedModelResponse(BuilderImpl builder) {
        super(builder);
        this.trainedModelArn = builder.trainedModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainedModelResponse)) {
            return false;
        }
        CreateTrainedModelResponse other = (CreateTrainedModelResponse) obj;
        return Objects.equals(trainedModelArn(), other.trainedModelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrainedModelResponse").add("TrainedModelArn", trainedModelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainedModelResponse, T> g) {
        return obj -> g.apply((CreateTrainedModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrainedModelResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String trainedModelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainedModelResponse model) {
            super(model);
            trainedModelArn(model.trainedModelArn);
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        @Override
        public CreateTrainedModelResponse build() {
            return new CreateTrainedModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
