/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMlInputChannelDataRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<DeleteMlInputChannelDataRequest.Builder, DeleteMlInputChannelDataRequest> {
    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mlInputChannelArn").getter(getter(DeleteMlInputChannelDataRequest::mlInputChannelArn))
            .setter(setter(Builder::mlInputChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("mlInputChannelArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(DeleteMlInputChannelDataRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_INPUT_CHANNEL_ARN_FIELD,
            MEMBERSHIP_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mlInputChannelArn;

    private final String membershipIdentifier;

    private DeleteMlInputChannelDataRequest(BuilderImpl builder) {
        super(builder);
        this.mlInputChannelArn = builder.mlInputChannelArn;
        this.membershipIdentifier = builder.membershipIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ML input channel that you want to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ML input channel that you want to delete.
     */
    public final String mlInputChannelArn() {
        return mlInputChannelArn;
    }

    /**
     * <p>
     * The membership ID of the membership that contains the ML input channel you want to delete.
     * </p>
     * 
     * @return The membership ID of the membership that contains the ML input channel you want to delete.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mlInputChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMlInputChannelDataRequest)) {
            return false;
        }
        DeleteMlInputChannelDataRequest other = (DeleteMlInputChannelDataRequest) obj;
        return Objects.equals(mlInputChannelArn(), other.mlInputChannelArn())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMlInputChannelDataRequest").add("MlInputChannelArn", mlInputChannelArn())
                .add("MembershipIdentifier", membershipIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mlInputChannelArn":
            return Optional.ofNullable(clazz.cast(mlInputChannelArn()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteMlInputChannelDataRequest, T> g) {
        return obj -> g.apply((DeleteMlInputChannelDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteMlInputChannelDataRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ML input channel that you want to delete.
         * </p>
         * 
         * @param mlInputChannelArn
         *        The Amazon Resource Name (ARN) of the ML input channel that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlInputChannelArn(String mlInputChannelArn);

        /**
         * <p>
         * The membership ID of the membership that contains the ML input channel you want to delete.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the membership that contains the ML input channel you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String mlInputChannelArn;

        private String membershipIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMlInputChannelDataRequest model) {
            super(model);
            mlInputChannelArn(model.mlInputChannelArn);
            membershipIdentifier(model.membershipIdentifier);
        }

        public final String getMlInputChannelArn() {
            return mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMlInputChannelDataRequest build() {
            return new DeleteMlInputChannelDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
