/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTrainingDatasetRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<DeleteTrainingDatasetRequest.Builder, DeleteTrainingDatasetRequest> {
    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDatasetArn").getter(getter(DeleteTrainingDatasetRequest::trainingDatasetArn))
            .setter(setter(Builder::trainingDatasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("trainingDatasetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_DATASET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trainingDatasetArn;

    private DeleteTrainingDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.trainingDatasetArn = builder.trainingDatasetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training dataset that you want to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training dataset that you want to delete.
     */
    public final String trainingDatasetArn() {
        return trainingDatasetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingDatasetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrainingDatasetRequest)) {
            return false;
        }
        DeleteTrainingDatasetRequest other = (DeleteTrainingDatasetRequest) obj;
        return Objects.equals(trainingDatasetArn(), other.trainingDatasetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTrainingDatasetRequest").add("TrainingDatasetArn", trainingDatasetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trainingDatasetArn":
            return Optional.ofNullable(clazz.cast(trainingDatasetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trainingDatasetArn", TRAINING_DATASET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTrainingDatasetRequest, T> g) {
        return obj -> g.apply((DeleteTrainingDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTrainingDatasetRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training dataset that you want to delete.
         * </p>
         * 
         * @param trainingDatasetArn
         *        The Amazon Resource Name (ARN) of the training dataset that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDatasetArn(String trainingDatasetArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String trainingDatasetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrainingDatasetRequest model) {
            super(model);
            trainingDatasetArn(model.trainingDatasetArn);
        }

        public final String getTrainingDatasetArn() {
            return trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTrainingDatasetRequest build() {
            return new DeleteTrainingDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
