/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationConfiguredModelAlgorithmAssociationResponse extends CleanRoomsMlResponse
        implements
        ToCopyableBuilder<GetCollaborationConfiguredModelAlgorithmAssociationResponse.Builder, GetCollaborationConfiguredModelAlgorithmAssociationResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmArn")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::configuredModelAlgorithmArn))
            .setter(setter(Builder::configuredModelAlgorithmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmArn")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorAccountId")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()).build();

    private static final SdkField<PrivacyConfiguration> PRIVACY_CONFIGURATION_FIELD = SdkField
            .<PrivacyConfiguration> builder(MarshallingType.SDK_POJO).memberName("privacyConfiguration")
            .getter(getter(GetCollaborationConfiguredModelAlgorithmAssociationResponse::privacyConfiguration))
            .setter(setter(Builder::privacyConfiguration)).constructor(PrivacyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, MEMBERSHIP_IDENTIFIER_FIELD,
            COLLABORATION_IDENTIFIER_FIELD, CONFIGURED_MODEL_ALGORITHM_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD,
            CREATOR_ACCOUNT_ID_FIELD, PRIVACY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createTime;

    private final Instant updateTime;

    private final String configuredModelAlgorithmAssociationArn;

    private final String membershipIdentifier;

    private final String collaborationIdentifier;

    private final String configuredModelAlgorithmArn;

    private final String name;

    private final String description;

    private final String creatorAccountId;

    private final PrivacyConfiguration privacyConfiguration;

    private GetCollaborationConfiguredModelAlgorithmAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.configuredModelAlgorithmArn = builder.configuredModelAlgorithmArn;
        this.name = builder.name;
        this.description = builder.description;
        this.creatorAccountId = builder.creatorAccountId;
        this.privacyConfiguration = builder.privacyConfiguration;
    }

    /**
     * <p>
     * The time at which the configured model algorithm association was created.
     * </p>
     * 
     * @return The time at which the configured model algorithm association was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the configured model algorithm association was updated.
     * </p>
     * 
     * @return The most recent time at which the configured model algorithm association was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    /**
     * <p>
     * The membership ID of the member that created the configured model algorithm association.
     * </p>
     * 
     * @return The membership ID of the member that created the configured model algorithm association.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The collaboration ID of the collaboration that contains the configured model algorithm association.
     * </p>
     * 
     * @return The collaboration ID of the collaboration that contains the configured model algorithm association.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association.
     */
    public final String configuredModelAlgorithmArn() {
        return configuredModelAlgorithmArn;
    }

    /**
     * <p>
     * The name of the configured model algorithm association.
     * </p>
     * 
     * @return The name of the configured model algorithm association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the configured model algorithm association.
     * </p>
     * 
     * @return The description of the configured model algorithm association.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The account ID of the member that created the configured model algorithm association.
     * </p>
     * 
     * @return The account ID of the member that created the configured model algorithm association.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    /**
     * Returns the value of the PrivacyConfiguration property for this object.
     * 
     * @return The value of the PrivacyConfiguration property for this object.
     */
    public final PrivacyConfiguration privacyConfiguration() {
        return privacyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(privacyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationConfiguredModelAlgorithmAssociationResponse)) {
            return false;
        }
        GetCollaborationConfiguredModelAlgorithmAssociationResponse other = (GetCollaborationConfiguredModelAlgorithmAssociationResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(configuredModelAlgorithmArn(), other.configuredModelAlgorithmArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(creatorAccountId(), other.creatorAccountId())
                && Objects.equals(privacyConfiguration(), other.privacyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationConfiguredModelAlgorithmAssociationResponse").add("CreateTime", createTime())
                .add("UpdateTime", updateTime())
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn())
                .add("MembershipIdentifier", membershipIdentifier()).add("CollaborationIdentifier", collaborationIdentifier())
                .add("ConfiguredModelAlgorithmArn", configuredModelAlgorithmArn()).add("Name", name())
                .add("Description", description()).add("CreatorAccountId", creatorAccountId())
                .add("PrivacyConfiguration", privacyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "configuredModelAlgorithmArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        case "privacyConfiguration":
            return Optional.ofNullable(clazz.cast(privacyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("configuredModelAlgorithmArn", CONFIGURED_MODEL_ALGORITHM_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("privacyConfiguration", PRIVACY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationConfiguredModelAlgorithmAssociationResponse, T> g) {
        return obj -> g.apply((GetCollaborationConfiguredModelAlgorithmAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationConfiguredModelAlgorithmAssociationResponse> {
        /**
         * <p>
         * The time at which the configured model algorithm association was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the configured model algorithm association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the configured model algorithm association was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the configured model algorithm association was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);

        /**
         * <p>
         * The membership ID of the member that created the configured model algorithm association.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that created the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The collaboration ID of the collaboration that contains the configured model algorithm association.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The collaboration ID of the collaboration that contains the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association.
         * </p>
         * 
         * @param configuredModelAlgorithmArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmArn(String configuredModelAlgorithmArn);

        /**
         * <p>
         * The name of the configured model algorithm association.
         * </p>
         * 
         * @param name
         *        The name of the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the configured model algorithm association.
         * </p>
         * 
         * @param description
         *        The description of the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The account ID of the member that created the configured model algorithm association.
         * </p>
         * 
         * @param creatorAccountId
         *        The account ID of the member that created the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);

        /**
         * Sets the value of the PrivacyConfiguration property for this object.
         *
         * @param privacyConfiguration
         *        The new value for the PrivacyConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyConfiguration(PrivacyConfiguration privacyConfiguration);

        /**
         * Sets the value of the PrivacyConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PrivacyConfiguration.Builder} avoiding
         * the need to create one manually via {@link PrivacyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #privacyConfiguration(PrivacyConfiguration)}.
         * 
         * @param privacyConfiguration
         *        a consumer that will call methods on {@link PrivacyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privacyConfiguration(PrivacyConfiguration)
         */
        default Builder privacyConfiguration(Consumer<PrivacyConfiguration.Builder> privacyConfiguration) {
            return privacyConfiguration(PrivacyConfiguration.builder().applyMutation(privacyConfiguration).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String configuredModelAlgorithmAssociationArn;

        private String membershipIdentifier;

        private String collaborationIdentifier;

        private String configuredModelAlgorithmArn;

        private String name;

        private String description;

        private String creatorAccountId;

        private PrivacyConfiguration privacyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationConfiguredModelAlgorithmAssociationResponse model) {
            super(model);
            createTime(model.createTime);
            updateTime(model.updateTime);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            membershipIdentifier(model.membershipIdentifier);
            collaborationIdentifier(model.collaborationIdentifier);
            configuredModelAlgorithmArn(model.configuredModelAlgorithmArn);
            name(model.name);
            description(model.description);
            creatorAccountId(model.creatorAccountId);
            privacyConfiguration(model.privacyConfiguration);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getConfiguredModelAlgorithmArn() {
            return configuredModelAlgorithmArn;
        }

        public final void setConfiguredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
        }

        @Override
        public final Builder configuredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final PrivacyConfiguration.Builder getPrivacyConfiguration() {
            return privacyConfiguration != null ? privacyConfiguration.toBuilder() : null;
        }

        public final void setPrivacyConfiguration(PrivacyConfiguration.BuilderImpl privacyConfiguration) {
            this.privacyConfiguration = privacyConfiguration != null ? privacyConfiguration.build() : null;
        }

        @Override
        public final Builder privacyConfiguration(PrivacyConfiguration privacyConfiguration) {
            this.privacyConfiguration = privacyConfiguration;
            return this;
        }

        @Override
        public GetCollaborationConfiguredModelAlgorithmAssociationResponse build() {
            return new GetCollaborationConfiguredModelAlgorithmAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
