/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfiguredModelAlgorithmAssociationResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetConfiguredModelAlgorithmAssociationResponse.Builder, GetConfiguredModelAlgorithmAssociationResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmArn")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::configuredModelAlgorithmArn))
            .setter(setter(Builder::configuredModelAlgorithmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmArn")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PrivacyConfiguration> PRIVACY_CONFIGURATION_FIELD = SdkField
            .<PrivacyConfiguration> builder(MarshallingType.SDK_POJO).memberName("privacyConfiguration")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::privacyConfiguration))
            .setter(setter(Builder::privacyConfiguration)).constructor(PrivacyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetConfiguredModelAlgorithmAssociationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetConfiguredModelAlgorithmAssociationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, MEMBERSHIP_IDENTIFIER_FIELD,
            COLLABORATION_IDENTIFIER_FIELD, CONFIGURED_MODEL_ALGORITHM_ARN_FIELD, NAME_FIELD, PRIVACY_CONFIGURATION_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createTime;

    private final Instant updateTime;

    private final String configuredModelAlgorithmAssociationArn;

    private final String membershipIdentifier;

    private final String collaborationIdentifier;

    private final String configuredModelAlgorithmArn;

    private final String name;

    private final PrivacyConfiguration privacyConfiguration;

    private final String description;

    private final Map<String, String> tags;

    private GetConfiguredModelAlgorithmAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.configuredModelAlgorithmArn = builder.configuredModelAlgorithmArn;
        this.name = builder.name;
        this.privacyConfiguration = builder.privacyConfiguration;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The time at which the configured model algorithm association was created.
     * </p>
     * 
     * @return The time at which the configured model algorithm association was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the configured model algorithm association was updated.
     * </p>
     * 
     * @return The most recent time at which the configured model algorithm association was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    /**
     * <p>
     * The membership ID of the member that created the configured model algorithm association.
     * </p>
     * 
     * @return The membership ID of the member that created the configured model algorithm association.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The collaboration ID of the collaboration that contains the configured model algorithm association.
     * </p>
     * 
     * @return The collaboration ID of the collaboration that contains the configured model algorithm association.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm that was associated to the collaboration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm that was associated to the
     *         collaboration.
     */
    public final String configuredModelAlgorithmArn() {
        return configuredModelAlgorithmArn;
    }

    /**
     * <p>
     * The name of the configured model algorithm association.
     * </p>
     * 
     * @return The name of the configured model algorithm association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The privacy configuration information for the configured model algorithm association.
     * </p>
     * 
     * @return The privacy configuration information for the configured model algorithm association.
     */
    public final PrivacyConfiguration privacyConfiguration() {
        return privacyConfiguration;
    }

    /**
     * <p>
     * The description of the configured model algorithm association.
     * </p>
     * 
     * @return The description of the configured model algorithm association.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
     * consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the
     * limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user
     *         tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(privacyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredModelAlgorithmAssociationResponse)) {
            return false;
        }
        GetConfiguredModelAlgorithmAssociationResponse other = (GetConfiguredModelAlgorithmAssociationResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(configuredModelAlgorithmArn(), other.configuredModelAlgorithmArn())
                && Objects.equals(name(), other.name()) && Objects.equals(privacyConfiguration(), other.privacyConfiguration())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfiguredModelAlgorithmAssociationResponse").add("CreateTime", createTime())
                .add("UpdateTime", updateTime())
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn())
                .add("MembershipIdentifier", membershipIdentifier()).add("CollaborationIdentifier", collaborationIdentifier())
                .add("ConfiguredModelAlgorithmArn", configuredModelAlgorithmArn()).add("Name", name())
                .add("PrivacyConfiguration", privacyConfiguration()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "configuredModelAlgorithmArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "privacyConfiguration":
            return Optional.ofNullable(clazz.cast(privacyConfiguration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("configuredModelAlgorithmArn", CONFIGURED_MODEL_ALGORITHM_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("privacyConfiguration", PRIVACY_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredModelAlgorithmAssociationResponse, T> g) {
        return obj -> g.apply((GetConfiguredModelAlgorithmAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfiguredModelAlgorithmAssociationResponse> {
        /**
         * <p>
         * The time at which the configured model algorithm association was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the configured model algorithm association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the configured model algorithm association was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the configured model algorithm association was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);

        /**
         * <p>
         * The membership ID of the member that created the configured model algorithm association.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that created the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The collaboration ID of the collaboration that contains the configured model algorithm association.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The collaboration ID of the collaboration that contains the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm that was associated to the collaboration.
         * </p>
         * 
         * @param configuredModelAlgorithmArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm that was associated to the
         *        collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmArn(String configuredModelAlgorithmArn);

        /**
         * <p>
         * The name of the configured model algorithm association.
         * </p>
         * 
         * @param name
         *        The name of the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The privacy configuration information for the configured model algorithm association.
         * </p>
         * 
         * @param privacyConfiguration
         *        The privacy configuration information for the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyConfiguration(PrivacyConfiguration privacyConfiguration);

        /**
         * <p>
         * The privacy configuration information for the configured model algorithm association.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivacyConfiguration.Builder} avoiding
         * the need to create one manually via {@link PrivacyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #privacyConfiguration(PrivacyConfiguration)}.
         * 
         * @param privacyConfiguration
         *        a consumer that will call methods on {@link PrivacyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privacyConfiguration(PrivacyConfiguration)
         */
        default Builder privacyConfiguration(Consumer<PrivacyConfiguration.Builder> privacyConfiguration) {
            return privacyConfiguration(PrivacyConfiguration.builder().applyMutation(privacyConfiguration).build());
        }

        /**
         * <p>
         * The description of the configured model algorithm association.
         * </p>
         * 
         * @param description
         *        The description of the configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you applied to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to
         *        be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String configuredModelAlgorithmAssociationArn;

        private String membershipIdentifier;

        private String collaborationIdentifier;

        private String configuredModelAlgorithmArn;

        private String name;

        private PrivacyConfiguration privacyConfiguration;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredModelAlgorithmAssociationResponse model) {
            super(model);
            createTime(model.createTime);
            updateTime(model.updateTime);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            membershipIdentifier(model.membershipIdentifier);
            collaborationIdentifier(model.collaborationIdentifier);
            configuredModelAlgorithmArn(model.configuredModelAlgorithmArn);
            name(model.name);
            privacyConfiguration(model.privacyConfiguration);
            description(model.description);
            tags(model.tags);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getConfiguredModelAlgorithmArn() {
            return configuredModelAlgorithmArn;
        }

        public final void setConfiguredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
        }

        @Override
        public final Builder configuredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PrivacyConfiguration.Builder getPrivacyConfiguration() {
            return privacyConfiguration != null ? privacyConfiguration.toBuilder() : null;
        }

        public final void setPrivacyConfiguration(PrivacyConfiguration.BuilderImpl privacyConfiguration) {
            this.privacyConfiguration = privacyConfiguration != null ? privacyConfiguration.build() : null;
        }

        @Override
        public final Builder privacyConfiguration(PrivacyConfiguration privacyConfiguration) {
            this.privacyConfiguration = privacyConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetConfiguredModelAlgorithmAssociationResponse build() {
            return new GetConfiguredModelAlgorithmAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
