/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlConfigurationResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetMlConfigurationResponse.Builder, GetMlConfigurationResponse> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(GetMlConfigurationResponse::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<MLOutputConfiguration> DEFAULT_OUTPUT_LOCATION_FIELD = SdkField
            .<MLOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("defaultOutputLocation")
            .getter(getter(GetMlConfigurationResponse::defaultOutputLocation)).setter(setter(Builder::defaultOutputLocation))
            .constructor(MLOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultOutputLocation").build())
            .build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetMlConfigurationResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetMlConfigurationResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            DEFAULT_OUTPUT_LOCATION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final MLOutputConfiguration defaultOutputLocation;

    private final Instant createTime;

    private final Instant updateTime;

    private GetMlConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.defaultOutputLocation = builder.defaultOutputLocation;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The membership ID of the member that owns the ML configuration you requested.
     * </p>
     * 
     * @return The membership ID of the member that owns the ML configuration you requested.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The Amazon S3 location where ML model output is stored.
     * </p>
     * 
     * @return The Amazon S3 location where ML model output is stored.
     */
    public final MLOutputConfiguration defaultOutputLocation() {
        return defaultOutputLocation;
    }

    /**
     * <p>
     * The time at which the ML configuration was created.
     * </p>
     * 
     * @return The time at which the ML configuration was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the ML configuration was updated.
     * </p>
     * 
     * @return The most recent time at which the ML configuration was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlConfigurationResponse)) {
            return false;
        }
        GetMlConfigurationResponse other = (GetMlConfigurationResponse) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(defaultOutputLocation(), other.defaultOutputLocation())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlConfigurationResponse").add("MembershipIdentifier", membershipIdentifier())
                .add("DefaultOutputLocation", defaultOutputLocation()).add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "defaultOutputLocation":
            return Optional.ofNullable(clazz.cast(defaultOutputLocation()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("defaultOutputLocation", DEFAULT_OUTPUT_LOCATION_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMlConfigurationResponse, T> g) {
        return obj -> g.apply((GetMlConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMlConfigurationResponse> {
        /**
         * <p>
         * The membership ID of the member that owns the ML configuration you requested.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that owns the ML configuration you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The Amazon S3 location where ML model output is stored.
         * </p>
         * 
         * @param defaultOutputLocation
         *        The Amazon S3 location where ML model output is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOutputLocation(MLOutputConfiguration defaultOutputLocation);

        /**
         * <p>
         * The Amazon S3 location where ML model output is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link MLOutputConfiguration.Builder} avoiding
         * the need to create one manually via {@link MLOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MLOutputConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultOutputLocation(MLOutputConfiguration)}.
         * 
         * @param defaultOutputLocation
         *        a consumer that will call methods on {@link MLOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultOutputLocation(MLOutputConfiguration)
         */
        default Builder defaultOutputLocation(Consumer<MLOutputConfiguration.Builder> defaultOutputLocation) {
            return defaultOutputLocation(MLOutputConfiguration.builder().applyMutation(defaultOutputLocation).build());
        }

        /**
         * <p>
         * The time at which the ML configuration was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the ML configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the ML configuration was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the ML configuration was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private MLOutputConfiguration defaultOutputLocation;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlConfigurationResponse model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            defaultOutputLocation(model.defaultOutputLocation);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final MLOutputConfiguration.Builder getDefaultOutputLocation() {
            return defaultOutputLocation != null ? defaultOutputLocation.toBuilder() : null;
        }

        public final void setDefaultOutputLocation(MLOutputConfiguration.BuilderImpl defaultOutputLocation) {
            this.defaultOutputLocation = defaultOutputLocation != null ? defaultOutputLocation.build() : null;
        }

        @Override
        public final Builder defaultOutputLocation(MLOutputConfiguration defaultOutputLocation) {
            this.defaultOutputLocation = defaultOutputLocation;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetMlConfigurationResponse build() {
            return new GetMlConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
