/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for the inference container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceContainerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceContainerConfig.Builder, InferenceContainerConfig> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageUri").getter(getter(InferenceContainerConfig::imageUri)).setter(setter(Builder::imageUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageUri;

    private InferenceContainerConfig(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
    }

    /**
     * <p>
     * The registry path of the docker image that contains the inference algorithm. Clean Rooms ML supports both
     * <code>registry/repository[:tag]</code> and <code>registry/repositry[@digest]</code> image path formats. For more
     * information about using images in Clean Rooms ML, see the <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html#sagemaker-Type-AlgorithmSpecification-TrainingImage"
     * >Sagemaker API reference</a>.
     * </p>
     * 
     * @return The registry path of the docker image that contains the inference algorithm. Clean Rooms ML supports both
     *         <code>registry/repository[:tag]</code> and <code>registry/repositry[@digest]</code> image path formats.
     *         For more information about using images in Clean Rooms ML, see the <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html#sagemaker-Type-AlgorithmSpecification-TrainingImage"
     *         >Sagemaker API reference</a>.
     */
    public final String imageUri() {
        return imageUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceContainerConfig)) {
            return false;
        }
        InferenceContainerConfig other = (InferenceContainerConfig) obj;
        return Objects.equals(imageUri(), other.imageUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceContainerConfig").add("ImageUri", imageUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageUri":
            return Optional.ofNullable(clazz.cast(imageUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageUri", IMAGE_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceContainerConfig, T> g) {
        return obj -> g.apply((InferenceContainerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceContainerConfig> {
        /**
         * <p>
         * The registry path of the docker image that contains the inference algorithm. Clean Rooms ML supports both
         * <code>registry/repository[:tag]</code> and <code>registry/repositry[@digest]</code> image path formats. For
         * more information about using images in Clean Rooms ML, see the <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html#sagemaker-Type-AlgorithmSpecification-TrainingImage"
         * >Sagemaker API reference</a>.
         * </p>
         * 
         * @param imageUri
         *        The registry path of the docker image that contains the inference algorithm. Clean Rooms ML supports
         *        both <code>registry/repository[:tag]</code> and <code>registry/repositry[@digest]</code> image path
         *        formats. For more information about using images in Clean Rooms ML, see the <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html#sagemaker-Type-AlgorithmSpecification-TrainingImage"
         *        >Sagemaker API reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUri(String imageUri);
    }

    static final class BuilderImpl implements Builder {
        private String imageUri;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceContainerConfig model) {
            imageUri(model.imageUri);
        }

        public final String getImageUri() {
            return imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        @Override
        public InferenceContainerConfig build() {
            return new InferenceContainerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
