/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides execution parameters for the inference container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceContainerExecutionParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceContainerExecutionParameters.Builder, InferenceContainerExecutionParameters> {
    private static final SdkField<Integer> MAX_PAYLOAD_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxPayloadInMB").getter(getter(InferenceContainerExecutionParameters::maxPayloadInMB))
            .setter(setter(Builder::maxPayloadInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPayloadInMB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_PAYLOAD_IN_MB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxPayloadInMB;

    private InferenceContainerExecutionParameters(BuilderImpl builder) {
        this.maxPayloadInMB = builder.maxPayloadInMB;
    }

    /**
     * <p>
     * The maximum size of the inference container payload, specified in MB.
     * </p>
     * 
     * @return The maximum size of the inference container payload, specified in MB.
     */
    public final Integer maxPayloadInMB() {
        return maxPayloadInMB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxPayloadInMB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceContainerExecutionParameters)) {
            return false;
        }
        InferenceContainerExecutionParameters other = (InferenceContainerExecutionParameters) obj;
        return Objects.equals(maxPayloadInMB(), other.maxPayloadInMB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceContainerExecutionParameters").add("MaxPayloadInMB", maxPayloadInMB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxPayloadInMB":
            return Optional.ofNullable(clazz.cast(maxPayloadInMB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxPayloadInMB", MAX_PAYLOAD_IN_MB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceContainerExecutionParameters, T> g) {
        return obj -> g.apply((InferenceContainerExecutionParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceContainerExecutionParameters> {
        /**
         * <p>
         * The maximum size of the inference container payload, specified in MB.
         * </p>
         * 
         * @param maxPayloadInMB
         *        The maximum size of the inference container payload, specified in MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPayloadInMB(Integer maxPayloadInMB);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxPayloadInMB;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceContainerExecutionParameters model) {
            maxPayloadInMB(model.maxPayloadInMB);
        }

        public final Integer getMaxPayloadInMB() {
            return maxPayloadInMB;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        @Override
        public InferenceContainerExecutionParameters build() {
            return new InferenceContainerExecutionParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
