/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the data source that is used to define an input channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputChannelDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<InputChannelDataSource.Builder, InputChannelDataSource> {
    private static final SdkField<ProtectedQueryInputParameters> PROTECTED_QUERY_INPUT_PARAMETERS_FIELD = SdkField
            .<ProtectedQueryInputParameters> builder(MarshallingType.SDK_POJO)
            .memberName("protectedQueryInputParameters")
            .getter(getter(InputChannelDataSource::protectedQueryInputParameters))
            .setter(setter(Builder::protectedQueryInputParameters))
            .constructor(ProtectedQueryInputParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedQueryInputParameters")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROTECTED_QUERY_INPUT_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProtectedQueryInputParameters protectedQueryInputParameters;

    private final Type type;

    private InputChannelDataSource(BuilderImpl builder) {
        this.protectedQueryInputParameters = builder.protectedQueryInputParameters;
        this.type = builder.type;
    }

    /**
     * Returns the value of the ProtectedQueryInputParameters property for this object.
     * 
     * @return The value of the ProtectedQueryInputParameters property for this object.
     */
    public final ProtectedQueryInputParameters protectedQueryInputParameters() {
        return protectedQueryInputParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protectedQueryInputParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputChannelDataSource)) {
            return false;
        }
        InputChannelDataSource other = (InputChannelDataSource) obj;
        return Objects.equals(protectedQueryInputParameters(), other.protectedQueryInputParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputChannelDataSource").add("ProtectedQueryInputParameters", protectedQueryInputParameters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "protectedQueryInputParameters":
            return Optional.ofNullable(clazz.cast(protectedQueryInputParameters()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #protectedQueryInputParameters()} initialized to the given value.
     *
     * Sets the value of the ProtectedQueryInputParameters property for this object.
     *
     * @param protectedQueryInputParameters
     *        The new value for the ProtectedQueryInputParameters property for this object.
     */
    public static InputChannelDataSource fromProtectedQueryInputParameters(
            ProtectedQueryInputParameters protectedQueryInputParameters) {
        return builder().protectedQueryInputParameters(protectedQueryInputParameters).build();
    }

    /**
     * Create an instance of this class with {@link #protectedQueryInputParameters()} initialized to the given value.
     *
     * Sets the value of the ProtectedQueryInputParameters property for this object.
     *
     * @param protectedQueryInputParameters
     *        The new value for the ProtectedQueryInputParameters property for this object.
     */
    public static InputChannelDataSource fromProtectedQueryInputParameters(
            Consumer<ProtectedQueryInputParameters.Builder> protectedQueryInputParameters) {
        ProtectedQueryInputParameters.Builder builder = ProtectedQueryInputParameters.builder();
        protectedQueryInputParameters.accept(builder);
        return fromProtectedQueryInputParameters(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("protectedQueryInputParameters", PROTECTED_QUERY_INPUT_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputChannelDataSource, T> g) {
        return obj -> g.apply((InputChannelDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputChannelDataSource> {
        /**
         * Sets the value of the ProtectedQueryInputParameters property for this object.
         *
         * @param protectedQueryInputParameters
         *        The new value for the ProtectedQueryInputParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedQueryInputParameters(ProtectedQueryInputParameters protectedQueryInputParameters);

        /**
         * Sets the value of the ProtectedQueryInputParameters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProtectedQueryInputParameters.Builder}
         * avoiding the need to create one manually via {@link ProtectedQueryInputParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQueryInputParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #protectedQueryInputParameters(ProtectedQueryInputParameters)}.
         * 
         * @param protectedQueryInputParameters
         *        a consumer that will call methods on {@link ProtectedQueryInputParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedQueryInputParameters(ProtectedQueryInputParameters)
         */
        default Builder protectedQueryInputParameters(
                Consumer<ProtectedQueryInputParameters.Builder> protectedQueryInputParameters) {
            return protectedQueryInputParameters(ProtectedQueryInputParameters.builder()
                    .applyMutation(protectedQueryInputParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectedQueryInputParameters protectedQueryInputParameters;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InputChannelDataSource model) {
            protectedQueryInputParameters(model.protectedQueryInputParameters);
        }

        public final ProtectedQueryInputParameters.Builder getProtectedQueryInputParameters() {
            return protectedQueryInputParameters != null ? protectedQueryInputParameters.toBuilder() : null;
        }

        public final void setProtectedQueryInputParameters(ProtectedQueryInputParameters.BuilderImpl protectedQueryInputParameters) {
            Object oldValue = this.protectedQueryInputParameters;
            this.protectedQueryInputParameters = protectedQueryInputParameters != null ? protectedQueryInputParameters.build()
                    : null;
            handleUnionValueChange(Type.PROTECTED_QUERY_INPUT_PARAMETERS, oldValue, this.protectedQueryInputParameters);
        }

        @Override
        public final Builder protectedQueryInputParameters(ProtectedQueryInputParameters protectedQueryInputParameters) {
            Object oldValue = this.protectedQueryInputParameters;
            this.protectedQueryInputParameters = protectedQueryInputParameters;
            handleUnionValueChange(Type.PROTECTED_QUERY_INPUT_PARAMETERS, oldValue, this.protectedQueryInputParameters);
            return this;
        }

        @Override
        public InputChannelDataSource build() {
            return new InputChannelDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see InputChannelDataSource#type()
     */
    public enum Type {
        PROTECTED_QUERY_INPUT_PARAMETERS,

        UNKNOWN_TO_SDK_VERSION
    }
}
