/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAudienceGenerationJobsResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<ListAudienceGenerationJobsResponse.Builder, ListAudienceGenerationJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAudienceGenerationJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AudienceGenerationJobSummary>> AUDIENCE_GENERATION_JOBS_FIELD = SdkField
            .<List<AudienceGenerationJobSummary>> builder(MarshallingType.LIST)
            .memberName("audienceGenerationJobs")
            .getter(getter(ListAudienceGenerationJobsResponse::audienceGenerationJobs))
            .setter(setter(Builder::audienceGenerationJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudienceGenerationJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudienceGenerationJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            AUDIENCE_GENERATION_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<AudienceGenerationJobSummary> audienceGenerationJobs;

    private ListAudienceGenerationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.audienceGenerationJobs = builder.audienceGenerationJobs;
    }

    /**
     * <p>
     * The token value used to access the next page of results.
     * </p>
     * 
     * @return The token value used to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudienceGenerationJobs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAudienceGenerationJobs() {
        return audienceGenerationJobs != null && !(audienceGenerationJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The audience generation jobs that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudienceGenerationJobs} method.
     * </p>
     * 
     * @return The audience generation jobs that match the request.
     */
    public final List<AudienceGenerationJobSummary> audienceGenerationJobs() {
        return audienceGenerationJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAudienceGenerationJobs() ? audienceGenerationJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAudienceGenerationJobsResponse)) {
            return false;
        }
        ListAudienceGenerationJobsResponse other = (ListAudienceGenerationJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasAudienceGenerationJobs() == other.hasAudienceGenerationJobs()
                && Objects.equals(audienceGenerationJobs(), other.audienceGenerationJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAudienceGenerationJobsResponse").add("NextToken", nextToken())
                .add("AudienceGenerationJobs", hasAudienceGenerationJobs() ? audienceGenerationJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "audienceGenerationJobs":
            return Optional.ofNullable(clazz.cast(audienceGenerationJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("audienceGenerationJobs", AUDIENCE_GENERATION_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAudienceGenerationJobsResponse, T> g) {
        return obj -> g.apply((ListAudienceGenerationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAudienceGenerationJobsResponse> {
        /**
         * <p>
         * The token value used to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value used to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The audience generation jobs that match the request.
         * </p>
         * 
         * @param audienceGenerationJobs
         *        The audience generation jobs that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceGenerationJobs(Collection<AudienceGenerationJobSummary> audienceGenerationJobs);

        /**
         * <p>
         * The audience generation jobs that match the request.
         * </p>
         * 
         * @param audienceGenerationJobs
         *        The audience generation jobs that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceGenerationJobs(AudienceGenerationJobSummary... audienceGenerationJobs);

        /**
         * <p>
         * The audience generation jobs that match the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #audienceGenerationJobs(List<AudienceGenerationJobSummary>)}.
         * 
         * @param audienceGenerationJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceGenerationJobs(java.util.Collection<AudienceGenerationJobSummary>)
         */
        Builder audienceGenerationJobs(Consumer<AudienceGenerationJobSummary.Builder>... audienceGenerationJobs);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AudienceGenerationJobSummary> audienceGenerationJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAudienceGenerationJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            audienceGenerationJobs(model.audienceGenerationJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AudienceGenerationJobSummary.Builder> getAudienceGenerationJobs() {
            List<AudienceGenerationJobSummary.Builder> result = AudienceGenerationJobListCopier
                    .copyToBuilder(this.audienceGenerationJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceGenerationJobs(Collection<AudienceGenerationJobSummary.BuilderImpl> audienceGenerationJobs) {
            this.audienceGenerationJobs = AudienceGenerationJobListCopier.copyFromBuilder(audienceGenerationJobs);
        }

        @Override
        public final Builder audienceGenerationJobs(Collection<AudienceGenerationJobSummary> audienceGenerationJobs) {
            this.audienceGenerationJobs = AudienceGenerationJobListCopier.copy(audienceGenerationJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceGenerationJobs(AudienceGenerationJobSummary... audienceGenerationJobs) {
            audienceGenerationJobs(Arrays.asList(audienceGenerationJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceGenerationJobs(Consumer<AudienceGenerationJobSummary.Builder>... audienceGenerationJobs) {
            audienceGenerationJobs(Stream.of(audienceGenerationJobs)
                    .map(c -> AudienceGenerationJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAudienceGenerationJobsResponse build() {
            return new ListAudienceGenerationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
