/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationTrainedModelExportJobsResponse extends CleanRoomsMlResponse
        implements
        ToCopyableBuilder<ListCollaborationTrainedModelExportJobsResponse.Builder, ListCollaborationTrainedModelExportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationTrainedModelExportJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<CollaborationTrainedModelExportJobSummary>> COLLABORATION_TRAINED_MODEL_EXPORT_JOBS_FIELD = SdkField
            .<List<CollaborationTrainedModelExportJobSummary>> builder(MarshallingType.LIST)
            .memberName("collaborationTrainedModelExportJobs")
            .getter(getter(ListCollaborationTrainedModelExportJobsResponse::collaborationTrainedModelExportJobs))
            .setter(setter(Builder::collaborationTrainedModelExportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("collaborationTrainedModelExportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaborationTrainedModelExportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaborationTrainedModelExportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            COLLABORATION_TRAINED_MODEL_EXPORT_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs;

    private ListCollaborationTrainedModelExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationTrainedModelExportJobs = builder.collaborationTrainedModelExportJobs;
    }

    /**
     * <p>
     * The token value used to access the next page of results.
     * </p>
     * 
     * @return The token value used to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollaborationTrainedModelExportJobs
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCollaborationTrainedModelExportJobs() {
        return collaborationTrainedModelExportJobs != null
                && !(collaborationTrainedModelExportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The exports jobs that exist for the requested trained model in the requested collaboration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaborationTrainedModelExportJobs}
     * method.
     * </p>
     * 
     * @return The exports jobs that exist for the requested trained model in the requested collaboration.
     */
    public final List<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs() {
        return collaborationTrainedModelExportJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCollaborationTrainedModelExportJobs() ? collaborationTrainedModelExportJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationTrainedModelExportJobsResponse)) {
            return false;
        }
        ListCollaborationTrainedModelExportJobsResponse other = (ListCollaborationTrainedModelExportJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasCollaborationTrainedModelExportJobs() == other.hasCollaborationTrainedModelExportJobs()
                && Objects.equals(collaborationTrainedModelExportJobs(), other.collaborationTrainedModelExportJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListCollaborationTrainedModelExportJobsResponse")
                .add("NextToken", nextToken())
                .add("CollaborationTrainedModelExportJobs",
                        hasCollaborationTrainedModelExportJobs() ? collaborationTrainedModelExportJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "collaborationTrainedModelExportJobs":
            return Optional.ofNullable(clazz.cast(collaborationTrainedModelExportJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("collaborationTrainedModelExportJobs", COLLABORATION_TRAINED_MODEL_EXPORT_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationTrainedModelExportJobsResponse, T> g) {
        return obj -> g.apply((ListCollaborationTrainedModelExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollaborationTrainedModelExportJobsResponse> {
        /**
         * <p>
         * The token value used to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value used to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The exports jobs that exist for the requested trained model in the requested collaboration.
         * </p>
         * 
         * @param collaborationTrainedModelExportJobs
         *        The exports jobs that exist for the requested trained model in the requested collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationTrainedModelExportJobs(
                Collection<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs);

        /**
         * <p>
         * The exports jobs that exist for the requested trained model in the requested collaboration.
         * </p>
         * 
         * @param collaborationTrainedModelExportJobs
         *        The exports jobs that exist for the requested trained model in the requested collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationTrainedModelExportJobs(
                CollaborationTrainedModelExportJobSummary... collaborationTrainedModelExportJobs);

        /**
         * <p>
         * The exports jobs that exist for the requested trained model in the requested collaboration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #collaborationTrainedModelExportJobs(List<CollaborationTrainedModelExportJobSummary>)}.
         * 
         * @param collaborationTrainedModelExportJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationTrainedModelExportJobs(java.util.Collection<CollaborationTrainedModelExportJobSummary>)
         */
        Builder collaborationTrainedModelExportJobs(
                Consumer<CollaborationTrainedModelExportJobSummary.Builder>... collaborationTrainedModelExportJobs);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationTrainedModelExportJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            collaborationTrainedModelExportJobs(model.collaborationTrainedModelExportJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationTrainedModelExportJobSummary.Builder> getCollaborationTrainedModelExportJobs() {
            List<CollaborationTrainedModelExportJobSummary.Builder> result = CollaborationTrainedModelExportJobListCopier
                    .copyToBuilder(this.collaborationTrainedModelExportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationTrainedModelExportJobs(
                Collection<CollaborationTrainedModelExportJobSummary.BuilderImpl> collaborationTrainedModelExportJobs) {
            this.collaborationTrainedModelExportJobs = CollaborationTrainedModelExportJobListCopier
                    .copyFromBuilder(collaborationTrainedModelExportJobs);
        }

        @Override
        public final Builder collaborationTrainedModelExportJobs(
                Collection<CollaborationTrainedModelExportJobSummary> collaborationTrainedModelExportJobs) {
            this.collaborationTrainedModelExportJobs = CollaborationTrainedModelExportJobListCopier
                    .copy(collaborationTrainedModelExportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationTrainedModelExportJobs(
                CollaborationTrainedModelExportJobSummary... collaborationTrainedModelExportJobs) {
            collaborationTrainedModelExportJobs(Arrays.asList(collaborationTrainedModelExportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationTrainedModelExportJobs(
                Consumer<CollaborationTrainedModelExportJobSummary.Builder>... collaborationTrainedModelExportJobs) {
            collaborationTrainedModelExportJobs(Stream.of(collaborationTrainedModelExportJobs)
                    .map(c -> CollaborationTrainedModelExportJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationTrainedModelExportJobsResponse build() {
            return new ListCollaborationTrainedModelExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
