/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration policy for metrics generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsConfigurationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricsConfigurationPolicy.Builder, MetricsConfigurationPolicy> {
    private static final SdkField<String> NOISE_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("noiseLevel").getter(getter(MetricsConfigurationPolicy::noiseLevelAsString))
            .setter(setter(Builder::noiseLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noiseLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOISE_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String noiseLevel;

    private MetricsConfigurationPolicy(BuilderImpl builder) {
        this.noiseLevel = builder.noiseLevel;
    }

    /**
     * <p>
     * The noise level for the generated metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #noiseLevel} will
     * return {@link NoiseLevelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #noiseLevelAsString}.
     * </p>
     * 
     * @return The noise level for the generated metrics.
     * @see NoiseLevelType
     */
    public final NoiseLevelType noiseLevel() {
        return NoiseLevelType.fromValue(noiseLevel);
    }

    /**
     * <p>
     * The noise level for the generated metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #noiseLevel} will
     * return {@link NoiseLevelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #noiseLevelAsString}.
     * </p>
     * 
     * @return The noise level for the generated metrics.
     * @see NoiseLevelType
     */
    public final String noiseLevelAsString() {
        return noiseLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noiseLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsConfigurationPolicy)) {
            return false;
        }
        MetricsConfigurationPolicy other = (MetricsConfigurationPolicy) obj;
        return Objects.equals(noiseLevelAsString(), other.noiseLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricsConfigurationPolicy").add("NoiseLevel", noiseLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "noiseLevel":
            return Optional.ofNullable(clazz.cast(noiseLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("noiseLevel", NOISE_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricsConfigurationPolicy, T> g) {
        return obj -> g.apply((MetricsConfigurationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricsConfigurationPolicy> {
        /**
         * <p>
         * The noise level for the generated metrics.
         * </p>
         * 
         * @param noiseLevel
         *        The noise level for the generated metrics.
         * @see NoiseLevelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoiseLevelType
         */
        Builder noiseLevel(String noiseLevel);

        /**
         * <p>
         * The noise level for the generated metrics.
         * </p>
         * 
         * @param noiseLevel
         *        The noise level for the generated metrics.
         * @see NoiseLevelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoiseLevelType
         */
        Builder noiseLevel(NoiseLevelType noiseLevel);
    }

    static final class BuilderImpl implements Builder {
        private String noiseLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsConfigurationPolicy model) {
            noiseLevel(model.noiseLevel);
        }

        public final String getNoiseLevel() {
            return noiseLevel;
        }

        public final void setNoiseLevel(String noiseLevel) {
            this.noiseLevel = noiseLevel;
        }

        @Override
        public final Builder noiseLevel(String noiseLevel) {
            this.noiseLevel = noiseLevel;
            return this;
        }

        @Override
        public final Builder noiseLevel(NoiseLevelType noiseLevel) {
            this.noiseLevel(noiseLevel == null ? null : noiseLevel.toString());
            return this;
        }

        @Override
        public MetricsConfigurationPolicy build() {
            return new MetricsConfigurationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
