/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the privacy configuration for a configured model algorithm association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivacyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivacyConfiguration.Builder, PrivacyConfiguration> {
    private static final SdkField<PrivacyConfigurationPolicies> POLICIES_FIELD = SdkField
            .<PrivacyConfigurationPolicies> builder(MarshallingType.SDK_POJO).memberName("policies")
            .getter(getter(PrivacyConfiguration::policies)).setter(setter(Builder::policies))
            .constructor(PrivacyConfigurationPolicies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policies").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PrivacyConfigurationPolicies policies;

    private PrivacyConfiguration(BuilderImpl builder) {
        this.policies = builder.policies;
    }

    /**
     * <p>
     * The privacy configuration policies for a configured model algorithm association.
     * </p>
     * 
     * @return The privacy configuration policies for a configured model algorithm association.
     */
    public final PrivacyConfigurationPolicies policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyConfiguration)) {
            return false;
        }
        PrivacyConfiguration other = (PrivacyConfiguration) obj;
        return Objects.equals(policies(), other.policies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivacyConfiguration").add("Policies", policies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policies", POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivacyConfiguration, T> g) {
        return obj -> g.apply((PrivacyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivacyConfiguration> {
        /**
         * <p>
         * The privacy configuration policies for a configured model algorithm association.
         * </p>
         * 
         * @param policies
         *        The privacy configuration policies for a configured model algorithm association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(PrivacyConfigurationPolicies policies);

        /**
         * <p>
         * The privacy configuration policies for a configured model algorithm association.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivacyConfigurationPolicies.Builder}
         * avoiding the need to create one manually via {@link PrivacyConfigurationPolicies#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyConfigurationPolicies.Builder#build()} is called
         * immediately and its result is passed to {@link #policies(PrivacyConfigurationPolicies)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link PrivacyConfigurationPolicies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(PrivacyConfigurationPolicies)
         */
        default Builder policies(Consumer<PrivacyConfigurationPolicies.Builder> policies) {
            return policies(PrivacyConfigurationPolicies.builder().applyMutation(policies).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PrivacyConfigurationPolicies policies;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyConfiguration model) {
            policies(model.policies);
        }

        public final PrivacyConfigurationPolicies.Builder getPolicies() {
            return policies != null ? policies.toBuilder() : null;
        }

        public final void setPolicies(PrivacyConfigurationPolicies.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        @Override
        public final Builder policies(PrivacyConfigurationPolicies policies) {
            this.policies = policies;
            return this;
        }

        @Override
        public PrivacyConfiguration build() {
            return new PrivacyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
