/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the privacy configuration policies for a configured model algorithm association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivacyConfigurationPolicies implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivacyConfigurationPolicies.Builder, PrivacyConfigurationPolicies> {
    private static final SdkField<TrainedModelsConfigurationPolicy> TRAINED_MODELS_FIELD = SdkField
            .<TrainedModelsConfigurationPolicy> builder(MarshallingType.SDK_POJO).memberName("trainedModels")
            .getter(getter(PrivacyConfigurationPolicies::trainedModels)).setter(setter(Builder::trainedModels))
            .constructor(TrainedModelsConfigurationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModels").build()).build();

    private static final SdkField<TrainedModelExportsConfigurationPolicy> TRAINED_MODEL_EXPORTS_FIELD = SdkField
            .<TrainedModelExportsConfigurationPolicy> builder(MarshallingType.SDK_POJO).memberName("trainedModelExports")
            .getter(getter(PrivacyConfigurationPolicies::trainedModelExports)).setter(setter(Builder::trainedModelExports))
            .constructor(TrainedModelExportsConfigurationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelExports").build())
            .build();

    private static final SdkField<TrainedModelInferenceJobsConfigurationPolicy> TRAINED_MODEL_INFERENCE_JOBS_FIELD = SdkField
            .<TrainedModelInferenceJobsConfigurationPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("trainedModelInferenceJobs").getter(getter(PrivacyConfigurationPolicies::trainedModelInferenceJobs))
            .setter(setter(Builder::trainedModelInferenceJobs))
            .constructor(TrainedModelInferenceJobsConfigurationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelInferenceJobs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODELS_FIELD,
            TRAINED_MODEL_EXPORTS_FIELD, TRAINED_MODEL_INFERENCE_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TrainedModelsConfigurationPolicy trainedModels;

    private final TrainedModelExportsConfigurationPolicy trainedModelExports;

    private final TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs;

    private PrivacyConfigurationPolicies(BuilderImpl builder) {
        this.trainedModels = builder.trainedModels;
        this.trainedModelExports = builder.trainedModelExports;
        this.trainedModelInferenceJobs = builder.trainedModelInferenceJobs;
    }

    /**
     * <p>
     * Specifies who will receive the trained models.
     * </p>
     * 
     * @return Specifies who will receive the trained models.
     */
    public final TrainedModelsConfigurationPolicy trainedModels() {
        return trainedModels;
    }

    /**
     * <p>
     * Specifies who will receive the trained model export.
     * </p>
     * 
     * @return Specifies who will receive the trained model export.
     */
    public final TrainedModelExportsConfigurationPolicy trainedModelExports() {
        return trainedModelExports;
    }

    /**
     * <p>
     * Specifies who will receive the trained model inference jobs.
     * </p>
     * 
     * @return Specifies who will receive the trained model inference jobs.
     */
    public final TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs() {
        return trainedModelInferenceJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainedModels());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelExports());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelInferenceJobs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyConfigurationPolicies)) {
            return false;
        }
        PrivacyConfigurationPolicies other = (PrivacyConfigurationPolicies) obj;
        return Objects.equals(trainedModels(), other.trainedModels())
                && Objects.equals(trainedModelExports(), other.trainedModelExports())
                && Objects.equals(trainedModelInferenceJobs(), other.trainedModelInferenceJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivacyConfigurationPolicies").add("TrainedModels", trainedModels())
                .add("TrainedModelExports", trainedModelExports()).add("TrainedModelInferenceJobs", trainedModelInferenceJobs())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trainedModels":
            return Optional.ofNullable(clazz.cast(trainedModels()));
        case "trainedModelExports":
            return Optional.ofNullable(clazz.cast(trainedModelExports()));
        case "trainedModelInferenceJobs":
            return Optional.ofNullable(clazz.cast(trainedModelInferenceJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trainedModels", TRAINED_MODELS_FIELD);
        map.put("trainedModelExports", TRAINED_MODEL_EXPORTS_FIELD);
        map.put("trainedModelInferenceJobs", TRAINED_MODEL_INFERENCE_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivacyConfigurationPolicies, T> g) {
        return obj -> g.apply((PrivacyConfigurationPolicies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivacyConfigurationPolicies> {
        /**
         * <p>
         * Specifies who will receive the trained models.
         * </p>
         * 
         * @param trainedModels
         *        Specifies who will receive the trained models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModels(TrainedModelsConfigurationPolicy trainedModels);

        /**
         * <p>
         * Specifies who will receive the trained models.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainedModelsConfigurationPolicy.Builder}
         * avoiding the need to create one manually via {@link TrainedModelsConfigurationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainedModelsConfigurationPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #trainedModels(TrainedModelsConfigurationPolicy)}.
         * 
         * @param trainedModels
         *        a consumer that will call methods on {@link TrainedModelsConfigurationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainedModels(TrainedModelsConfigurationPolicy)
         */
        default Builder trainedModels(Consumer<TrainedModelsConfigurationPolicy.Builder> trainedModels) {
            return trainedModels(TrainedModelsConfigurationPolicy.builder().applyMutation(trainedModels).build());
        }

        /**
         * <p>
         * Specifies who will receive the trained model export.
         * </p>
         * 
         * @param trainedModelExports
         *        Specifies who will receive the trained model export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelExports(TrainedModelExportsConfigurationPolicy trainedModelExports);

        /**
         * <p>
         * Specifies who will receive the trained model export.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TrainedModelExportsConfigurationPolicy.Builder} avoiding the need to create one manually via
         * {@link TrainedModelExportsConfigurationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainedModelExportsConfigurationPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #trainedModelExports(TrainedModelExportsConfigurationPolicy)}.
         * 
         * @param trainedModelExports
         *        a consumer that will call methods on {@link TrainedModelExportsConfigurationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainedModelExports(TrainedModelExportsConfigurationPolicy)
         */
        default Builder trainedModelExports(Consumer<TrainedModelExportsConfigurationPolicy.Builder> trainedModelExports) {
            return trainedModelExports(TrainedModelExportsConfigurationPolicy.builder().applyMutation(trainedModelExports)
                    .build());
        }

        /**
         * <p>
         * Specifies who will receive the trained model inference jobs.
         * </p>
         * 
         * @param trainedModelInferenceJobs
         *        Specifies who will receive the trained model inference jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelInferenceJobs(TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs);

        /**
         * <p>
         * Specifies who will receive the trained model inference jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TrainedModelInferenceJobsConfigurationPolicy.Builder} avoiding the need to create one manually via
         * {@link TrainedModelInferenceJobsConfigurationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainedModelInferenceJobsConfigurationPolicy.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #trainedModelInferenceJobs(TrainedModelInferenceJobsConfigurationPolicy)}.
         * 
         * @param trainedModelInferenceJobs
         *        a consumer that will call methods on {@link TrainedModelInferenceJobsConfigurationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainedModelInferenceJobs(TrainedModelInferenceJobsConfigurationPolicy)
         */
        default Builder trainedModelInferenceJobs(
                Consumer<TrainedModelInferenceJobsConfigurationPolicy.Builder> trainedModelInferenceJobs) {
            return trainedModelInferenceJobs(TrainedModelInferenceJobsConfigurationPolicy.builder()
                    .applyMutation(trainedModelInferenceJobs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TrainedModelsConfigurationPolicy trainedModels;

        private TrainedModelExportsConfigurationPolicy trainedModelExports;

        private TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyConfigurationPolicies model) {
            trainedModels(model.trainedModels);
            trainedModelExports(model.trainedModelExports);
            trainedModelInferenceJobs(model.trainedModelInferenceJobs);
        }

        public final TrainedModelsConfigurationPolicy.Builder getTrainedModels() {
            return trainedModels != null ? trainedModels.toBuilder() : null;
        }

        public final void setTrainedModels(TrainedModelsConfigurationPolicy.BuilderImpl trainedModels) {
            this.trainedModels = trainedModels != null ? trainedModels.build() : null;
        }

        @Override
        public final Builder trainedModels(TrainedModelsConfigurationPolicy trainedModels) {
            this.trainedModels = trainedModels;
            return this;
        }

        public final TrainedModelExportsConfigurationPolicy.Builder getTrainedModelExports() {
            return trainedModelExports != null ? trainedModelExports.toBuilder() : null;
        }

        public final void setTrainedModelExports(TrainedModelExportsConfigurationPolicy.BuilderImpl trainedModelExports) {
            this.trainedModelExports = trainedModelExports != null ? trainedModelExports.build() : null;
        }

        @Override
        public final Builder trainedModelExports(TrainedModelExportsConfigurationPolicy trainedModelExports) {
            this.trainedModelExports = trainedModelExports;
            return this;
        }

        public final TrainedModelInferenceJobsConfigurationPolicy.Builder getTrainedModelInferenceJobs() {
            return trainedModelInferenceJobs != null ? trainedModelInferenceJobs.toBuilder() : null;
        }

        public final void setTrainedModelInferenceJobs(
                TrainedModelInferenceJobsConfigurationPolicy.BuilderImpl trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs = trainedModelInferenceJobs != null ? trainedModelInferenceJobs.build() : null;
        }

        @Override
        public final Builder trainedModelInferenceJobs(TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs = trainedModelInferenceJobs;
            return this;
        }

        @Override
        public PrivacyConfigurationPolicies build() {
            return new PrivacyConfigurationPolicies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
