/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTrainedModelExportJobRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<StartTrainedModelExportJobRequest.Builder, StartTrainedModelExportJobRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartTrainedModelExportJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(StartTrainedModelExportJobRequest::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(StartTrainedModelExportJobRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<TrainedModelExportOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<TrainedModelExportOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(StartTrainedModelExportJobRequest::outputConfiguration)).setter(setter(Builder::outputConfiguration))
            .constructor(TrainedModelExportOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StartTrainedModelExportJobRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TRAINED_MODEL_ARN_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, OUTPUT_CONFIGURATION_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String trainedModelArn;

    private final String membershipIdentifier;

    private final TrainedModelExportOutputConfiguration outputConfiguration;

    private final String description;

    private StartTrainedModelExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.trainedModelArn = builder.trainedModelArn;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.outputConfiguration = builder.outputConfiguration;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the trained model export job.
     * </p>
     * 
     * @return The name of the trained model export job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model that you want to export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model that you want to export.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The membership ID of the member that is receiving the exported trained model artifacts.
     * </p>
     * 
     * @return The membership ID of the member that is receiving the exported trained model artifacts.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The output configuration information for the trained model export job.
     * </p>
     * 
     * @return The output configuration information for the trained model export job.
     */
    public final TrainedModelExportOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * The description of the trained model export job.
     * </p>
     * 
     * @return The description of the trained model export job.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTrainedModelExportJobRequest)) {
            return false;
        }
        StartTrainedModelExportJobRequest other = (StartTrainedModelExportJobRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(outputConfiguration(), other.outputConfiguration())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTrainedModelExportJobRequest").add("Name", name())
                .add("TrainedModelArn", trainedModelArn()).add("MembershipIdentifier", membershipIdentifier())
                .add("OutputConfiguration", outputConfiguration()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTrainedModelExportJobRequest, T> g) {
        return obj -> g.apply((StartTrainedModelExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartTrainedModelExportJobRequest> {
        /**
         * <p>
         * The name of the trained model export job.
         * </p>
         * 
         * @param name
         *        The name of the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model that you want to export.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the trained model that you want to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The membership ID of the member that is receiving the exported trained model artifacts.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that is receiving the exported trained model artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The output configuration information for the trained model export job.
         * </p>
         * 
         * @param outputConfiguration
         *        The output configuration information for the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(TrainedModelExportOutputConfiguration outputConfiguration);

        /**
         * <p>
         * The output configuration information for the trained model export job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TrainedModelExportOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link TrainedModelExportOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainedModelExportOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfiguration(TrainedModelExportOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link TrainedModelExportOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(TrainedModelExportOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<TrainedModelExportOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(TrainedModelExportOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }

        /**
         * <p>
         * The description of the trained model export job.
         * </p>
         * 
         * @param description
         *        The description of the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String name;

        private String trainedModelArn;

        private String membershipIdentifier;

        private TrainedModelExportOutputConfiguration outputConfiguration;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTrainedModelExportJobRequest model) {
            super(model);
            name(model.name);
            trainedModelArn(model.trainedModelArn);
            membershipIdentifier(model.membershipIdentifier);
            outputConfiguration(model.outputConfiguration);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final TrainedModelExportOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(TrainedModelExportOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(TrainedModelExportOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTrainedModelExportJobRequest build() {
            return new StartTrainedModelExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
