/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTrainedModelInferenceJobRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<StartTrainedModelInferenceJobRequest.Builder, StartTrainedModelInferenceJobRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(StartTrainedModelInferenceJobRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartTrainedModelInferenceJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(StartTrainedModelInferenceJobRequest::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(StartTrainedModelInferenceJobRequest::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final SdkField<InferenceResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<InferenceResourceConfig> builder(MarshallingType.SDK_POJO).memberName("resourceConfig")
            .getter(getter(StartTrainedModelInferenceJobRequest::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(InferenceResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()).build();

    private static final SdkField<InferenceOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(StartTrainedModelInferenceJobRequest::outputConfiguration))
            .setter(setter(Builder::outputConfiguration)).constructor(InferenceOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<ModelInferenceDataSource> DATA_SOURCE_FIELD = SdkField
            .<ModelInferenceDataSource> builder(MarshallingType.SDK_POJO).memberName("dataSource")
            .getter(getter(StartTrainedModelInferenceJobRequest::dataSource)).setter(setter(Builder::dataSource))
            .constructor(ModelInferenceDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StartTrainedModelInferenceJobRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<InferenceContainerExecutionParameters> CONTAINER_EXECUTION_PARAMETERS_FIELD = SdkField
            .<InferenceContainerExecutionParameters> builder(MarshallingType.SDK_POJO)
            .memberName("containerExecutionParameters")
            .getter(getter(StartTrainedModelInferenceJobRequest::containerExecutionParameters))
            .setter(setter(Builder::containerExecutionParameters))
            .constructor(InferenceContainerExecutionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerExecutionParameters")
                    .build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environment")
            .getter(getter(StartTrainedModelInferenceJobRequest::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(StartTrainedModelInferenceJobRequest::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartTrainedModelInferenceJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            NAME_FIELD, TRAINED_MODEL_ARN_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, RESOURCE_CONFIG_FIELD,
            OUTPUT_CONFIGURATION_FIELD, DATA_SOURCE_FIELD, DESCRIPTION_FIELD, CONTAINER_EXECUTION_PARAMETERS_FIELD,
            ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String name;

    private final String trainedModelArn;

    private final String configuredModelAlgorithmAssociationArn;

    private final InferenceResourceConfig resourceConfig;

    private final InferenceOutputConfiguration outputConfiguration;

    private final ModelInferenceDataSource dataSource;

    private final String description;

    private final InferenceContainerExecutionParameters containerExecutionParameters;

    private final Map<String, String> environment;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private StartTrainedModelInferenceJobRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.trainedModelArn = builder.trainedModelArn;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.resourceConfig = builder.resourceConfig;
        this.outputConfiguration = builder.outputConfiguration;
        this.dataSource = builder.dataSource;
        this.description = builder.description;
        this.containerExecutionParameters = builder.containerExecutionParameters;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The membership ID of the membership that contains the trained model inference job.
     * </p>
     * 
     * @return The membership ID of the membership that contains the trained model inference job.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The name of the trained model inference job.
     * </p>
     * 
     * @return The name of the trained model inference job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model that is used for this trained model inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model that is used for this trained model inference job.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association that is used for this trained model
     * inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association that is used for this
     *         trained model inference job.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    /**
     * <p>
     * Defines the resource configuration for the trained model inference job.
     * </p>
     * 
     * @return Defines the resource configuration for the trained model inference job.
     */
    public final InferenceResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * Defines the output configuration information for the trained model inference job.
     * </p>
     * 
     * @return Defines the output configuration information for the trained model inference job.
     */
    public final InferenceOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * Defines the data source that is used for the trained model inference job.
     * </p>
     * 
     * @return Defines the data source that is used for the trained model inference job.
     */
    public final ModelInferenceDataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The description of the trained model inference job.
     * </p>
     * 
     * @return The description of the trained model inference job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The execution parameters for the container.
     * </p>
     * 
     * @return The execution parameters for the container.
     */
    public final InferenceContainerExecutionParameters containerExecutionParameters() {
        return containerExecutionParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the Docker container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The environment variables to set in the Docker container.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the
     * ML inference job and associated data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
     *         data in the ML inference job and associated data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the
     * limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user
     *         tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(containerExecutionParameters());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTrainedModelInferenceJobRequest)) {
            return false;
        }
        StartTrainedModelInferenceJobRequest other = (StartTrainedModelInferenceJobRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn())
                && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(outputConfiguration(), other.outputConfiguration())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(description(), other.description())
                && Objects.equals(containerExecutionParameters(), other.containerExecutionParameters())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTrainedModelInferenceJobRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("Name", name()).add("TrainedModelArn", trainedModelArn())
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn())
                .add("ResourceConfig", resourceConfig()).add("OutputConfiguration", outputConfiguration())
                .add("DataSource", dataSource()).add("Description", description())
                .add("ContainerExecutionParameters", containerExecutionParameters())
                .add("Environment", hasEnvironment() ? environment() : null).add("KmsKeyArn", kmsKeyArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        case "resourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "containerExecutionParameters":
            return Optional.ofNullable(clazz.cast(containerExecutionParameters()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("resourceConfig", RESOURCE_CONFIG_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("containerExecutionParameters", CONTAINER_EXECUTION_PARAMETERS_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTrainedModelInferenceJobRequest, T> g) {
        return obj -> g.apply((StartTrainedModelInferenceJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartTrainedModelInferenceJobRequest> {
        /**
         * <p>
         * The membership ID of the membership that contains the trained model inference job.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the membership that contains the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The name of the trained model inference job.
         * </p>
         * 
         * @param name
         *        The name of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model that is used for this trained model inference job.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the trained model that is used for this trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association that is used for this trained
         * model inference job.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association that is used for this
         *        trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);

        /**
         * <p>
         * Defines the resource configuration for the trained model inference job.
         * </p>
         * 
         * @param resourceConfig
         *        Defines the resource configuration for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(InferenceResourceConfig resourceConfig);

        /**
         * <p>
         * Defines the resource configuration for the trained model inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceResourceConfig.Builder} avoiding
         * the need to create one manually via {@link InferenceResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceResourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceConfig(InferenceResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link InferenceResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(InferenceResourceConfig)
         */
        default Builder resourceConfig(Consumer<InferenceResourceConfig.Builder> resourceConfig) {
            return resourceConfig(InferenceResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * Defines the output configuration information for the trained model inference job.
         * </p>
         * 
         * @param outputConfiguration
         *        Defines the output configuration information for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration);

        /**
         * <p>
         * Defines the output configuration information for the trained model inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link InferenceOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfiguration(InferenceOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link InferenceOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(InferenceOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<InferenceOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(InferenceOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }

        /**
         * <p>
         * Defines the data source that is used for the trained model inference job.
         * </p>
         * 
         * @param dataSource
         *        Defines the data source that is used for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(ModelInferenceDataSource dataSource);

        /**
         * <p>
         * Defines the data source that is used for the trained model inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelInferenceDataSource.Builder}
         * avoiding the need to create one manually via {@link ModelInferenceDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInferenceDataSource.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSource(ModelInferenceDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link ModelInferenceDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(ModelInferenceDataSource)
         */
        default Builder dataSource(Consumer<ModelInferenceDataSource.Builder> dataSource) {
            return dataSource(ModelInferenceDataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The description of the trained model inference job.
         * </p>
         * 
         * @param description
         *        The description of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The execution parameters for the container.
         * </p>
         * 
         * @param containerExecutionParameters
         *        The execution parameters for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerExecutionParameters(InferenceContainerExecutionParameters containerExecutionParameters);

        /**
         * <p>
         * The execution parameters for the container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceContainerExecutionParameters.Builder} avoiding the need to create one manually via
         * {@link InferenceContainerExecutionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceContainerExecutionParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #containerExecutionParameters(InferenceContainerExecutionParameters)}.
         * 
         * @param containerExecutionParameters
         *        a consumer that will call methods on {@link InferenceContainerExecutionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerExecutionParameters(InferenceContainerExecutionParameters)
         */
        default Builder containerExecutionParameters(
                Consumer<InferenceContainerExecutionParameters.Builder> containerExecutionParameters) {
            return containerExecutionParameters(InferenceContainerExecutionParameters.builder()
                    .applyMutation(containerExecutionParameters).build());
        }

        /**
         * <p>
         * The environment variables to set in the Docker container.
         * </p>
         * 
         * @param environment
         *        The environment variables to set in the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in
         * the ML inference job and associated data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
         *        data in the ML inference job and associated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to
         *        be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String name;

        private String trainedModelArn;

        private String configuredModelAlgorithmAssociationArn;

        private InferenceResourceConfig resourceConfig;

        private InferenceOutputConfiguration outputConfiguration;

        private ModelInferenceDataSource dataSource;

        private String description;

        private InferenceContainerExecutionParameters containerExecutionParameters;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTrainedModelInferenceJobRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            name(model.name);
            trainedModelArn(model.trainedModelArn);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            resourceConfig(model.resourceConfig);
            outputConfiguration(model.outputConfiguration);
            dataSource(model.dataSource);
            description(model.description);
            containerExecutionParameters(model.containerExecutionParameters);
            environment(model.environment);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final InferenceResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(InferenceResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(InferenceResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(InferenceOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final ModelInferenceDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(ModelInferenceDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(ModelInferenceDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final InferenceContainerExecutionParameters.Builder getContainerExecutionParameters() {
            return containerExecutionParameters != null ? containerExecutionParameters.toBuilder() : null;
        }

        public final void setContainerExecutionParameters(
                InferenceContainerExecutionParameters.BuilderImpl containerExecutionParameters) {
            this.containerExecutionParameters = containerExecutionParameters != null ? containerExecutionParameters.build()
                    : null;
        }

        @Override
        public final Builder containerExecutionParameters(InferenceContainerExecutionParameters containerExecutionParameters) {
            this.containerExecutionParameters = containerExecutionParameters;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = InferenceEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = InferenceEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTrainedModelInferenceJobRequest build() {
            return new StartTrainedModelInferenceJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
