/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how the trained model exports are configured.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainedModelExportsConfigurationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainedModelExportsConfigurationPolicy.Builder, TrainedModelExportsConfigurationPolicy> {
    private static final SdkField<TrainedModelExportsMaxSize> MAX_SIZE_FIELD = SdkField
            .<TrainedModelExportsMaxSize> builder(MarshallingType.SDK_POJO).memberName("maxSize")
            .getter(getter(TrainedModelExportsConfigurationPolicy::maxSize)).setter(setter(Builder::maxSize))
            .constructor(TrainedModelExportsMaxSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()).build();

    private static final SdkField<List<String>> FILES_TO_EXPORT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("filesToExport")
            .getter(getter(TrainedModelExportsConfigurationPolicy::filesToExportAsStrings))
            .setter(setter(Builder::filesToExportWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesToExport").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_SIZE_FIELD,
            FILES_TO_EXPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TrainedModelExportsMaxSize maxSize;

    private final List<String> filesToExport;

    private TrainedModelExportsConfigurationPolicy(BuilderImpl builder) {
        this.maxSize = builder.maxSize;
        this.filesToExport = builder.filesToExport;
    }

    /**
     * <p>
     * The maximum size of the data that can be exported.
     * </p>
     * 
     * @return The maximum size of the data that can be exported.
     */
    public final TrainedModelExportsMaxSize maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The files that are exported during the trained model export job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilesToExport} method.
     * </p>
     * 
     * @return The files that are exported during the trained model export job.
     */
    public final List<TrainedModelExportFileType> filesToExport() {
        return TrainedModelExportFileTypeListCopier.copyStringToEnum(filesToExport);
    }

    /**
     * For responses, this returns true if the service returned a value for the FilesToExport property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilesToExport() {
        return filesToExport != null && !(filesToExport instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The files that are exported during the trained model export job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilesToExport} method.
     * </p>
     * 
     * @return The files that are exported during the trained model export job.
     */
    public final List<String> filesToExportAsStrings() {
        return filesToExport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilesToExport() ? filesToExportAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelExportsConfigurationPolicy)) {
            return false;
        }
        TrainedModelExportsConfigurationPolicy other = (TrainedModelExportsConfigurationPolicy) obj;
        return Objects.equals(maxSize(), other.maxSize()) && hasFilesToExport() == other.hasFilesToExport()
                && Objects.equals(filesToExportAsStrings(), other.filesToExportAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainedModelExportsConfigurationPolicy").add("MaxSize", maxSize())
                .add("FilesToExport", hasFilesToExport() ? filesToExportAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "filesToExport":
            return Optional.ofNullable(clazz.cast(filesToExportAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxSize", MAX_SIZE_FIELD);
        map.put("filesToExport", FILES_TO_EXPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelExportsConfigurationPolicy, T> g) {
        return obj -> g.apply((TrainedModelExportsConfigurationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainedModelExportsConfigurationPolicy> {
        /**
         * <p>
         * The maximum size of the data that can be exported.
         * </p>
         * 
         * @param maxSize
         *        The maximum size of the data that can be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(TrainedModelExportsMaxSize maxSize);

        /**
         * <p>
         * The maximum size of the data that can be exported.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainedModelExportsMaxSize.Builder}
         * avoiding the need to create one manually via {@link TrainedModelExportsMaxSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainedModelExportsMaxSize.Builder#build()} is called immediately
         * and its result is passed to {@link #maxSize(TrainedModelExportsMaxSize)}.
         * 
         * @param maxSize
         *        a consumer that will call methods on {@link TrainedModelExportsMaxSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maxSize(TrainedModelExportsMaxSize)
         */
        default Builder maxSize(Consumer<TrainedModelExportsMaxSize.Builder> maxSize) {
            return maxSize(TrainedModelExportsMaxSize.builder().applyMutation(maxSize).build());
        }

        /**
         * <p>
         * The files that are exported during the trained model export job.
         * </p>
         * 
         * @param filesToExport
         *        The files that are exported during the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesToExportWithStrings(Collection<String> filesToExport);

        /**
         * <p>
         * The files that are exported during the trained model export job.
         * </p>
         * 
         * @param filesToExport
         *        The files that are exported during the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesToExportWithStrings(String... filesToExport);

        /**
         * <p>
         * The files that are exported during the trained model export job.
         * </p>
         * 
         * @param filesToExport
         *        The files that are exported during the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesToExport(Collection<TrainedModelExportFileType> filesToExport);

        /**
         * <p>
         * The files that are exported during the trained model export job.
         * </p>
         * 
         * @param filesToExport
         *        The files that are exported during the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesToExport(TrainedModelExportFileType... filesToExport);
    }

    static final class BuilderImpl implements Builder {
        private TrainedModelExportsMaxSize maxSize;

        private List<String> filesToExport = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelExportsConfigurationPolicy model) {
            maxSize(model.maxSize);
            filesToExportWithStrings(model.filesToExport);
        }

        public final TrainedModelExportsMaxSize.Builder getMaxSize() {
            return maxSize != null ? maxSize.toBuilder() : null;
        }

        public final void setMaxSize(TrainedModelExportsMaxSize.BuilderImpl maxSize) {
            this.maxSize = maxSize != null ? maxSize.build() : null;
        }

        @Override
        public final Builder maxSize(TrainedModelExportsMaxSize maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Collection<String> getFilesToExport() {
            if (filesToExport instanceof SdkAutoConstructList) {
                return null;
            }
            return filesToExport;
        }

        public final void setFilesToExport(Collection<String> filesToExport) {
            this.filesToExport = TrainedModelExportFileTypeListCopier.copy(filesToExport);
        }

        @Override
        public final Builder filesToExportWithStrings(Collection<String> filesToExport) {
            this.filesToExport = TrainedModelExportFileTypeListCopier.copy(filesToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesToExportWithStrings(String... filesToExport) {
            filesToExportWithStrings(Arrays.asList(filesToExport));
            return this;
        }

        @Override
        public final Builder filesToExport(Collection<TrainedModelExportFileType> filesToExport) {
            this.filesToExport = TrainedModelExportFileTypeListCopier.copyEnumToString(filesToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesToExport(TrainedModelExportFileType... filesToExport) {
            filesToExport(Arrays.asList(filesToExport));
            return this;
        }

        @Override
        public TrainedModelExportsConfigurationPolicy build() {
            return new TrainedModelExportsConfigurationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
