/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMlInputChannelsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListMlInputChannelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMlInputChannelsResponse.getter(ListMlInputChannelsResponse::nextToken)).setter(ListMlInputChannelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<MLInputChannelSummary>> ML_INPUT_CHANNELS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mlInputChannelsList").getter(ListMlInputChannelsResponse.getter(ListMlInputChannelsResponse::mlInputChannelsList)).setter(ListMlInputChannelsResponse.setter(Builder::mlInputChannelsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MLInputChannelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ML_INPUT_CHANNELS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMlInputChannelsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MLInputChannelSummary> mlInputChannelsList;

    private ListMlInputChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.mlInputChannelsList = builder.mlInputChannelsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMlInputChannelsList() {
        return this.mlInputChannelsList != null && !(this.mlInputChannelsList instanceof SdkAutoConstructList);
    }

    public final List<MLInputChannelSummary> mlInputChannelsList() {
        return this.mlInputChannelsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMlInputChannelsList() ? this.mlInputChannelsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMlInputChannelsResponse)) {
            return false;
        }
        ListMlInputChannelsResponse other = (ListMlInputChannelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMlInputChannelsList() == other.hasMlInputChannelsList() && Objects.equals(this.mlInputChannelsList(), other.mlInputChannelsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListMlInputChannelsResponse").add("NextToken", (Object)this.nextToken()).add("MlInputChannelsList", this.hasMlInputChannelsList() ? this.mlInputChannelsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "mlInputChannelsList": {
                return Optional.ofNullable(clazz.cast(this.mlInputChannelsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("mlInputChannelsList", ML_INPUT_CHANNELS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMlInputChannelsResponse, T> g) {
        return obj -> g.apply((ListMlInputChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MLInputChannelSummary> mlInputChannelsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMlInputChannelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.mlInputChannelsList(model.mlInputChannelsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MLInputChannelSummary.Builder> getMlInputChannelsList() {
            List<MLInputChannelSummary.Builder> result = MLInputChannelsListCopier.copyToBuilder(this.mlInputChannelsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMlInputChannelsList(Collection<MLInputChannelSummary.BuilderImpl> mlInputChannelsList) {
            this.mlInputChannelsList = MLInputChannelsListCopier.copyFromBuilder(mlInputChannelsList);
        }

        @Override
        public final Builder mlInputChannelsList(Collection<MLInputChannelSummary> mlInputChannelsList) {
            this.mlInputChannelsList = MLInputChannelsListCopier.copy(mlInputChannelsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mlInputChannelsList(MLInputChannelSummary ... mlInputChannelsList) {
            this.mlInputChannelsList(Arrays.asList(mlInputChannelsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mlInputChannelsList(Consumer<MLInputChannelSummary.Builder> ... mlInputChannelsList) {
            this.mlInputChannelsList(Stream.of(mlInputChannelsList).map(c -> (MLInputChannelSummary)((MLInputChannelSummary.Builder)MLInputChannelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMlInputChannelsResponse build() {
            return new ListMlInputChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMlInputChannelsResponse> {
        public Builder nextToken(String var1);

        public Builder mlInputChannelsList(Collection<MLInputChannelSummary> var1);

        public Builder mlInputChannelsList(MLInputChannelSummary ... var1);

        public Builder mlInputChannelsList(Consumer<MLInputChannelSummary.Builder> ... var1);
    }
}

