/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobSummary;

public class ListTrainedModelInferenceJobsIterable
implements SdkIterable<ListTrainedModelInferenceJobsResponse> {
    private final CleanRoomsMlClient client;
    private final ListTrainedModelInferenceJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrainedModelInferenceJobsIterable(CleanRoomsMlClient client, ListTrainedModelInferenceJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrainedModelInferenceJobsResponseFetcher();
    }

    public Iterator<ListTrainedModelInferenceJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrainedModelInferenceJobSummary> trainedModelInferenceJobs() {
        Function<ListTrainedModelInferenceJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainedModelInferenceJobs() != null) {
                return response.trainedModelInferenceJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrainedModelInferenceJobsResponseFetcher
    implements SyncPageFetcher<ListTrainedModelInferenceJobsResponse> {
        private ListTrainedModelInferenceJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainedModelInferenceJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrainedModelInferenceJobsResponse nextPage(ListTrainedModelInferenceJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainedModelInferenceJobsIterable.this.client.listTrainedModelInferenceJobs(ListTrainedModelInferenceJobsIterable.this.firstRequest);
            }
            return ListTrainedModelInferenceJobsIterable.this.client.listTrainedModelInferenceJobs((ListTrainedModelInferenceJobsRequest)((Object)ListTrainedModelInferenceJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

