/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainedModelInferenceJobsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListTrainedModelInferenceJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTrainedModelInferenceJobsResponse.getter(ListTrainedModelInferenceJobsResponse::nextToken)).setter(ListTrainedModelInferenceJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TrainedModelInferenceJobSummary>> TRAINED_MODEL_INFERENCE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trainedModelInferenceJobs").getter(ListTrainedModelInferenceJobsResponse.getter(ListTrainedModelInferenceJobsResponse::trainedModelInferenceJobs)).setter(ListTrainedModelInferenceJobsResponse.setter(Builder::trainedModelInferenceJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelInferenceJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrainedModelInferenceJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRAINED_MODEL_INFERENCE_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrainedModelInferenceJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<TrainedModelInferenceJobSummary> trainedModelInferenceJobs;

    private ListTrainedModelInferenceJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trainedModelInferenceJobs = builder.trainedModelInferenceJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTrainedModelInferenceJobs() {
        return this.trainedModelInferenceJobs != null && !(this.trainedModelInferenceJobs instanceof SdkAutoConstructList);
    }

    public final List<TrainedModelInferenceJobSummary> trainedModelInferenceJobs() {
        return this.trainedModelInferenceJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainedModelInferenceJobs() ? this.trainedModelInferenceJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainedModelInferenceJobsResponse)) {
            return false;
        }
        ListTrainedModelInferenceJobsResponse other = (ListTrainedModelInferenceJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTrainedModelInferenceJobs() == other.hasTrainedModelInferenceJobs() && Objects.equals(this.trainedModelInferenceJobs(), other.trainedModelInferenceJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainedModelInferenceJobsResponse").add("NextToken", (Object)this.nextToken()).add("TrainedModelInferenceJobs", this.hasTrainedModelInferenceJobs() ? this.trainedModelInferenceJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "trainedModelInferenceJobs": {
                return Optional.ofNullable(clazz.cast(this.trainedModelInferenceJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("trainedModelInferenceJobs", TRAINED_MODEL_INFERENCE_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrainedModelInferenceJobsResponse, T> g) {
        return obj -> g.apply((ListTrainedModelInferenceJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TrainedModelInferenceJobSummary> trainedModelInferenceJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainedModelInferenceJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.trainedModelInferenceJobs(model.trainedModelInferenceJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrainedModelInferenceJobSummary.Builder> getTrainedModelInferenceJobs() {
            List<TrainedModelInferenceJobSummary.Builder> result = TrainedModelInferenceJobListCopier.copyToBuilder(this.trainedModelInferenceJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainedModelInferenceJobs(Collection<TrainedModelInferenceJobSummary.BuilderImpl> trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs = TrainedModelInferenceJobListCopier.copyFromBuilder(trainedModelInferenceJobs);
        }

        @Override
        public final Builder trainedModelInferenceJobs(Collection<TrainedModelInferenceJobSummary> trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs = TrainedModelInferenceJobListCopier.copy(trainedModelInferenceJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainedModelInferenceJobs(TrainedModelInferenceJobSummary ... trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs(Arrays.asList(trainedModelInferenceJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainedModelInferenceJobs(Consumer<TrainedModelInferenceJobSummary.Builder> ... trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs(Stream.of(trainedModelInferenceJobs).map(c -> (TrainedModelInferenceJobSummary)((TrainedModelInferenceJobSummary.Builder)TrainedModelInferenceJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrainedModelInferenceJobsResponse build() {
            return new ListTrainedModelInferenceJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainedModelInferenceJobsResponse> {
        public Builder nextToken(String var1);

        public Builder trainedModelInferenceJobs(Collection<TrainedModelInferenceJobSummary> var1);

        public Builder trainedModelInferenceJobs(TrainedModelInferenceJobSummary ... var1);

        public Builder trainedModelInferenceJobs(Consumer<TrainedModelInferenceJobSummary.Builder> ... var1);
    }
}

