/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainedModelVersionsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListTrainedModelVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTrainedModelVersionsResponse.getter(ListTrainedModelVersionsResponse::nextToken)).setter(ListTrainedModelVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TrainedModelSummary>> TRAINED_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trainedModels").getter(ListTrainedModelVersionsResponse.getter(ListTrainedModelVersionsResponse::trainedModels)).setter(ListTrainedModelVersionsResponse.setter(Builder::trainedModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrainedModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRAINED_MODELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrainedModelVersionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<TrainedModelSummary> trainedModels;

    private ListTrainedModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trainedModels = builder.trainedModels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTrainedModels() {
        return this.trainedModels != null && !(this.trainedModels instanceof SdkAutoConstructList);
    }

    public final List<TrainedModelSummary> trainedModels() {
        return this.trainedModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainedModels() ? this.trainedModels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainedModelVersionsResponse)) {
            return false;
        }
        ListTrainedModelVersionsResponse other = (ListTrainedModelVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTrainedModels() == other.hasTrainedModels() && Objects.equals(this.trainedModels(), other.trainedModels());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainedModelVersionsResponse").add("NextToken", (Object)this.nextToken()).add("TrainedModels", this.hasTrainedModels() ? this.trainedModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "trainedModels": {
                return Optional.ofNullable(clazz.cast(this.trainedModels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("trainedModels", TRAINED_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrainedModelVersionsResponse, T> g) {
        return obj -> g.apply((ListTrainedModelVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TrainedModelSummary> trainedModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainedModelVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.trainedModels(model.trainedModels);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrainedModelSummary.Builder> getTrainedModels() {
            List<TrainedModelSummary.Builder> result = TrainedModelListCopier.copyToBuilder(this.trainedModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainedModels(Collection<TrainedModelSummary.BuilderImpl> trainedModels) {
            this.trainedModels = TrainedModelListCopier.copyFromBuilder(trainedModels);
        }

        @Override
        public final Builder trainedModels(Collection<TrainedModelSummary> trainedModels) {
            this.trainedModels = TrainedModelListCopier.copy(trainedModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainedModels(TrainedModelSummary ... trainedModels) {
            this.trainedModels(Arrays.asList(trainedModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainedModels(Consumer<TrainedModelSummary.Builder> ... trainedModels) {
            this.trainedModels(Stream.of(trainedModels).map(c -> (TrainedModelSummary)((TrainedModelSummary.Builder)TrainedModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrainedModelVersionsResponse build() {
            return new ListTrainedModelVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainedModelVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder trainedModels(Collection<TrainedModelSummary> var1);

        public Builder trainedModels(TrainedModelSummary ... var1);

        public Builder trainedModels(Consumer<TrainedModelSummary.Builder> ... var1);
    }
}

