/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceOutputConfiguration;
import software.amazon.awssdk.services.cleanroomsml.model.LogsStatus;
import software.amazon.awssdk.services.cleanroomsml.model.MetricsStatus;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainedModelInferenceJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainedModelInferenceJobSummary> {
    private static final SdkField<String> TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelInferenceJobArn").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::trainedModelInferenceJobArn)).setter(TrainedModelInferenceJobSummary.setter(Builder::trainedModelInferenceJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelInferenceJobArn").build()}).build();
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredModelAlgorithmAssociationArn").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::configuredModelAlgorithmAssociationArn)).setter(TrainedModelInferenceJobSummary.setter(Builder::configuredModelAlgorithmAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociationArn").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::membershipIdentifier)).setter(TrainedModelInferenceJobSummary.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::trainedModelArn)).setter(TrainedModelInferenceJobSummary.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_VERSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelVersionIdentifier").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::trainedModelVersionIdentifier)).setter(TrainedModelInferenceJobSummary.setter(Builder::trainedModelVersionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelVersionIdentifier").build()}).build();
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::collaborationIdentifier)).setter(TrainedModelInferenceJobSummary.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::statusAsString)).setter(TrainedModelInferenceJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<InferenceOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::outputConfiguration)).setter(TrainedModelInferenceJobSummary.setter(Builder::outputConfiguration)).constructor(InferenceOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::name)).setter(TrainedModelInferenceJobSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::description)).setter(TrainedModelInferenceJobSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> METRICS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricsStatus").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::metricsStatusAsString)).setter(TrainedModelInferenceJobSummary.setter(Builder::metricsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatus").build()}).build();
    private static final SdkField<String> METRICS_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricsStatusDetails").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::metricsStatusDetails)).setter(TrainedModelInferenceJobSummary.setter(Builder::metricsStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatusDetails").build()}).build();
    private static final SdkField<String> LOGS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logsStatus").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::logsStatusAsString)).setter(TrainedModelInferenceJobSummary.setter(Builder::logsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatus").build()}).build();
    private static final SdkField<String> LOGS_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logsStatusDetails").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::logsStatusDetails)).setter(TrainedModelInferenceJobSummary.setter(Builder::logsStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatusDetails").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::createTime)).setter(TrainedModelInferenceJobSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(TrainedModelInferenceJobSummary.getter(TrainedModelInferenceJobSummary::updateTime)).setter(TrainedModelInferenceJobSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, TRAINED_MODEL_ARN_FIELD, TRAINED_MODEL_VERSION_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, STATUS_FIELD, OUTPUT_CONFIGURATION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, METRICS_STATUS_FIELD, METRICS_STATUS_DETAILS_FIELD, LOGS_STATUS_FIELD, LOGS_STATUS_DETAILS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrainedModelInferenceJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trainedModelInferenceJobArn;
    private final String configuredModelAlgorithmAssociationArn;
    private final String membershipIdentifier;
    private final String trainedModelArn;
    private final String trainedModelVersionIdentifier;
    private final String collaborationIdentifier;
    private final String status;
    private final InferenceOutputConfiguration outputConfiguration;
    private final String name;
    private final String description;
    private final String metricsStatus;
    private final String metricsStatusDetails;
    private final String logsStatus;
    private final String logsStatusDetails;
    private final Instant createTime;
    private final Instant updateTime;

    private TrainedModelInferenceJobSummary(BuilderImpl builder) {
        this.trainedModelInferenceJobArn = builder.trainedModelInferenceJobArn;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.trainedModelArn = builder.trainedModelArn;
        this.trainedModelVersionIdentifier = builder.trainedModelVersionIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.status = builder.status;
        this.outputConfiguration = builder.outputConfiguration;
        this.name = builder.name;
        this.description = builder.description;
        this.metricsStatus = builder.metricsStatus;
        this.metricsStatusDetails = builder.metricsStatusDetails;
        this.logsStatus = builder.logsStatus;
        this.logsStatusDetails = builder.logsStatusDetails;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String trainedModelInferenceJobArn() {
        return this.trainedModelInferenceJobArn;
    }

    public final String configuredModelAlgorithmAssociationArn() {
        return this.configuredModelAlgorithmAssociationArn;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String trainedModelVersionIdentifier() {
        return this.trainedModelVersionIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final TrainedModelInferenceJobStatus status() {
        return TrainedModelInferenceJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final InferenceOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final MetricsStatus metricsStatus() {
        return MetricsStatus.fromValue(this.metricsStatus);
    }

    public final String metricsStatusAsString() {
        return this.metricsStatus;
    }

    public final String metricsStatusDetails() {
        return this.metricsStatusDetails;
    }

    public final LogsStatus logsStatus() {
        return LogsStatus.fromValue(this.logsStatus);
    }

    public final String logsStatusAsString() {
        return this.logsStatus;
    }

    public final String logsStatusDetails() {
        return this.logsStatusDetails;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelInferenceJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelInferenceJobSummary)) {
            return false;
        }
        TrainedModelInferenceJobSummary other = (TrainedModelInferenceJobSummary)obj;
        return Objects.equals(this.trainedModelInferenceJobArn(), other.trainedModelInferenceJobArn()) && Objects.equals(this.configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.trainedModelVersionIdentifier(), other.trainedModelVersionIdentifier()) && Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.metricsStatusAsString(), other.metricsStatusAsString()) && Objects.equals(this.metricsStatusDetails(), other.metricsStatusDetails()) && Objects.equals(this.logsStatusAsString(), other.logsStatusAsString()) && Objects.equals(this.logsStatusDetails(), other.logsStatusDetails()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"TrainedModelInferenceJobSummary").add("TrainedModelInferenceJobArn", (Object)this.trainedModelInferenceJobArn()).add("ConfiguredModelAlgorithmAssociationArn", (Object)this.configuredModelAlgorithmAssociationArn()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("TrainedModelArn", (Object)this.trainedModelArn()).add("TrainedModelVersionIdentifier", (Object)this.trainedModelVersionIdentifier()).add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("Status", (Object)this.statusAsString()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("MetricsStatus", (Object)this.metricsStatusAsString()).add("MetricsStatusDetails", (Object)this.metricsStatusDetails()).add("LogsStatus", (Object)this.logsStatusAsString()).add("LogsStatusDetails", (Object)this.logsStatusDetails()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trainedModelInferenceJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelInferenceJobArn()));
            }
            case "configuredModelAlgorithmAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociationArn()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "trainedModelVersionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.trainedModelVersionIdentifier()));
            }
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "metricsStatus": {
                return Optional.ofNullable(clazz.cast(this.metricsStatusAsString()));
            }
            case "metricsStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.metricsStatusDetails()));
            }
            case "logsStatus": {
                return Optional.ofNullable(clazz.cast(this.logsStatusAsString()));
            }
            case "logsStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.logsStatusDetails()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trainedModelInferenceJobArn", TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("trainedModelVersionIdentifier", TRAINED_MODEL_VERSION_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("metricsStatus", METRICS_STATUS_FIELD);
        map.put("metricsStatusDetails", METRICS_STATUS_DETAILS_FIELD);
        map.put("logsStatus", LOGS_STATUS_FIELD);
        map.put("logsStatusDetails", LOGS_STATUS_DETAILS_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelInferenceJobSummary, T> g) {
        return obj -> g.apply((TrainedModelInferenceJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainedModelInferenceJobArn;
        private String configuredModelAlgorithmAssociationArn;
        private String membershipIdentifier;
        private String trainedModelArn;
        private String trainedModelVersionIdentifier;
        private String collaborationIdentifier;
        private String status;
        private InferenceOutputConfiguration outputConfiguration;
        private String name;
        private String description;
        private String metricsStatus;
        private String metricsStatusDetails;
        private String logsStatus;
        private String logsStatusDetails;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelInferenceJobSummary model) {
            this.trainedModelInferenceJobArn(model.trainedModelInferenceJobArn);
            this.configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            this.membershipIdentifier(model.membershipIdentifier);
            this.trainedModelArn(model.trainedModelArn);
            this.trainedModelVersionIdentifier(model.trainedModelVersionIdentifier);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.status(model.status);
            this.outputConfiguration(model.outputConfiguration);
            this.name(model.name);
            this.description(model.description);
            this.metricsStatus(model.metricsStatus);
            this.metricsStatusDetails(model.metricsStatusDetails);
            this.logsStatus(model.logsStatus);
            this.logsStatusDetails(model.logsStatusDetails);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getTrainedModelInferenceJobArn() {
            return this.trainedModelInferenceJobArn;
        }

        public final void setTrainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
        }

        @Override
        public final Builder trainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return this.configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getTrainedModelVersionIdentifier() {
            return this.trainedModelVersionIdentifier;
        }

        public final void setTrainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
        }

        @Override
        public final Builder trainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelInferenceJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final InferenceOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(InferenceOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMetricsStatus() {
            return this.metricsStatus;
        }

        public final void setMetricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
        }

        @Override
        public final Builder metricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
            return this;
        }

        @Override
        public final Builder metricsStatus(MetricsStatus metricsStatus) {
            this.metricsStatus(metricsStatus == null ? null : metricsStatus.toString());
            return this;
        }

        public final String getMetricsStatusDetails() {
            return this.metricsStatusDetails;
        }

        public final void setMetricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
        }

        @Override
        public final Builder metricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
            return this;
        }

        public final String getLogsStatus() {
            return this.logsStatus;
        }

        public final void setLogsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
        }

        @Override
        public final Builder logsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
            return this;
        }

        @Override
        public final Builder logsStatus(LogsStatus logsStatus) {
            this.logsStatus(logsStatus == null ? null : logsStatus.toString());
            return this;
        }

        public final String getLogsStatusDetails() {
            return this.logsStatusDetails;
        }

        public final void setLogsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
        }

        @Override
        public final Builder logsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public TrainedModelInferenceJobSummary build() {
            return new TrainedModelInferenceJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainedModelInferenceJobSummary> {
        public Builder trainedModelInferenceJobArn(String var1);

        public Builder configuredModelAlgorithmAssociationArn(String var1);

        public Builder membershipIdentifier(String var1);

        public Builder trainedModelArn(String var1);

        public Builder trainedModelVersionIdentifier(String var1);

        public Builder collaborationIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(TrainedModelInferenceJobStatus var1);

        public Builder outputConfiguration(InferenceOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<InferenceOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((InferenceOutputConfiguration)((InferenceOutputConfiguration.Builder)InferenceOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder metricsStatus(String var1);

        public Builder metricsStatus(MetricsStatus var1);

        public Builder metricsStatusDetails(String var1);

        public Builder logsStatus(String var1);

        public Builder logsStatus(LogsStatus var1);

        public Builder logsStatusDetails(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

