/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainingInputMode {
    FILE("File"),
    FAST_FILE("FastFile"),
    PIPE("Pipe"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainingInputMode> VALUE_MAP;
    private final String value;

    private TrainingInputMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingInputMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingInputMode> knownValues() {
        EnumSet<TrainingInputMode> knownValues = EnumSet.allOf(TrainingInputMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainingInputMode.class, TrainingInputMode::toString);
    }
}

