/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncrementalTrainingDataChannel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IncrementalTrainingDataChannel> {
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(IncrementalTrainingDataChannel.getter(IncrementalTrainingDataChannel::trainedModelArn)).setter(IncrementalTrainingDataChannel.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> VERSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionIdentifier").getter(IncrementalTrainingDataChannel.getter(IncrementalTrainingDataChannel::versionIdentifier)).setter(IncrementalTrainingDataChannel.setter(Builder::versionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionIdentifier").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelName").getter(IncrementalTrainingDataChannel.getter(IncrementalTrainingDataChannel::channelName)).setter(IncrementalTrainingDataChannel.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODEL_ARN_FIELD, VERSION_IDENTIFIER_FIELD, CHANNEL_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IncrementalTrainingDataChannel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trainedModelArn;
    private final String versionIdentifier;
    private final String channelName;

    private IncrementalTrainingDataChannel(BuilderImpl builder) {
        this.trainedModelArn = builder.trainedModelArn;
        this.versionIdentifier = builder.versionIdentifier;
        this.channelName = builder.channelName;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String versionIdentifier() {
        return this.versionIdentifier;
    }

    public final String channelName() {
        return this.channelName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncrementalTrainingDataChannel)) {
            return false;
        }
        IncrementalTrainingDataChannel other = (IncrementalTrainingDataChannel)obj;
        return Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.versionIdentifier(), other.versionIdentifier()) && Objects.equals(this.channelName(), other.channelName());
    }

    public final String toString() {
        return ToString.builder((String)"IncrementalTrainingDataChannel").add("TrainedModelArn", (Object)this.trainedModelArn()).add("VersionIdentifier", (Object)this.versionIdentifier()).add("ChannelName", (Object)this.channelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "versionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.versionIdentifier()));
            }
            case "channelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("versionIdentifier", VERSION_IDENTIFIER_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncrementalTrainingDataChannel, T> g) {
        return obj -> g.apply((IncrementalTrainingDataChannel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainedModelArn;
        private String versionIdentifier;
        private String channelName;

        private BuilderImpl() {
        }

        private BuilderImpl(IncrementalTrainingDataChannel model) {
            this.trainedModelArn(model.trainedModelArn);
            this.versionIdentifier(model.versionIdentifier);
            this.channelName(model.channelName);
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getVersionIdentifier() {
            return this.versionIdentifier;
        }

        public final void setVersionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
        }

        @Override
        public final Builder versionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public IncrementalTrainingDataChannel build() {
            return new IncrementalTrainingDataChannel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IncrementalTrainingDataChannel> {
        public Builder trainedModelArn(String var1);

        public Builder versionIdentifier(String var1);

        public Builder channelName(String var1);
    }
}

