/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metrics that describe the quality of the generated audience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudienceQualityMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<AudienceQualityMetrics.Builder, AudienceQualityMetrics> {
    private static final SdkField<List<RelevanceMetric>> RELEVANCE_METRICS_FIELD = SdkField
            .<List<RelevanceMetric>> builder(MarshallingType.LIST)
            .memberName("relevanceMetrics")
            .getter(getter(AudienceQualityMetrics::relevanceMetrics))
            .setter(setter(Builder::relevanceMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelevanceMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelevanceMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> RECALL_METRIC_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("recallMetric").getter(getter(AudienceQualityMetrics::recallMetric))
            .setter(setter(Builder::recallMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recallMetric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEVANCE_METRICS_FIELD,
            RECALL_METRIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RelevanceMetric> relevanceMetrics;

    private final Double recallMetric;

    private AudienceQualityMetrics(BuilderImpl builder) {
        this.relevanceMetrics = builder.relevanceMetrics;
        this.recallMetric = builder.recallMetric;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelevanceMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelevanceMetrics() {
        return relevanceMetrics != null && !(relevanceMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The relevance scores of the generated audience.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelevanceMetrics} method.
     * </p>
     * 
     * @return The relevance scores of the generated audience.
     */
    public final List<RelevanceMetric> relevanceMetrics() {
        return relevanceMetrics;
    }

    /**
     * <p>
     * The recall score of the generated audience. Recall is the percentage of the most similar users (by default, the
     * most similar 20%) from a sample of the training data that are included in the seed audience by the audience
     * generation job. Values range from 0-1, larger values indicate a better audience. A recall value approximately
     * equal to the maximum bin size indicates that the audience model is equivalent to random selection.
     * </p>
     * 
     * @return The recall score of the generated audience. Recall is the percentage of the most similar users (by
     *         default, the most similar 20%) from a sample of the training data that are included in the seed audience
     *         by the audience generation job. Values range from 0-1, larger values indicate a better audience. A recall
     *         value approximately equal to the maximum bin size indicates that the audience model is equivalent to
     *         random selection.
     */
    public final Double recallMetric() {
        return recallMetric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRelevanceMetrics() ? relevanceMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recallMetric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceQualityMetrics)) {
            return false;
        }
        AudienceQualityMetrics other = (AudienceQualityMetrics) obj;
        return hasRelevanceMetrics() == other.hasRelevanceMetrics()
                && Objects.equals(relevanceMetrics(), other.relevanceMetrics())
                && Objects.equals(recallMetric(), other.recallMetric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudienceQualityMetrics")
                .add("RelevanceMetrics", hasRelevanceMetrics() ? relevanceMetrics() : null).add("RecallMetric", recallMetric())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relevanceMetrics":
            return Optional.ofNullable(clazz.cast(relevanceMetrics()));
        case "recallMetric":
            return Optional.ofNullable(clazz.cast(recallMetric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relevanceMetrics", RELEVANCE_METRICS_FIELD);
        map.put("recallMetric", RECALL_METRIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudienceQualityMetrics, T> g) {
        return obj -> g.apply((AudienceQualityMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudienceQualityMetrics> {
        /**
         * <p>
         * The relevance scores of the generated audience.
         * </p>
         * 
         * @param relevanceMetrics
         *        The relevance scores of the generated audience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevanceMetrics(Collection<RelevanceMetric> relevanceMetrics);

        /**
         * <p>
         * The relevance scores of the generated audience.
         * </p>
         * 
         * @param relevanceMetrics
         *        The relevance scores of the generated audience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevanceMetrics(RelevanceMetric... relevanceMetrics);

        /**
         * <p>
         * The relevance scores of the generated audience.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.RelevanceMetric.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cleanroomsml.model.RelevanceMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.RelevanceMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #relevanceMetrics(List<RelevanceMetric>)}.
         * 
         * @param relevanceMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.RelevanceMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relevanceMetrics(java.util.Collection<RelevanceMetric>)
         */
        Builder relevanceMetrics(Consumer<RelevanceMetric.Builder>... relevanceMetrics);

        /**
         * <p>
         * The recall score of the generated audience. Recall is the percentage of the most similar users (by default,
         * the most similar 20%) from a sample of the training data that are included in the seed audience by the
         * audience generation job. Values range from 0-1, larger values indicate a better audience. A recall value
         * approximately equal to the maximum bin size indicates that the audience model is equivalent to random
         * selection.
         * </p>
         * 
         * @param recallMetric
         *        The recall score of the generated audience. Recall is the percentage of the most similar users (by
         *        default, the most similar 20%) from a sample of the training data that are included in the seed
         *        audience by the audience generation job. Values range from 0-1, larger values indicate a better
         *        audience. A recall value approximately equal to the maximum bin size indicates that the audience model
         *        is equivalent to random selection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recallMetric(Double recallMetric);
    }

    static final class BuilderImpl implements Builder {
        private List<RelevanceMetric> relevanceMetrics = DefaultSdkAutoConstructList.getInstance();

        private Double recallMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceQualityMetrics model) {
            relevanceMetrics(model.relevanceMetrics);
            recallMetric(model.recallMetric);
        }

        public final List<RelevanceMetric.Builder> getRelevanceMetrics() {
            List<RelevanceMetric.Builder> result = RelevanceMetricsCopier.copyToBuilder(this.relevanceMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelevanceMetrics(Collection<RelevanceMetric.BuilderImpl> relevanceMetrics) {
            this.relevanceMetrics = RelevanceMetricsCopier.copyFromBuilder(relevanceMetrics);
        }

        @Override
        public final Builder relevanceMetrics(Collection<RelevanceMetric> relevanceMetrics) {
            this.relevanceMetrics = RelevanceMetricsCopier.copy(relevanceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relevanceMetrics(RelevanceMetric... relevanceMetrics) {
            relevanceMetrics(Arrays.asList(relevanceMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relevanceMetrics(Consumer<RelevanceMetric.Builder>... relevanceMetrics) {
            relevanceMetrics(Stream.of(relevanceMetrics).map(c -> RelevanceMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Double getRecallMetric() {
            return recallMetric;
        }

        public final void setRecallMetric(Double recallMetric) {
            this.recallMetric = recallMetric;
        }

        @Override
        public final Builder recallMetric(Double recallMetric) {
            this.recallMetric = recallMetric;
            return this;
        }

        @Override
        public AudienceQualityMetrics build() {
            return new AudienceQualityMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
